/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.core.CoreConstants;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallerData {
    public static final String NA = "?";
    private static final String LOG4J_CATEGORY = "org.apache.log4j.Category";
    private static final String SLF4J_BOUNDARY = "org.slf4j.Logger";
    public static final int LINE_NA = -1;
    public static final String CALLER_DATA_NA = "?#?:?" + CoreConstants.LINE_SEPARATOR;
    public static final StackTraceElement[] EMPTY_CALLER_DATA_ARRAY = new StackTraceElement[0];

    public static StackTraceElement[] extract(Throwable throwable, String string, int n, List<String> list) {
        int n2;
        if (throwable == null) {
            return null;
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n3 = -1;
        for (n2 = 0; n2 < stackTraceElementArray.length; ++n2) {
            if (CallerData.isInFrameworkSpace(stackTraceElementArray[n2].getClassName(), string, list)) {
                n3 = n2 + 1;
                continue;
            }
            if (n3 != -1) break;
        }
        if (n3 == -1) {
            return EMPTY_CALLER_DATA_ARRAY;
        }
        n2 = stackTraceElementArray.length - n3;
        int n4 = n < n2 ? n : n2;
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[n4];
        for (int i = 0; i < n4; ++i) {
            stackTraceElementArray2[i] = stackTraceElementArray[n3 + i];
        }
        return stackTraceElementArray2;
    }

    static boolean isInFrameworkSpace(String string, String string2, List<String> list) {
        return string.equals(string2) || string.equals(LOG4J_CATEGORY) || string.startsWith(SLF4J_BOUNDARY) || CallerData.isInFrameworkSpaceList(string, list);
    }

    private static boolean isInFrameworkSpaceList(String string, List<String> list) {
        if (list == null) {
            return false;
        }
        for (String string2 : list) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }
}

