/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.CoreConstants;

public class ThrowableProxyUtil {
    public static final int REGULAR_EXCEPTION_INDENT = 1;
    public static final int SUPPRESSED_EXCEPTION_INDENT = 2;

    public static void build(ThrowableProxy throwableProxy, Throwable throwable, ThrowableProxy throwableProxy2) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = -1;
        if (throwableProxy2 != null) {
            n = ThrowableProxyUtil.findNumberOfCommonFrames(stackTraceElementArray, throwableProxy2.getStackTraceElementProxyArray());
        }
        throwableProxy.commonFrames = n;
        throwableProxy.stackTraceElementProxyArray = ThrowableProxyUtil.steArrayToStepArray(stackTraceElementArray);
    }

    static StackTraceElementProxy[] steArrayToStepArray(StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray == null) {
            return new StackTraceElementProxy[0];
        }
        StackTraceElementProxy[] stackTraceElementProxyArray = new StackTraceElementProxy[stackTraceElementArray.length];
        for (int i = 0; i < stackTraceElementProxyArray.length; ++i) {
            stackTraceElementProxyArray[i] = new StackTraceElementProxy(stackTraceElementArray[i]);
        }
        return stackTraceElementProxyArray;
    }

    static int findNumberOfCommonFrames(StackTraceElement[] stackTraceElementArray, StackTraceElementProxy[] stackTraceElementProxyArray) {
        StackTraceElement stackTraceElement;
        StackTraceElement stackTraceElement2;
        if (stackTraceElementProxyArray == null || stackTraceElementArray == null) {
            return 0;
        }
        int n = stackTraceElementArray.length - 1;
        int n2 = 0;
        for (int i = stackTraceElementProxyArray.length - 1; n >= 0 && i >= 0 && (stackTraceElement2 = stackTraceElementArray[n]).equals(stackTraceElement = stackTraceElementProxyArray[i].ste); --n, --i) {
            ++n2;
        }
        return n2;
    }

    public static String asString(IThrowableProxy iThrowableProxy) {
        StringBuilder stringBuilder = new StringBuilder();
        ThrowableProxyUtil.recursiveAppend(stringBuilder, null, 1, iThrowableProxy);
        return stringBuilder.toString();
    }

    private static void recursiveAppend(StringBuilder stringBuilder, String string, int n, IThrowableProxy iThrowableProxy) {
        if (iThrowableProxy == null) {
            return;
        }
        ThrowableProxyUtil.subjoinFirstLine(stringBuilder, string, iThrowableProxy);
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        ThrowableProxyUtil.subjoinSTEPArray(stringBuilder, n, iThrowableProxy);
        IThrowableProxy[] iThrowableProxyArray = iThrowableProxy.getSuppressed();
        if (iThrowableProxyArray != null) {
            for (IThrowableProxy iThrowableProxy2 : iThrowableProxyArray) {
                ThrowableProxyUtil.recursiveAppend(stringBuilder, "\tSuppressed: ", 2, iThrowableProxy2);
            }
        }
        ThrowableProxyUtil.recursiveAppend(stringBuilder, "Caused by: ", 1, iThrowableProxy.getCause());
    }

    private static void subjoinFirstLine(StringBuilder stringBuilder, String string, IThrowableProxy iThrowableProxy) {
        if (string != null) {
            stringBuilder.append(string);
        }
        ThrowableProxyUtil.subjoinExceptionMessage(stringBuilder, iThrowableProxy);
    }

    public static void subjoinPackagingData(StringBuilder stringBuilder, StackTraceElementProxy stackTraceElementProxy) {
        ClassPackagingData classPackagingData;
        if (stackTraceElementProxy != null && (classPackagingData = stackTraceElementProxy.getClassPackagingData()) != null) {
            if (!classPackagingData.isExact()) {
                stringBuilder.append(" ~[");
            } else {
                stringBuilder.append(" [");
            }
            stringBuilder.append(classPackagingData.getCodeLocation()).append(':').append(classPackagingData.getVersion()).append(']');
        }
    }

    public static void subjoinSTEP(StringBuilder stringBuilder, StackTraceElementProxy stackTraceElementProxy) {
        stringBuilder.append(stackTraceElementProxy.toString());
        ThrowableProxyUtil.subjoinPackagingData(stringBuilder, stackTraceElementProxy);
    }

    public static void subjoinSTEPArray(StringBuilder stringBuilder, IThrowableProxy iThrowableProxy) {
        ThrowableProxyUtil.subjoinSTEPArray(stringBuilder, 1, iThrowableProxy);
    }

    public static void subjoinSTEPArray(StringBuilder stringBuilder, int n, IThrowableProxy iThrowableProxy) {
        int n2;
        StackTraceElementProxy[] stackTraceElementProxyArray = iThrowableProxy.getStackTraceElementProxyArray();
        int n3 = iThrowableProxy.getCommonFrames();
        for (n2 = 0; n2 < stackTraceElementProxyArray.length - n3; ++n2) {
            StackTraceElementProxy stackTraceElementProxy = stackTraceElementProxyArray[n2];
            for (int i = 0; i < n; ++i) {
                stringBuilder.append('\t');
            }
            ThrowableProxyUtil.subjoinSTEP(stringBuilder, stackTraceElementProxy);
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        }
        if (n3 > 0) {
            for (n2 = 0; n2 < n; ++n2) {
                stringBuilder.append('\t');
            }
            stringBuilder.append("... ").append(n3).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public static void subjoinFirstLine(StringBuilder stringBuilder, IThrowableProxy iThrowableProxy) {
        int n = iThrowableProxy.getCommonFrames();
        if (n > 0) {
            stringBuilder.append("Caused by: ");
        }
        ThrowableProxyUtil.subjoinExceptionMessage(stringBuilder, iThrowableProxy);
    }

    public static void subjoinFirstLineRootCauseFirst(StringBuilder stringBuilder, IThrowableProxy iThrowableProxy) {
        if (iThrowableProxy.getCause() != null) {
            stringBuilder.append("Wrapped by: ");
        }
        ThrowableProxyUtil.subjoinExceptionMessage(stringBuilder, iThrowableProxy);
    }

    private static void subjoinExceptionMessage(StringBuilder stringBuilder, IThrowableProxy iThrowableProxy) {
        stringBuilder.append(iThrowableProxy.getClassName()).append(": ").append(iThrowableProxy.getMessage());
    }
}

