/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TurboFilterList
extends CopyOnWriteArrayList<TurboFilter> {
    private static final long serialVersionUID = 1L;

    public FilterReply getTurboFilterChainDecision(Marker marker, Logger logger, Level level, String string, Object[] objectArray, Throwable throwable) {
        int n = this.size();
        if (n == 1) {
            try {
                TurboFilter turboFilter = (TurboFilter)this.get(0);
                return turboFilter.decide(marker, logger, level, string, objectArray, throwable);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return FilterReply.NEUTRAL;
            }
        }
        Object[] objectArray2 = this.toArray();
        int n2 = objectArray2.length;
        for (int i = 0; i < n2; ++i) {
            TurboFilter turboFilter = (TurboFilter)objectArray2[i];
            FilterReply filterReply = turboFilter.decide(marker, logger, level, string, objectArray, throwable);
            if (filterReply != FilterReply.DENY && filterReply != FilterReply.ACCEPT) continue;
            return filterReply;
        }
        return FilterReply.NEUTRAL;
    }
}

