/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.selector.DefaultContextSelector;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ContextSelectorStaticBinder {
    static ContextSelectorStaticBinder singleton = new ContextSelectorStaticBinder();
    ContextSelector contextSelector;
    Object key;

    public static ContextSelectorStaticBinder getSingleton() {
        return singleton;
    }

    public void init(LoggerContext loggerContext, Object object) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.key == null) {
            this.key = object;
        } else if (this.key != object) {
            throw new IllegalAccessException("Only certain classes can access this method.");
        }
        String string = OptionHelper.getSystemProperty("logback.ContextSelector");
        if (string == null) {
            this.contextSelector = new DefaultContextSelector(loggerContext);
        } else {
            if (string.equals("JNDI")) {
                throw new RuntimeException("JNDI not supported");
            }
            this.contextSelector = ContextSelectorStaticBinder.dynamicalContextSelector(loggerContext, string);
        }
    }

    static ContextSelector dynamicalContextSelector(LoggerContext loggerContext, String string) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = Loader.loadClass(string);
        Constructor constructor = clazz.getConstructor(LoggerContext.class);
        return (ContextSelector)constructor.newInstance(loggerContext);
    }

    public ContextSelector getContextSelector() {
        return this.contextSelector;
    }
}

