/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.util.OptionHelper;

public class StatusListenerConfigHelper {
    static void installIfAsked(LoggerContext loggerContext) {
        String string = OptionHelper.getSystemProperty("logback.statusListenerClass");
        if (!OptionHelper.isEmpty(string)) {
            StatusListenerConfigHelper.addStatusListener(loggerContext, string);
        }
    }

    static void addStatusListener(LoggerContext loggerContext, String string) {
        try {
            StatusListener statusListener = (StatusListener)OptionHelper.instantiateByClassName(string, StatusListener.class, loggerContext);
            if (statusListener instanceof ContextAware) {
                ((ContextAware)((Object)statusListener)).setContext(loggerContext);
            }
            if (statusListener instanceof LifeCycle) {
                ((LifeCycle)((Object)statusListener)).start();
            }
            if (statusListener != null) {
                loggerContext.getStatusManager().add(statusListener);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

