/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.joran.spi.ConsoleTarget;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.OptionHelper;
import java.io.OutputStream;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleAppender<E>
extends OutputStreamAppender<E> {
    protected ConsoleTarget target = ConsoleTarget.SystemOut;
    protected boolean withJansi = false;
    private static final String WindowsAnsiOutputStream_CLASS_NAME = "org.fusesource.jansi.WindowsAnsiOutputStream";

    public void setTarget(String string) {
        ConsoleTarget consoleTarget = ConsoleTarget.findByName(string.trim());
        if (consoleTarget == null) {
            this.targetWarn(string);
        } else {
            this.target = consoleTarget;
        }
    }

    public String getTarget() {
        return this.target.getName();
    }

    private void targetWarn(String string) {
        WarnStatus warnStatus = new WarnStatus("[" + string + "] should be one of " + Arrays.toString((Object[])ConsoleTarget.values()), this);
        warnStatus.add(new WarnStatus("Using previously set target, System.out by default.", this));
        this.addStatus(warnStatus);
    }

    @Override
    public void start() {
        OutputStream outputStream = this.target.getStream();
        if (EnvUtil.isWindows() && this.withJansi) {
            outputStream = this.getTargetStreamForWindows(outputStream);
        }
        this.setOutputStream(outputStream);
        super.start();
    }

    private OutputStream getTargetStreamForWindows(OutputStream outputStream) {
        try {
            this.addInfo("Enabling JANSI WindowsAnsiOutputStream for the console.");
            Object object = OptionHelper.instantiateByClassNameAndParameter(WindowsAnsiOutputStream_CLASS_NAME, Object.class, this.context, OutputStream.class, (Object)outputStream);
            return (OutputStream)object;
        }
        catch (Exception exception) {
            this.addWarn("Failed to create WindowsAnsiOutputStream. Falling back on the default stream.", exception);
            return outputStream;
        }
    }

    public boolean isWithJansi() {
        return this.withJansi;
    }

    public void setWithJansi(boolean bl) {
        this.withJansi = bl;
    }
}

