/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.BasicStatusManager;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.LogbackLock;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.EnvUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextBase
implements Context {
    private long birthTime = System.currentTimeMillis();
    private String name;
    private StatusManager sm = new BasicStatusManager();
    Map<String, String> propertyMap = new HashMap<String, String>();
    Map<String, Object> objectMap = new HashMap<String, Object>();
    LogbackLock configurationLock = new LogbackLock();
    private static final int CORE_POOL_SIZE = EnvUtil.isJDK5() ? 1 : 0;
    ExecutorService executorService = new ThreadPoolExecutor(CORE_POOL_SIZE, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    @Override
    public StatusManager getStatusManager() {
        return this.sm;
    }

    public void setStatusManager(StatusManager statusManager) {
        if (this.sm == null) {
            throw new IllegalArgumentException("null StatusManager not allowed");
        }
        this.sm = statusManager;
    }

    @Override
    public Map<String, String> getCopyOfPropertyMap() {
        return new HashMap<String, String>(this.propertyMap);
    }

    @Override
    public void putProperty(String string, String string2) {
        this.propertyMap.put(string, string2);
    }

    @Override
    public String getProperty(String string) {
        if ("CONTEXT_NAME".equals(string)) {
            return this.getName();
        }
        return this.propertyMap.get(string);
    }

    @Override
    public Object getObject(String string) {
        return this.objectMap.get(string);
    }

    @Override
    public void putObject(String string, Object object) {
        this.objectMap.put(string, object);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void reset() {
        this.propertyMap.clear();
        this.objectMap.clear();
    }

    @Override
    public void setName(String string) throws IllegalStateException {
        if (string != null && string.equals(this.name)) {
            return;
        }
        if (this.name != null && !"default".equals(this.name)) {
            throw new IllegalStateException("Context has been already given a name");
        }
        this.name = string;
    }

    @Override
    public long getBirthTime() {
        return this.birthTime;
    }

    @Override
    public Object getConfigurationLock() {
        return this.configurationLock;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public String toString() {
        return this.name;
    }
}

