/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.boolex;

import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Matcher
extends ContextAwareBase
implements LifeCycle {
    private String regex;
    private String name;
    private boolean caseSensitive = true;
    private boolean canonEq = false;
    private boolean unicodeCase = false;
    private boolean start = false;
    private Pattern pattern;

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String string) {
        this.regex = string;
    }

    public void start() {
        if (this.name == null) {
            this.addError("All Matcher objects must be named");
            return;
        }
        try {
            int n = 0;
            if (!this.caseSensitive) {
                n |= 2;
            }
            if (this.canonEq) {
                n |= 0x80;
            }
            if (this.unicodeCase) {
                n |= 0x40;
            }
            this.pattern = Pattern.compile(this.regex, n);
            this.start = true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.addError("Failed to compile regex [" + this.regex + "]", patternSyntaxException);
        }
    }

    public void stop() {
        this.start = false;
    }

    public boolean isStarted() {
        return this.start;
    }

    public boolean matches(String string) throws EvaluationException {
        if (this.start) {
            java.util.regex.Matcher matcher = this.pattern.matcher(string);
            return matcher.find();
        }
        throw new EvaluationException("Matcher [" + this.regex + "] not started");
    }

    public boolean isCanonEq() {
        return this.canonEq;
    }

    public void setCanonEq(boolean bl) {
        this.canonEq = bl;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public boolean isUnicodeCase() {
        return this.unicodeCase;
    }

    public void setUnicodeCase(boolean bl) {
        this.unicodeCase = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }
}

