/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.db;

import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.db.ConnectionSource;
import ch.qos.logback.core.db.DBHelper;
import ch.qos.logback.core.db.dialect.DBUtil;
import ch.qos.logback.core.db.dialect.SQLDialect;
import ch.qos.logback.core.db.dialect.SQLDialectCode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBAppenderBase<E>
extends UnsynchronizedAppenderBase<E> {
    protected ConnectionSource connectionSource;
    protected boolean cnxSupportsGetGeneratedKeys = false;
    protected boolean cnxSupportsBatchUpdates = false;
    protected SQLDialect sqlDialect;

    protected abstract Method getGeneratedKeysMethod();

    protected abstract String getInsertSQL();

    @Override
    public void start() {
        if (this.connectionSource == null) {
            throw new IllegalStateException("DBAppender cannot function without a connection source");
        }
        this.sqlDialect = DBUtil.getDialectFromCode(this.connectionSource.getSQLDialectCode());
        this.cnxSupportsGetGeneratedKeys = this.getGeneratedKeysMethod() != null ? this.connectionSource.supportsGetGeneratedKeys() : false;
        this.cnxSupportsBatchUpdates = this.connectionSource.supportsBatchUpdates();
        if (!this.cnxSupportsGetGeneratedKeys && this.sqlDialect == null) {
            throw new IllegalStateException("DBAppender cannot function if the JDBC driver does not support getGeneratedKeys method *and* without a specific SQL dialect");
        }
        super.start();
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(E e) {
        Connection connection = null;
        try {
            long l;
            PreparedStatement preparedStatement;
            connection = this.connectionSource.getConnection();
            connection.setAutoCommit(false);
            if (this.cnxSupportsGetGeneratedKeys) {
                String string = "EVENT_ID";
                if (this.connectionSource.getSQLDialectCode() == SQLDialectCode.POSTGRES_DIALECT) {
                    string = string.toLowerCase();
                }
                preparedStatement = connection.prepareStatement(this.getInsertSQL(), new String[]{string});
            } else {
                preparedStatement = connection.prepareStatement(this.getInsertSQL());
            }
            DBAppenderBase dBAppenderBase = this;
            synchronized (dBAppenderBase) {
                this.subAppend(e, connection, preparedStatement);
                l = this.selectEventId(preparedStatement, connection);
            }
            this.secondarySubAppend(e, connection, l);
            this.close(preparedStatement);
            connection.commit();
        }
        catch (Throwable throwable) {
            this.addError("problem appending event", throwable);
        }
        finally {
            DBHelper.closeConnection(connection);
        }
    }

    protected abstract void subAppend(E var1, Connection var2, PreparedStatement var3) throws Throwable;

    protected abstract void secondarySubAppend(E var1, Connection var2, long var3) throws Throwable;

    protected long selectEventId(PreparedStatement preparedStatement, Connection connection) throws SQLException, InvocationTargetException {
        ResultSet resultSet = null;
        Statement statement = null;
        boolean bl = false;
        if (this.cnxSupportsGetGeneratedKeys) {
            try {
                resultSet = (ResultSet)this.getGeneratedKeysMethod().invoke((Object)preparedStatement, (Object[])null);
                bl = true;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SQLException) {
                    throw (SQLException)throwable;
                }
                throw invocationTargetException;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.addWarn("IllegalAccessException invoking PreparedStatement.getGeneratedKeys", illegalAccessException);
            }
        }
        if (!bl) {
            statement = connection.createStatement();
            statement.setMaxRows(1);
            String string = this.sqlDialect.getSelectInsertId();
            resultSet = statement.executeQuery(string);
        }
        resultSet.next();
        long l = resultSet.getLong(1);
        resultSet.close();
        this.close(statement);
        return l;
    }

    void close(Statement statement) throws SQLException {
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public void stop() {
        super.stop();
    }
}

