/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.db.dialect;

import ch.qos.logback.core.db.dialect.H2Dialect;
import ch.qos.logback.core.db.dialect.HSQLDBDialect;
import ch.qos.logback.core.db.dialect.MsSQLDialect;
import ch.qos.logback.core.db.dialect.MySQLDialect;
import ch.qos.logback.core.db.dialect.OracleDialect;
import ch.qos.logback.core.db.dialect.PostgreSQLDialect;
import ch.qos.logback.core.db.dialect.SQLDialect;
import ch.qos.logback.core.db.dialect.SQLDialectCode;
import ch.qos.logback.core.db.dialect.SQLiteDialect;
import ch.qos.logback.core.db.dialect.SybaseSqlAnywhereDialect;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class DBUtil
extends ContextAwareBase {
    private static final String POSTGRES_PART = "postgresql";
    private static final String MYSQL_PART = "mysql";
    private static final String ORACLE_PART = "oracle";
    private static final String MSSQL_PART = "microsoft";
    private static final String HSQL_PART = "hsql";
    private static final String H2_PART = "h2";
    private static final String SYBASE_SQLANY_PART = "sql anywhere";
    private static final String SQLITE_PART = "sqlite";

    public static SQLDialectCode discoverSQLDialect(DatabaseMetaData databaseMetaData) {
        SQLDialectCode sQLDialectCode = SQLDialectCode.UNKNOWN_DIALECT;
        try {
            String string = databaseMetaData.getDatabaseProductName().toLowerCase();
            if (string.indexOf(POSTGRES_PART) != -1) {
                return SQLDialectCode.POSTGRES_DIALECT;
            }
            if (string.indexOf(MYSQL_PART) != -1) {
                return SQLDialectCode.MYSQL_DIALECT;
            }
            if (string.indexOf(ORACLE_PART) != -1) {
                return SQLDialectCode.ORACLE_DIALECT;
            }
            if (string.indexOf(MSSQL_PART) != -1) {
                return SQLDialectCode.MSSQL_DIALECT;
            }
            if (string.indexOf(HSQL_PART) != -1) {
                return SQLDialectCode.HSQL_DIALECT;
            }
            if (string.indexOf(H2_PART) != -1) {
                return SQLDialectCode.H2_DIALECT;
            }
            if (string.indexOf(SYBASE_SQLANY_PART) != -1) {
                return SQLDialectCode.SYBASE_SQLANYWHERE_DIALECT;
            }
            if (string.indexOf(SQLITE_PART) != -1) {
                return SQLDialectCode.SQLITE_DIALECT;
            }
            return SQLDialectCode.UNKNOWN_DIALECT;
        }
        catch (SQLException sQLException) {
            return sQLDialectCode;
        }
    }

    public static SQLDialect getDialectFromCode(SQLDialectCode sQLDialectCode) {
        SQLDialect sQLDialect = null;
        switch (sQLDialectCode) {
            case POSTGRES_DIALECT: {
                sQLDialect = new PostgreSQLDialect();
                break;
            }
            case MYSQL_DIALECT: {
                sQLDialect = new MySQLDialect();
                break;
            }
            case ORACLE_DIALECT: {
                sQLDialect = new OracleDialect();
                break;
            }
            case MSSQL_DIALECT: {
                sQLDialect = new MsSQLDialect();
                break;
            }
            case HSQL_DIALECT: {
                sQLDialect = new HSQLDBDialect();
                break;
            }
            case H2_DIALECT: {
                sQLDialect = new H2Dialect();
                break;
            }
            case SYBASE_SQLANYWHERE_DIALECT: {
                sQLDialect = new SybaseSqlAnywhereDialect();
                break;
            }
            case SQLITE_DIALECT: {
                sQLDialect = new SQLiteDialect();
            }
        }
        return sQLDialect;
    }

    public boolean supportsGetGeneratedKeys(DatabaseMetaData databaseMetaData) {
        try {
            return (Boolean)DatabaseMetaData.class.getMethod("supportsGetGeneratedKeys", null).invoke((Object)databaseMetaData, (Object[])null);
        }
        catch (Throwable throwable) {
            this.addInfo("Could not call supportsGetGeneratedKeys method. This may be recoverable");
            return false;
        }
    }

    public boolean supportsBatchUpdates(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.supportsBatchUpdates();
        }
        catch (Throwable throwable) {
            this.addInfo("Missing DatabaseMetaData.supportsBatchUpdates method.");
            return false;
        }
    }
}

