/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.AbstractIncludeAction;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public class IncludeAction
extends AbstractIncludeAction {
    private static final String INCLUDED_TAG = "included";
    private static final String CONFIG_TAG = "configuration";
    private int eventOffset = 2;

    protected void setEventOffset(int n) {
        this.eventOffset = n;
    }

    protected SaxEventRecorder createRecorder(InputStream inputStream, URL uRL) {
        return new SaxEventRecorder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInclude(InterpretationContext interpretationContext, URL uRL) throws JoranException {
        InputStream inputStream = this.openURL(uRL);
        try {
            if (inputStream != null) {
                ConfigurationWatchListUtil.addToWatchList(this.getContext(), uRL);
                SaxEventRecorder saxEventRecorder = this.createRecorder(inputStream, uRL);
                saxEventRecorder.setContext(this.getContext());
                saxEventRecorder.recordEvents(inputStream);
                this.trimHeadAndTail(saxEventRecorder);
                interpretationContext.getJoranInterpreter().getEventPlayer().addEventsDynamically(saxEventRecorder.getSaxEventList(), this.eventOffset);
            }
        }
        catch (JoranException joranException) {
            this.addError("Failed processing [" + uRL.toString() + "]", joranException);
        }
        finally {
            this.close(inputStream);
        }
    }

    private InputStream openURL(URL uRL) {
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            String string = "Failed to open [" + uRL.toString() + "]";
            this.addError(string, iOException);
            return null;
        }
    }

    private void trimHeadAndTail(SaxEventRecorder saxEventRecorder) {
        List<SaxEvent> list = saxEventRecorder.getSaxEventList();
        if (list.size() == 0) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        SaxEvent saxEvent = list.get(0);
        if (saxEvent != null) {
            bl = INCLUDED_TAG.equalsIgnoreCase(saxEvent.qName);
            bl2 = CONFIG_TAG.equalsIgnoreCase(saxEvent.qName);
        }
        if (bl || bl2) {
            list.remove(0);
            int n = list.size();
            if (n == 0) {
                return;
            }
            int n2 = n - 1;
            SaxEvent saxEvent2 = list.get(n2);
            if (saxEvent2 != null && bl && INCLUDED_TAG.equalsIgnoreCase(saxEvent2.qName) || bl2 && CONFIG_TAG.equalsIgnoreCase(saxEvent2.qName)) {
                list.remove(n2);
            }
        }
    }
}

