/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SimpleRuleStore
extends ContextAwareBase
implements RuleStore {
    static String ANY = "*";
    HashMap<Pattern, List<Action>> rules = new HashMap();

    public SimpleRuleStore(Context context) {
        this.setContext(context);
    }

    public void addRule(Pattern pattern, Action action) {
        action.setContext(this.context);
        List<Action> list = this.rules.get(pattern);
        if (list == null) {
            list = new ArrayList<Action>();
            this.rules.put(pattern, list);
        }
        list.add(action);
    }

    public void addRule(Pattern pattern, String string) {
        Action action = null;
        try {
            action = (Action)OptionHelper.instantiateByClassName(string, Action.class, this.context);
        }
        catch (Exception exception) {
            this.addError("Could not instantiate class [" + string + "]", exception);
        }
        if (action != null) {
            this.addRule(pattern, action);
        }
    }

    public List matchActions(Pattern pattern) {
        List list = this.rules.get(pattern);
        if (list != null) {
            return list;
        }
        list = this.tailMatch(pattern);
        if (list != null) {
            return list;
        }
        list = this.prefixMatch(pattern);
        if (list != null) {
            return list;
        }
        list = this.middleMatch(pattern);
        if (list != null) {
            return list;
        }
        return null;
    }

    List tailMatch(Pattern pattern) {
        int n = 0;
        Pattern pattern2 = null;
        for (Pattern pattern3 : this.rules.keySet()) {
            int n2;
            if (pattern3.size() <= 1 || !pattern3.get(0).equals(ANY) || (n2 = pattern.getTailMatchLength(pattern3)) <= n) continue;
            n = n2;
            pattern2 = pattern3;
        }
        if (pattern2 != null) {
            return this.rules.get(pattern2);
        }
        return null;
    }

    List prefixMatch(Pattern pattern) {
        int n = 0;
        Pattern pattern2 = null;
        for (Pattern pattern3 : this.rules.keySet()) {
            int n2;
            String string = pattern3.peekLast();
            if (!ANY.equals(string) || (n2 = pattern.getPrefixMatchLength(pattern3)) != pattern3.size() - 1 || n2 <= n) continue;
            n = n2;
            pattern2 = pattern3;
        }
        if (pattern2 != null) {
            return this.rules.get(pattern2);
        }
        return null;
    }

    List middleMatch(Pattern pattern) {
        int n = 0;
        Pattern pattern2 = null;
        for (Pattern pattern3 : this.rules.keySet()) {
            String string = pattern3.peekLast();
            String string2 = null;
            if (pattern3.size() > 1) {
                string2 = pattern3.get(0);
            }
            if (!ANY.equals(string) || !ANY.equals(string2)) continue;
            List<String> list = pattern3.getCopyOfPartList();
            if (list.size() > 2) {
                list.remove(0);
                list.remove(list.size() - 1);
            }
            int n2 = 0;
            Pattern pattern4 = new Pattern(list);
            if (pattern.isContained(pattern4)) {
                n2 = pattern4.size();
            }
            if (n2 <= n) continue;
            n = n2;
            pattern2 = pattern3;
        }
        if (pattern2 != null) {
            return this.rules.get(pattern2);
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SimpleRuleStore ( ").append("rules = ").append(this.rules).append("  ").append(" )");
        return stringBuilder.toString();
    }
}

