/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SocketAppenderBase<E>
extends AppenderBase<E> {
    static final int DEFAULT_PORT = 4560;
    static final int DEFAULT_RECONNECTION_DELAY = 30000;
    protected String remoteHost;
    protected InetAddress address;
    protected int port = 4560;
    protected ObjectOutputStream oos;
    protected Socket socket;
    protected int reconnectionDelay = 30000;
    private Connector connector;
    private boolean initialized = false;
    private boolean lazyInit = false;
    protected int counter = 0;

    @Override
    public void start() {
        int n = 0;
        if (this.port == 0) {
            ++n;
            this.addError("No port was configured for appender" + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_port");
        }
        if (this.address == null) {
            ++n;
            this.addError("No remote address was configured for appender" + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_host");
        }
        if (!this.lazyInit) {
            this.connect(this.address, this.port);
        }
        if (n == 0) {
            this.started = true;
        }
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.started = false;
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (IOException iOException) {
                this.addError("Could not close oos.", iOException);
            }
            this.oos = null;
        }
        if (this.connector != null) {
            this.addInfo("Interrupting the connector.");
            this.connector.interrupted = true;
            this.connector = null;
        }
    }

    void connect(InetAddress inetAddress, int n) {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.socket = new Socket(inetAddress, n);
            this.oos = new ObjectOutputStream(this.socket.getOutputStream());
        }
        catch (IOException iOException) {
            String string = "Could not connect to remote logback server at [" + inetAddress.getHostName() + "].";
            if (this.reconnectionDelay > 0) {
                string = string + " We will try again later.";
                this.fireConnector();
            }
            this.addInfo(string, iOException);
        }
    }

    @Override
    protected void append(E e) {
        block10: {
            if (e == null) {
                return;
            }
            if (this.address == null) {
                this.addError("No remote host is set for SocketAppender named \"" + this.name + "\". For more information, please visit http://logback.qos.ch/codes.html#socket_no_host");
                return;
            }
            if (!this.initialized && this.lazyInit) {
                this.initialized = true;
                this.connect(this.address, this.port);
            }
            if (this.oos != null) {
                try {
                    this.postProcessEvent(e);
                    Serializable serializable = this.getPST().transform(e);
                    this.oos.writeObject(serializable);
                    this.oos.flush();
                    if (++this.counter >= 70) {
                        this.counter = 0;
                        this.oos.reset();
                    }
                }
                catch (IOException iOException) {
                    if (this.oos != null) {
                        try {
                            this.oos.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    this.oos = null;
                    this.addWarn("Detected problem with connection: " + iOException);
                    if (this.reconnectionDelay <= 0) break block10;
                    this.fireConnector();
                }
            }
        }
    }

    protected abstract void postProcessEvent(E var1);

    protected abstract PreSerializationTransformer<E> getPST();

    void fireConnector() {
        if (this.connector == null) {
            this.addInfo("Starting a new connector thread.");
            this.connector = new Connector();
            this.connector.setDaemon(true);
            this.connector.setPriority(1);
            this.connector.start();
        }
    }

    protected static InetAddress getAddressByName(String string) {
        try {
            return InetAddress.getByName(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setRemoteHost(String string) {
        this.address = SocketAppenderBase.getAddressByName(string);
        this.remoteHost = string;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    public void setReconnectionDelay(int n) {
        this.reconnectionDelay = n;
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public boolean getLazy() {
        return this.lazyInit;
    }

    public void setLazy(boolean bl) {
        this.lazyInit = bl;
    }

    class Connector
    extends Thread {
        boolean interrupted = false;

        Connector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.interrupted) {
                try {
                    Connector.sleep(SocketAppenderBase.this.reconnectionDelay);
                    SocketAppenderBase.this.addInfo("Attempting connection to " + SocketAppenderBase.this.address.getHostName());
                    Socket socket = new Socket(SocketAppenderBase.this.address, SocketAppenderBase.this.port);
                    Connector connector = this;
                    synchronized (connector) {
                        SocketAppenderBase.this.oos = new ObjectOutputStream(socket.getOutputStream());
                        SocketAppenderBase.this.connector = null;
                        SocketAppenderBase.this.addInfo("Connection established. Exiting connector thread.");
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    SocketAppenderBase.this.addInfo("Connector interrupted. Leaving loop.");
                    return;
                }
                catch (ConnectException connectException) {
                    SocketAppenderBase.this.addInfo("Remote host " + SocketAppenderBase.this.address.getHostName() + " refused connection. " + connectException.getMessage());
                }
                catch (IOException iOException) {
                    SocketAppenderBase.this.addInfo("Could not connect to " + SocketAppenderBase.this.address.getHostName() + ". Exception is " + iOException);
                }
            }
        }
    }
}

