/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.net.SyslogOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.UnknownHostException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SyslogAppenderBase<E>
extends AppenderBase<E> {
    static final String SYSLOG_LAYOUT_URL = "http://logback.qos.ch/codes.html#syslog_layout";
    static final int MSG_SIZE_LIMIT = 262144;
    Layout<E> layout;
    String facilityStr;
    String syslogHost;
    protected String suffixPattern;
    protected SyslogOutputStream sos;
    int port = 514;
    boolean initialized = false;
    private boolean lazyInit = false;

    @Override
    public void start() {
        int n = 0;
        if (this.facilityStr == null) {
            this.addError("The Facility option is mandatory");
            ++n;
        }
        if (!this.lazyInit && !this.connect()) {
            ++n;
        }
        if (this.layout == null) {
            this.layout = this.buildLayout();
        }
        if (n == 0) {
            super.start();
        }
    }

    public abstract Layout<E> buildLayout();

    public abstract int getSeverityForEvent(Object var1);

    private boolean connect() {
        try {
            this.sos = new SyslogOutputStream(this.syslogHost, this.port);
        }
        catch (UnknownHostException unknownHostException) {
            this.addError("Could not create SyslogWriter", unknownHostException);
        }
        catch (SocketException socketException) {
            this.addWarn("Failed to bind to a random datagram socket", socketException);
        }
        return this.sos != null;
    }

    @Override
    protected void append(E e) {
        if (!this.isStarted()) {
            return;
        }
        if (!this.initialized && this.lazyInit) {
            this.initialized = true;
            this.connect();
        }
        if (this.sos == null) {
            return;
        }
        try {
            String string = this.layout.doLayout(e);
            if (string == null) {
                return;
            }
            if (string.length() > 262144) {
                string = string.substring(0, 262144);
            }
            this.sos.write(string.getBytes());
            this.sos.flush();
            this.postProcess(e, this.sos);
        }
        catch (IOException iOException) {
            this.addError("Failed to send diagram to " + this.syslogHost, iOException);
        }
    }

    protected void postProcess(Object object, OutputStream outputStream) {
    }

    public static int facilityStringToint(String string) {
        if ("KERN".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("USER".equalsIgnoreCase(string)) {
            return 8;
        }
        if ("MAIL".equalsIgnoreCase(string)) {
            return 16;
        }
        if ("DAEMON".equalsIgnoreCase(string)) {
            return 24;
        }
        if ("AUTH".equalsIgnoreCase(string)) {
            return 32;
        }
        if ("SYSLOG".equalsIgnoreCase(string)) {
            return 40;
        }
        if ("LPR".equalsIgnoreCase(string)) {
            return 48;
        }
        if ("NEWS".equalsIgnoreCase(string)) {
            return 56;
        }
        if ("UUCP".equalsIgnoreCase(string)) {
            return 64;
        }
        if ("CRON".equalsIgnoreCase(string)) {
            return 72;
        }
        if ("AUTHPRIV".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("FTP".equalsIgnoreCase(string)) {
            return 88;
        }
        if ("LOCAL0".equalsIgnoreCase(string)) {
            return 128;
        }
        if ("LOCAL1".equalsIgnoreCase(string)) {
            return 136;
        }
        if ("LOCAL2".equalsIgnoreCase(string)) {
            return 144;
        }
        if ("LOCAL3".equalsIgnoreCase(string)) {
            return 152;
        }
        if ("LOCAL4".equalsIgnoreCase(string)) {
            return 160;
        }
        if ("LOCAL5".equalsIgnoreCase(string)) {
            return 168;
        }
        if ("LOCAL6".equalsIgnoreCase(string)) {
            return 176;
        }
        if ("LOCAL7".equalsIgnoreCase(string)) {
            return 184;
        }
        throw new IllegalArgumentException(string + " is not a valid syslog facility string");
    }

    public String getSyslogHost() {
        return this.syslogHost;
    }

    public void setSyslogHost(String string) {
        this.syslogHost = string;
    }

    public String getFacility() {
        return this.facilityStr;
    }

    public void setFacility(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.facilityStr = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<E> layout) {
        this.addWarn("The layout of a SyslogAppender cannot be set directly. See also http://logback.qos.ch/codes.html#syslog_layout");
    }

    public boolean getLazy() {
        return this.lazyInit;
    }

    public void setLazy(boolean bl) {
        this.lazyInit = bl;
    }

    @Override
    public void stop() {
        this.sos.close();
        super.stop();
    }

    public String getSuffixPattern() {
        return this.suffixPattern;
    }

    public void setSuffixPattern(String string) {
        this.suffixPattern = string;
    }
}

