/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.recovery;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.recovery.RecoveryCoordinator;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ResilientOutputStreamBase
extends OutputStream {
    static final int STATUS_COUNT_LIMIT = 8;
    private int noContextWarning = 0;
    private int statusCount = 0;
    private Context context;
    private RecoveryCoordinator recoveryCoordinator;
    protected OutputStream os;
    protected boolean presumedClean = true;

    private boolean isPresumedInError() {
        return this.recoveryCoordinator != null && !this.presumedClean;
    }

    public void write(byte[] byArray, int n, int n2) {
        if (this.isPresumedInError()) {
            if (!this.recoveryCoordinator.isTooSoon()) {
                this.attemptRecovery();
            }
            return;
        }
        try {
            this.os.write(byArray, n, n2);
            this.postSuccessfulWrite();
        }
        catch (IOException iOException) {
            this.postIOFailure(iOException);
        }
    }

    public void write(int n) {
        if (this.isPresumedInError()) {
            if (!this.recoveryCoordinator.isTooSoon()) {
                this.attemptRecovery();
            }
            return;
        }
        try {
            this.os.write(n);
            this.postSuccessfulWrite();
        }
        catch (IOException iOException) {
            this.postIOFailure(iOException);
        }
    }

    public void flush() {
        if (this.os != null) {
            try {
                this.os.flush();
                this.postSuccessfulWrite();
            }
            catch (IOException iOException) {
                this.postIOFailure(iOException);
            }
        }
    }

    abstract String getDescription();

    abstract OutputStream openNewOutputStream() throws IOException;

    private void postSuccessfulWrite() {
        if (this.recoveryCoordinator != null) {
            this.recoveryCoordinator = null;
            this.statusCount = 0;
            this.addStatus(new InfoStatus("Recovered from IO failure on " + this.getDescription(), this));
        }
    }

    void postIOFailure(IOException iOException) {
        this.addStatusIfCountNotOverLimit(new ErrorStatus("IO failure while writing to " + this.getDescription(), this, iOException));
        this.presumedClean = false;
        if (this.recoveryCoordinator == null) {
            this.recoveryCoordinator = new RecoveryCoordinator();
        }
    }

    public void close() throws IOException {
        if (this.os != null) {
            this.os.close();
        }
    }

    void attemptRecovery() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.addStatusIfCountNotOverLimit(new InfoStatus("Attempting to recover from IO failure on " + this.getDescription(), this));
        try {
            this.os = this.openNewOutputStream();
            this.presumedClean = true;
        }
        catch (IOException iOException) {
            this.addStatusIfCountNotOverLimit(new ErrorStatus("Failed to open " + this.getDescription(), this, iOException));
        }
    }

    void addStatusIfCountNotOverLimit(Status status) {
        ++this.statusCount;
        if (this.statusCount < 8) {
            this.addStatus(status);
        }
        if (this.statusCount == 8) {
            this.addStatus(status);
            this.addStatus(new InfoStatus("Will supress future messages regarding " + this.getDescription(), this));
        }
    }

    public void addStatus(Status status) {
        if (this.context == null) {
            if (this.noContextWarning++ == 0) {
                System.out.println("LOGBACK: No context given for " + this);
            }
            return;
        }
        StatusManager statusManager = this.context.getStatusManager();
        if (statusManager != null) {
            statusManager.add(status);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

