/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class RenameUtil
extends ContextAwareBase {
    static String RENAMING_ERROR_URL = "http://logback.qos.ch/codes.html#renamingError";
    static final int BUF_SIZE = 32768;

    public void rename(String string, String string2) throws RolloverFailure {
        if (string.equals(string2)) {
            this.addWarn("From and to file are the same [" + string + "]. Skipping.");
            return;
        }
        File file = new File(string);
        if (file.exists()) {
            File file2 = new File(string2);
            this.createMissingTargetDirsIfNecessary(file2);
            this.addInfo("Renaming file [" + file + "] to [" + file2 + "]");
            boolean bl = file.renameTo(file2);
            if (!bl) {
                this.addWarn("Failed to rename file [" + file + "] to [" + file2 + "].");
                this.addWarn("Please consider leaving the [file] option of " + RollingFileAppender.class.getSimpleName() + " empty.");
                this.addWarn("See also " + RENAMING_ERROR_URL);
            }
        } else {
            throw new RolloverFailure("File [" + string + "] does not exist.");
        }
    }

    public void renameByCopying(String string, String string2) throws RolloverFailure {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[32768];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
            bufferedInputStream.close();
            bufferedInputStream = null;
            filterOutputStream.close();
            filterOutputStream = null;
            File file = new File(string);
            if (!file.delete()) {
                this.addWarn("Could not delete " + string);
            }
        }
        catch (IOException iOException) {
            this.addError("Failed to rename file by copying", iOException);
            throw new RolloverFailure("Failed to rename file by copying");
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    void createMissingTargetDirsIfNecessary(File file) throws RolloverFailure {
        boolean bl;
        if (FileUtil.isParentDirectoryCreationRequired(file) && !(bl = FileUtil.createMissingParentDirectories(file))) {
            throw new RolloverFailure("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
        }
    }

    public String toString() {
        return "c.q.l.co.rolling.helper.RenameUtil";
    }
}

