/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.sift.AppenderTracker;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppenderTrackerImpl<E>
implements AppenderTracker<E> {
    Map<String, Entry> map = new HashMap<String, Entry>();
    Entry head;
    Entry tail = this.head = new Entry(null, null, 0L);
    long lastCheck = 0L;

    AppenderTrackerImpl() {
    }

    @Override
    public synchronized void put(String string, Appender<E> appender, long l) {
        Entry entry = this.map.get(string);
        if (entry == null) {
            entry = new Entry(string, appender, l);
            this.map.put(string, entry);
        }
        this.moveToTail(entry);
    }

    @Override
    public synchronized Appender<E> get(String string, long l) {
        Entry entry = this.map.get(string);
        if (entry == null) {
            return null;
        }
        entry.setTimestamp(l);
        this.moveToTail(entry);
        return entry.value;
    }

    @Override
    public synchronized void stopStaleAppenders(long l) {
        if (this.lastCheck + 1000L > l) {
            return;
        }
        this.lastCheck = l;
        while (this.head.value != null && this.isEntryStale(this.head, l)) {
            Appender appender = this.head.value;
            appender.stop();
            this.removeHead();
        }
    }

    @Override
    public synchronized void stopAndRemoveNow(String string) {
        Entry entry = this.head;
        Entry entry2 = null;
        while (entry != this.tail) {
            if (string.equals(entry.key)) {
                entry2 = entry;
                break;
            }
            entry = entry.next;
        }
        if (entry2 != null) {
            this.rearrangePreexistingLinks(entry);
            this.map.remove(string);
            Appender appender = entry.value;
            appender.stop();
        }
    }

    @Override
    public List<String> keyList() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Entry entry = this.head;
        while (entry != this.tail) {
            linkedList.add(entry.key);
            entry = entry.next;
        }
        return linkedList;
    }

    private boolean isEntryStale(Entry entry, long l) {
        if (!entry.value.isStarted()) {
            return true;
        }
        return entry.timestamp + 1800000L < l;
    }

    private void removeHead() {
        this.map.remove(this.head.key);
        this.head = this.head.next;
        this.head.prev = null;
    }

    private void moveToTail(Entry entry) {
        this.rearrangePreexistingLinks(entry);
        this.rearrangeTailLinks(entry);
    }

    private void rearrangePreexistingLinks(Entry entry) {
        if (entry.prev != null) {
            entry.prev.next = entry.next;
        }
        if (entry.next != null) {
            entry.next.prev = entry.prev;
        }
        if (this.head == entry) {
            this.head = entry.next;
        }
    }

    private void rearrangeTailLinks(Entry entry) {
        Entry entry2;
        if (this.head == this.tail) {
            this.head = entry;
        }
        if ((entry2 = this.tail.prev) != null) {
            entry2.next = entry;
        }
        entry.prev = entry2;
        entry.next = this.tail;
        this.tail.prev = entry;
    }

    public void dump() {
        Entry entry = this.head;
        System.out.print("N:");
        while (entry != null) {
            System.out.print(entry.key + ", ");
            entry = entry.next;
        }
        System.out.println();
    }

    @Override
    public List<Appender<E>> valueList() {
        LinkedList linkedList = new LinkedList();
        Entry entry = this.head;
        while (entry != this.tail) {
            linkedList.add(entry.value);
            entry = entry.next;
        }
        return linkedList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry {
        Entry next;
        Entry prev;
        String key;
        Appender<E> value;
        long timestamp;

        Entry(String string, Appender<E> appender, long l) {
            this.key = string;
            this.value = appender;
            this.timestamp = l;
        }

        public void setTimestamp(long l) {
            this.timestamp = l;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.key == null ? 0 : this.key.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Entry entry = (Entry)object;
            if (this.key == null ? entry.key != null : !this.key.equals(entry.key)) {
                return false;
            }
            return !(this.value == null ? entry.value != null : !this.value.equals(entry.value));
        }

        public String toString() {
            return "(" + this.key + ", " + this.value + ")";
        }
    }
}

