/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.helpers.NOPAppender;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.sift.AppenderFactoryBase;
import ch.qos.logback.core.sift.AppenderTracker;
import ch.qos.logback.core.sift.AppenderTrackerImpl;
import ch.qos.logback.core.sift.Discriminator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SiftingAppenderBase<E>
extends AppenderBase<E> {
    protected AppenderTracker<E> appenderTracker = new AppenderTrackerImpl();
    AppenderFactoryBase<E> appenderFactory;
    Discriminator<E> discriminator;
    int nopaWarningCount = 0;

    public void setAppenderFactory(AppenderFactoryBase<E> appenderFactoryBase) {
        this.appenderFactory = appenderFactoryBase;
    }

    @Override
    public void start() {
        int n = 0;
        if (this.discriminator == null) {
            this.addError("Missing discriminator. Aborting");
            ++n;
        }
        if (!this.discriminator.isStarted()) {
            this.addError("Discriminator has not started successfully. Aborting");
            ++n;
        }
        if (n == 0) {
            super.start();
        }
    }

    @Override
    public void stop() {
        for (Appender<E> appender : this.appenderTracker.valueList()) {
            appender.stop();
        }
    }

    protected abstract long getTimestamp(E var1);

    @Override
    protected void append(E e) {
        long l;
        if (!this.isStarted()) {
            return;
        }
        String string = this.discriminator.getDiscriminatingValue(e);
        Appender<E> appender = this.appenderTracker.get(string, l = this.getTimestamp(e));
        if (appender == null) {
            try {
                appender = this.appenderFactory.buildAppender(this.context, string);
                if (appender == null) {
                    appender = this.buildNOPAppender(string);
                }
                this.appenderTracker.put(string, appender, l);
            }
            catch (JoranException joranException) {
                this.addError("Failed to build appender for [" + string + "]", joranException);
                return;
            }
        }
        this.appenderTracker.stopStaleAppenders(l);
        appender.doAppend(e);
    }

    public Discriminator<E> getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(Discriminator<E> discriminator) {
        this.discriminator = discriminator;
    }

    NOPAppender<E> buildNOPAppender(String string) {
        if (this.nopaWarningCount < 4) {
            ++this.nopaWarningCount;
            this.addError("Failed to build an appender for discriminating value [" + string + "]");
        }
        NOPAppender nOPAppender = new NOPAppender();
        nOPAppender.setContext(this.context);
        nOPAppender.start();
        return nOPAppender;
    }

    public AppenderTracker getAppenderTracker() {
        return this.appenderTracker;
    }

    public String getDiscriminatorKey() {
        if (this.discriminator != null) {
            return this.discriminator.getKey();
        }
        return null;
    }
}

