/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.CyclicBufferTracker;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicBufferTrackerImpl<E>
implements CyclicBufferTracker<E> {
    int bufferSize = 256;
    int maxNumBuffers = 64;
    int bufferCount = 0;
    static final int DELAY_BETWEEN_CLEARING_STALE_BUFFERS = 300000;
    boolean isStarted = false;
    private Map<String, Entry> map = new HashMap<String, Entry>();
    private Entry head;
    private Entry tail = this.head = new Entry(null, null, 0L);
    long lastCheck = 0L;

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    @Override
    public int getMaxNumberOfBuffers() {
        return this.maxNumBuffers;
    }

    @Override
    public void setMaxNumberOfBuffers(int n) {
        this.maxNumBuffers = n;
    }

    @Override
    public CyclicBuffer<E> getOrCreate(String string, long l) {
        Entry entry = this.map.get(string);
        if (entry == null) {
            return this.processNewEntry(string, l);
        }
        entry.setTimestamp(l);
        this.moveToTail(entry);
        return entry.value;
    }

    @Override
    public void removeBuffer(String string) {
        Entry entry = this.map.get(string);
        if (entry != null) {
            --this.bufferCount;
            this.map.remove(string);
            this.unlink(entry);
            CyclicBuffer cyclicBuffer = entry.value;
            if (cyclicBuffer != null) {
                cyclicBuffer.clear();
            }
        }
    }

    private CyclicBuffer<E> processNewEntry(String string, long l) {
        CyclicBuffer cyclicBuffer = new CyclicBuffer(this.bufferSize);
        Entry entry = new Entry(string, cyclicBuffer, l);
        this.map.put(string, entry);
        ++this.bufferCount;
        this.linkBeforeTail(entry);
        if (this.bufferCount >= this.maxNumBuffers) {
            this.removeHead();
        }
        return cyclicBuffer;
    }

    private void removeHead() {
        CyclicBuffer cyclicBuffer = this.head.value;
        if (cyclicBuffer != null) {
            cyclicBuffer.clear();
        }
        this.map.remove(this.head.key);
        --this.bufferCount;
        this.head = this.head.next;
        this.head.prev = null;
    }

    private void moveToTail(Entry entry) {
        this.unlink(entry);
        this.linkBeforeTail(entry);
    }

    private void unlink(Entry entry) {
        if (entry.prev != null) {
            entry.prev.next = entry.next;
        }
        if (entry.next != null) {
            entry.next.prev = entry.prev;
        }
        if (this.head == entry) {
            this.head = entry.next;
        }
    }

    @Override
    public synchronized void clearStaleBuffers(long l) {
        if (this.lastCheck + 300000L > l) {
            return;
        }
        this.lastCheck = l;
        while (this.head.value != null && this.isEntryStale(this.head, l)) {
            this.removeHead();
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    private boolean isEntryStale(Entry entry, long l) {
        return entry.timestamp + 1800000L < l;
    }

    List<String> keyList() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Entry entry = this.head;
        while (entry != this.tail) {
            linkedList.add(entry.key);
            entry = entry.next;
        }
        return linkedList;
    }

    private void linkBeforeTail(Entry entry) {
        Entry entry2;
        if (this.head == this.tail) {
            this.head = entry;
        }
        if ((entry2 = this.tail.prev) != null) {
            entry2.next = entry;
        }
        entry.prev = entry2;
        entry.next = this.tail;
        this.tail.prev = entry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry {
        Entry next;
        Entry prev;
        String key;
        CyclicBuffer<E> value;
        long timestamp;

        Entry(String string, CyclicBuffer<E> cyclicBuffer, long l) {
            this.key = string;
            this.value = cyclicBuffer;
            this.timestamp = l;
        }

        public void setTimestamp(long l) {
            this.timestamp = l;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.key == null ? 0 : this.key.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Entry entry = (Entry)object;
            if (this.key == null ? entry.key != null : !this.key.equals(entry.key)) {
                return false;
            }
            return !(this.value == null ? entry.value != null : !this.value.equals(entry.value));
        }

        public String toString() {
            return "(" + this.key + ", " + this.value + ")";
        }
    }
}

