/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatusChecker {
    StatusManager sm;

    public StatusChecker(StatusManager statusManager) {
        this.sm = statusManager;
    }

    public StatusChecker(Context context) {
        this.sm = context.getStatusManager();
    }

    public boolean hasXMLParsingErrors(long l) {
        return this.containsMatch(l, 2, "XML_PARSING");
    }

    public boolean noXMLParsingErrorsOccurred(long l) {
        return !this.hasXMLParsingErrors(l);
    }

    public int getHighestLevel(long l) {
        List<Status> list = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), l);
        int n = 0;
        for (Status status : list) {
            if (status.getLevel() <= n) continue;
            n = status.getLevel();
        }
        return n;
    }

    public boolean isErrorFree(long l) {
        return 2 > this.getHighestLevel(l);
    }

    public boolean containsMatch(long l, int n, String string) {
        List<Status> list = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), l);
        Pattern pattern = Pattern.compile(string);
        for (Status status : list) {
            String string2;
            Matcher matcher;
            if (n != status.getLevel() || !(matcher = pattern.matcher(string2 = status.getMessage())).lookingAt()) continue;
            return true;
        }
        return false;
    }

    public boolean containsMatch(int n, String string) {
        return this.containsMatch(0L, n, string);
    }

    public boolean containsMatch(String string) {
        Pattern pattern = Pattern.compile(string);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String string2 = status.getMessage();
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.lookingAt()) continue;
            return true;
        }
        return false;
    }

    public int matchCount(String string) {
        int n = 0;
        Pattern pattern = Pattern.compile(string);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String string2 = status.getMessage();
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.lookingAt()) continue;
            ++n;
        }
        return n;
    }

    public boolean containsException(Class clazz) {
        for (Status status : this.sm.getCopyOfStatusList()) {
            Throwable throwable = status.getThrowable();
            if (throwable == null || !throwable.getClass().getName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public long timeOfLastReset() {
        List<Status> list = this.sm.getCopyOfStatusList();
        if (list == null) {
            return -1L;
        }
        int n = list.size();
        for (int i = n - 1; i >= 0; --i) {
            Status status = list.get(i);
            if (!"Will reset and reconfigure context ".equals(status.getMessage())) continue;
            return status.getDate();
        }
        return -1L;
    }
}

