/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusUtil {
    public static boolean contextHasStatusListener(Context context) {
        StatusManager statusManager = context.getStatusManager();
        if (statusManager == null) {
            return false;
        }
        List<StatusListener> list = statusManager.getCopyOfStatusListenerList();
        return list != null && list.size() != 0;
    }

    public static List<Status> filterStatusListByTimeThreshold(List<Status> list, long l) {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        for (Status status : list) {
            if (status.getDate() < l) continue;
            arrayList.add(status);
        }
        return arrayList;
    }

    public static void addStatus(Context context, Status status) {
        if (context == null) {
            return;
        }
        StatusManager statusManager = context.getStatusManager();
        if (statusManager != null) {
            statusManager.add(status);
        }
    }

    public static void addInfo(Context context, Object object, String string) {
        StatusUtil.addStatus(context, new InfoStatus(string, object));
    }

    public static void addWarn(Context context, Object object, String string) {
        StatusUtil.addStatus(context, new WarnStatus(string, object));
    }

    public static void addError(Context context, Object object, String string, Throwable throwable) {
        StatusUtil.addStatus(context, new ErrorStatus(string, object, throwable));
    }
}

