/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Node;
import ch.qos.logback.core.subst.Parser;
import ch.qos.logback.core.subst.Tokenizer;
import ch.qos.logback.core.util.OptionHelper;

public class NodeToStringTransformer {
    final Node node;
    final PropertyContainer propertyContainer0;
    final PropertyContainer propertyContainer1;

    public NodeToStringTransformer(Node node, PropertyContainer propertyContainer, PropertyContainer propertyContainer2) {
        this.node = node;
        this.propertyContainer0 = propertyContainer;
        this.propertyContainer1 = propertyContainer2;
    }

    public NodeToStringTransformer(Node node, PropertyContainer propertyContainer) {
        this(node, propertyContainer, null);
    }

    public static String substituteVariable(String string, PropertyContainer propertyContainer, PropertyContainer propertyContainer2) throws ScanException {
        Tokenizer tokenizer = new Tokenizer(string);
        Parser parser = new Parser(tokenizer.tokenize());
        Node node = parser.parse();
        NodeToStringTransformer nodeToStringTransformer = new NodeToStringTransformer(node, propertyContainer, propertyContainer2);
        return nodeToStringTransformer.transform();
    }

    public String transform() {
        StringBuilder stringBuilder = new StringBuilder();
        this.compileNode(this.node, stringBuilder);
        return stringBuilder.toString();
    }

    private void compileNode(Node node, StringBuilder stringBuilder) {
        Node node2 = node;
        while (node2 != null) {
            switch (node2.type) {
                case LITERAL: {
                    this.handleLiteral(node2, stringBuilder);
                    break;
                }
                case VARIABLE: {
                    this.handleVariable(node2, stringBuilder);
                }
            }
            node2 = node2.next;
        }
    }

    private void handleVariable(Node node, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder();
        Node node2 = (Node)node.payload;
        this.compileNode(node2, stringBuilder2);
        String string = stringBuilder2.toString();
        String string2 = this.lookupKey(string);
        if (string2 != null) {
            stringBuilder.append(string2);
            return;
        }
        if (node.defaultPart == null) {
            stringBuilder.append(string + "_IS_UNDEFINED");
            return;
        }
        Node node3 = (Node)node.defaultPart;
        StringBuilder stringBuilder3 = new StringBuilder();
        this.compileNode(node3, stringBuilder3);
        String string3 = stringBuilder3.toString();
        stringBuilder.append(string3);
    }

    private String lookupKey(String string) {
        String string2 = this.propertyContainer0.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        if (this.propertyContainer1 != null && (string2 = this.propertyContainer1.getProperty(string)) != null) {
            return string2;
        }
        string2 = OptionHelper.getSystemProperty(string, null);
        if (string2 != null) {
            return string2;
        }
        string2 = OptionHelper.getEnv(string);
        if (string2 != null) {
            return string2;
        }
        return null;
    }

    private void handleLiteral(Node node, StringBuilder stringBuilder) {
        stringBuilder.append((String)node.payload);
    }
}

