/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Node;
import ch.qos.logback.core.subst.Token;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    final List<Token> tokenList;
    int pointer = 0;

    public Parser(List<Token> list) {
        this.tokenList = list;
    }

    public Node parse() throws ScanException {
        return this.E();
    }

    private Node E() throws ScanException {
        Node node = this.T();
        if (node == null) {
            return null;
        }
        Node node2 = this.Eopt();
        if (node2 != null) {
            this.appendNode(node, node2);
        }
        return node;
    }

    private Node Eopt() throws ScanException {
        Token token = this.getCurentToken();
        if (token == null) {
            return null;
        }
        return this.E();
    }

    private Node T() throws ScanException {
        Token token = this.getCurentToken();
        switch (token.type) {
            case LITERAL: {
                this.advanceTokenPointer();
                return new Node(Node.Type.LITERAL, token.payload);
            }
            case CURLY_LEFT: {
                this.advanceTokenPointer();
                Node node = this.E();
                Token token2 = this.getCurentToken();
                this.expectCurlyRight(token2);
                this.advanceTokenPointer();
                Node node2 = new Node(Node.Type.LITERAL, CoreConstants.LEFT_ACCOLADE);
                node2.next = node;
                Node node3 = new Node(Node.Type.LITERAL, CoreConstants.RIGHT_ACCOLADE);
                if (node == null) {
                    node2.next = node3;
                } else {
                    this.appendNode(node, node3);
                }
                return node2;
            }
            case START: {
                this.advanceTokenPointer();
                Node node = this.V();
                Token token3 = this.getCurentToken();
                this.expectCurlyRight(token3);
                this.advanceTokenPointer();
                return node;
            }
        }
        return null;
    }

    private void appendNode(Node node, Node node2) {
        Node node3 = node;
        while (true) {
            if (node3.next == null) {
                node3.next = node2;
                return;
            }
            node3 = node3.next;
        }
    }

    private Node V() throws ScanException {
        Node node = this.E();
        Node node2 = new Node(Node.Type.VARIABLE, node);
        Token token = this.getCurentToken();
        if (token != null && token.type == Token.Type.DEFAULT) {
            this.advanceTokenPointer();
            Node node3 = this.E();
            node2.defaultPart = node3;
        }
        return node2;
    }

    void advanceTokenPointer() {
        ++this.pointer;
    }

    void expectNotNull(Token token, String string) {
        if (token == null) {
            throw new IllegalArgumentException("All tokens consumed but was expecting \"" + string + "\"");
        }
    }

    void expectCurlyRight(Token token) throws ScanException {
        this.expectNotNull(token, "}");
        if (token.type != Token.Type.CURLY_RIGHT) {
            throw new ScanException("Expecting }");
        }
    }

    Token getCurentToken() {
        if (this.pointer < this.tokenList.size()) {
            return this.tokenList.get(this.pointer);
        }
        return null;
    }
}

