/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.spi.ContextAware;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class FileUtil {
    public static URL fileToURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Unexpected exception on file [" + file + "]", malformedURLException);
        }
    }

    public static boolean isParentDirectoryCreationRequired(File file) {
        File file2 = file.getParentFile();
        return file2 != null && !file2.exists();
    }

    public static boolean createMissingParentDirectories(File file) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            throw new IllegalStateException(file + " should not have a null parent");
        }
        if (file2.exists()) {
            throw new IllegalStateException(file + " should not have existing parent directory");
        }
        return file2.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resourceAsString(ContextAware contextAware, ClassLoader classLoader, String string) {
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            contextAware.addError("Failed to find resource [" + string + "]");
            return null;
        }
        InputStreamReader inputStreamReader = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
            char[] cArray = new char[128];
            StringBuilder stringBuilder = new StringBuilder();
            int n = -1;
            while ((n = inputStreamReader.read(cArray, 0, cArray.length)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        catch (IOException iOException) {
            contextAware.addError("Failled to open " + string, iOException);
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String prefixRelativePath(String string, String string2) {
        if (string != null && !string.trim().isEmpty() && !new File(string2).isAbsolute()) {
            string2 = string + "/" + string2;
        }
        return string2;
    }
}

