/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.ThrowableToStringArray;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusPrinter {
    private static PrintStream ps = System.out;
    static CachingDateFormatter cachingDateFormat = new CachingDateFormatter("HH:mm:ss,SSS");

    public static void setPrintStream(PrintStream printStream) {
        ps = printStream;
    }

    public static void printInCaseOfErrorsOrWarnings(Context context) {
        StatusPrinter.printInCaseOfErrorsOrWarnings(context, 0L);
    }

    public static void printInCaseOfErrorsOrWarnings(Context context, long l) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager statusManager = context.getStatusManager();
        if (statusManager == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            StatusChecker statusChecker = new StatusChecker(context);
            if (statusChecker.getHighestLevel(l) >= 1) {
                StatusPrinter.print(statusManager, l);
            }
        }
    }

    public static void printIfErrorsOccured(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager statusManager = context.getStatusManager();
        if (statusManager == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            StatusChecker statusChecker = new StatusChecker(context);
            if (statusChecker.getHighestLevel(0L) == 2) {
                StatusPrinter.print(statusManager);
            }
        }
    }

    public static void print(Context context) {
        StatusPrinter.print(context, 0L);
    }

    public static void print(Context context, long l) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager statusManager = context.getStatusManager();
        if (statusManager == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            StatusPrinter.print(statusManager, l);
        }
    }

    public static void print(StatusManager statusManager) {
        StatusPrinter.print(statusManager, 0L);
    }

    public static void print(StatusManager statusManager, long l) {
        StringBuilder stringBuilder = new StringBuilder();
        List<Status> list = StatusUtil.filterStatusListByTimeThreshold(statusManager.getCopyOfStatusList(), l);
        StatusPrinter.buildStrFromStatusList(stringBuilder, list);
        ps.println(stringBuilder.toString());
    }

    public static void print(List<Status> list) {
        StringBuilder stringBuilder = new StringBuilder();
        StatusPrinter.buildStrFromStatusList(stringBuilder, list);
        ps.println(stringBuilder.toString());
    }

    private static void buildStrFromStatusList(StringBuilder stringBuilder, List<Status> list) {
        if (list == null) {
            return;
        }
        for (Status status : list) {
            StatusPrinter.buildStr(stringBuilder, "", status);
        }
    }

    private static void appendThrowable(StringBuilder stringBuilder, Throwable throwable) {
        String[] stringArray;
        for (String string : stringArray = ThrowableToStringArray.convert(throwable)) {
            if (!string.startsWith("Caused by: ")) {
                if (Character.isDigit(string.charAt(0))) {
                    stringBuilder.append("\t... ");
                } else {
                    stringBuilder.append("\tat ");
                }
            }
            stringBuilder.append(string).append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public static void buildStr(StringBuilder stringBuilder, String string, Status status) {
        Object object;
        String string2 = status.hasChildren() ? string + "+ " : string + "|-";
        if (cachingDateFormat != null) {
            object = cachingDateFormat.format(status.getDate());
            stringBuilder.append((String)object).append(" ");
        }
        stringBuilder.append(string2).append(status).append(CoreConstants.LINE_SEPARATOR);
        if (status.getThrowable() != null) {
            StatusPrinter.appendThrowable(stringBuilder, status.getThrowable());
        }
        if (status.hasChildren()) {
            object = status.iterator();
            while (object.hasNext()) {
                Status status2 = (Status)object.next();
                StatusPrinter.buildStr(stringBuilder, string + "  ", status2);
            }
        }
    }
}

