﻿using Genesyslab.Desktop.Infrastructure.Configuration;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Genesyslab.Desktop.Modules.JourneyTimeline.Model
{
    public class JourneyTimelineConfig : IJourneyTimelineConfig
    {
        private readonly IConfigManager configManager;
        public JourneyTimelineConfig(IConfigManager configManager)
        {
            this.configManager = configManager;
        }

        public string getIdKey()
        {
            object result;
            if (configManager.TryGetValue("journeytimeline.id_key", out result))
            {
                return result as string;
            }
            // If id_key is not defined, use default location
            return "customer_id";
        }

        public string getUrl()
        {
            object result;
            if (configManager.TryGetValue("journeytimeline.url", out result))
            {
                return result as string;
            }
            return null;
        }
    }
}
