﻿using Genesyslab.Desktop.Infrastructure;
using Genesyslab.Desktop.Modules.Core.Model.Interactions;
using Genesyslab.Desktop.Modules.JourneyTimeline.ViewModel;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Genesyslab.Desktop.Modules.JourneyTimeline.View
{
    /// <summary>
    /// Interaction logic for JourneyTimelineView.xaml
    /// </summary>
    public partial class JourneyTimelineView : UserControl, IJourneyTimelineView
    {
        public JourneyTimelineView(IJourneyTimelineViewModel viewModel)
        {
            // Use ViewModel as DataContext (allows Databinding from View to ViewModel)
            this.Model = viewModel;
            InitializeComponent();
        }

        #region IView Members
        public object Context { get; set; }
        public void Create() {
            this.Model.Case = (Context as Dictionary<string, object>).TryGetValue("Case") as ICase;
        }
        public void Destroy() {}
        #endregion IView Members

        public IJourneyTimelineViewModel Model
        {
            get
            {
                return this.DataContext as IJourneyTimelineViewModel;
            }
            set
            {
                this.DataContext = value;
            }
        }
    }
}
