﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

// Mark Withall https://github.com/MarkWithall/worlds-simplest-csharp-wpf-mvvm-example/blob/master/MinimalMVVM/ViewModel/ObservableObject.cs

namespace Genesyslab.Desktop.Modules.JourneyTimeline.Utility
{
    public class ObservableObject : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        protected void RaisePropertyChangedEvent(string propertyName)
        {
            var handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(propertyName));
            }
        }
    }
}
