define({

    Common: {
      REMOVE: "Retirer",
      DUPLICATE: "Dupliquer",
      CANCEL: "Annuler",
      CONTINUE: "Continuer",
      SETKEY: "Cliquez ici pour définir la clé.",
      SETVALUE: "Cliquez ici pour définir la valeur.",
      AREYOUSURE: "Êtes-vous certain ?",
      KEY: "Nom",
      VALUE: "Valeur",
      MAKESELECTION: "Veuillez faire votre choix...",
      HELP: "Aide",
      CLOSE: "Fermer",
      MINUTES: "Minutes",
      RELOAD: "Recharger",
      OKAY:"OK",
      WARNING: "Attention",
      SAVE: "Enregistrer",
      NEW: "Nouveau",
      DELETE: "Supprimer",
      ERROR: "Erreur",
      BACK: "Retour",
      CLEAR: "Effacer",
      TODAY: "Aujourd'hui",
      LOADING: "Chargement en cours...",
      GMS: "Genesys Mobile Services",
      GES:"Genesys Engagement Services",
      INVALID_INPUT: "Entrée non valide",
      AUTHENTICATION_ERROR_RELOAD: "Votre session a expiré. Rechargez la fenêtre.",
      PENDING_REQUEST: "Il se peut que les modifications apportées ne soient pas enregistrées.",
      PREVIOUS: "Précédent",
      NEXT: "Suivant",
      ADD: "Ajouter",
      APP_NAME_GMS: "GMS Management UI",
      APP_NAME_GES: "GES Management UI",
      APP_NAME_GSG_Admin : "GSG Admin",
      APP_NAME_GES_Admin : "GES Admin",
    },

    AccountView: {
      WELCOME: "Degemer Mad",
      LANGUAGE: "Yezh",
      LOGOUT: "Se déconnecter",
      CLOSE: "Fermer",
      HOME: "Donemat",
      LOGOUTMESSAGE: "Fermez votre navigateur pour vous déconnecter.",
      ENGLISH: "Saozneg",
      FRENCH: "Galleg",
      RUSSIAN: "Rusianeg"
    },

    // System monitors the Cassandra nodes on which GMS resides. The following strings are Cassandra related keywords.
    System: {
      SYSTEM: "Système",
      IP: "IP",
      TOKEN: "Jeton",
      STATUS: "État",
      LOAD: "Charger",
      DATACENTER: "Centre de données",
      URL: "URL",
      STATUSALIVE: "État Actif",
      EXTERNALCONFIGURATION: "Configuration Cassandra externe",
      RACK: "Rack",
      OWN: "Personnel",
      RUNNINGTIME: "Fonctionne depuis",
      TIMESTAMPLABEL: "Dernière mise à jour",
      NODEERROR: "Échec de la récupération des nœuds."
    },

    // Reporting contains all the strings used for the GMS reporting section (i.e for the charts, its options, its error messages, etc.).
    Reporting: {
      REPORTING: "Rapports",
      REPORTTYPE: "Type de rapport",
      ALLOCATED: "Alloué",
      RELEASED: "Libéré",
      RELEASEFAILED: "Échec de la libération",
      ALLOCATIONTIME: "Temps alloué",
      RESOURCETOTAL: "Total des ressources",
      RESOURCEAVAILABLE: "Ressource disponible",
      RESOURCEAVAILABILITY: "Disponibilité des ressources",
      ADDITIONALOPTIONS: "Options de rapport supplémentaires",
      RESOURCES: "Ressources", //GMS Resources
      SERVICES: "Services",   //GMS Services
      CALLBACK: "Rappel",   //Callback service used to to call back a customer
      REPORTNAME: "Paramètres de rapport",
      MEDIATYPE: "Type de média",
      METRICTYPE: "Type de mesure",
      HOLDTIME: "Temps d'attente", //Holdtime is a counter within the callback service
      WATERMARK: "Filigrane", //Watermark is a counter within the callback service
      NOOPTIONS: "Aucune option",
      GROUPDATABY: "Données de groupe par",
      MINUTES: "minutes",
      ANHOUR: "Une heure",
      ADAY: "Un jour",
      REPORTRANGE: "Étendue du rapport",
      TODAY: "Aujourd'hui",
      YESTERDAY: "Hier",
      LASTWEEK: "Semaine dernière",
      WEEKTODATE: "Semaine en cours",
      LASTMONTH: "Mois dernier",
      MONTHTODATE: "Mois en cours",
      SPECIFYDATERANGE: "Définir une plage de dates",
      FROM: "De",
      AM: "a.m",
      TO: "à",
      PM: "p.m",
      DOWNLOAD: "Télécharger",
      REFRESH: "Actualiser",
      NODATA: "Aucune donnée pour la période sélectionnée.",
      CALLBACKTYPE:"Type de rappel",
      ALL: "Tous",
      IMMEDIATE: "Immédiat",
      SCHEDULED: "Planifié",
      MINMAXSECTION:"Temps d'attente min./max",
      FETCHINGDATA: "Récupération des données...",
      TOTAL: "Total",
      TOTALACCEPTED: "Total accepté",
      TOTALREJECTED: "Total refusé",

      //Wait time for different types of queues
      PQWAITTIME:"Temps d'attente de la file continuelle",
      DQWAITTIME:"Temps d'attente de la file de distribution",

      TARGET: "Cible",
      AGENTGROUP: "Groupe d'agents",
      AGENT: "Agent",
      AGGREGATESWARNING: "ATTENTION : Aucune donnée disponible",
      MEDIAWARNING: "ATTENTION : Aucun type de media trouvé",
      SERVICESWARNING: "ATTENTION : Aucun service trouvé",
      RESOURCESWARNING: "ATTENTION : Aucune ressource trouvée",
      ZERODATA: "REMARQUE : la valeur de chaque point de données du graphique est de 0.",
      MIN: "MIN",
      MAX: "MAX",
      SUM: "TOT",
      AVG: "MOY",
      DISPLAY_METRICS: "Afficher les mesures avancées",
      CSV: "CSV",
      PDF: "PDF",
      EXCEL: "EXCEL",
      URL: "URL",
      PARAMETERS: "Paramètres",
    },

    Error: {
      KEY: "Entrez une clé.",
      EMPTY_FORM: "Veuillez remplir le formulaire!",
      COMPLETEALL: "Vous devez remplir tous les champs obligatoires.",
      UNIQUENAME: "Vous devez choisir un nom unique.",
      ILLEGAL: "Utilisez seulement les caractères autorisés.",
      LENGTH: "Les données entrées dépassent le nombre maximal de caractères permis",
      AUTHENTICATION: "Échec de l'authentification",
      INVALID: "Valeur non valide ou manquante : L'information entrée dépasse la plage permise.",
    },

     LoginView: {
       LOGIN: "CONNEXION",
       USERNAME: "Nom d'utilisateur",
       PASSWORD: "Mot de passe",
       INCORRECT: "Votre identifiant ou votre mot de passe est incorrect.",
       LOGINLOWERCASE: "Se connecter",
     },

    // View that contains all the items in the navigation menu.
    NavigationView: {
      HOME: "ACCUEIL",
      SYSTEM: "SYSTÈME",
      PROVISIONING: "APPROVISIONNEMENT",
      REPORTING: "RAPPORTS",
      SERVICES: "SERVICES",
      SWAGGER: "SWAGGER", //Alias for SwaggerJS
      TOOLS:"OUTILS",
      LAB:"LAB",
      RESOURCES: "Ressources",
      MONITOR: "Surveiller",
      CONFIGURED_SERVICES :"Services configurés",
      SERVICE_TEMPLATES : "Modèles de service",
      CALENDAR: "Gérer les calendriers",
      PATTERNS: "Modèles", //GMS Patterns
      STATISTICS: "Statistiques",
      SAMPLE: "Échantillon",
      API_SHOWCASE:"API",
      CALLBACK_TITLE: "RAPPEL",
      CALLBACK: "Gestion des rappels",
      STATISTICSV2: "Statistiques V2",
      MONITOR: "SURVEILLER",
      DATADEPOTCENTER: "Centre de stockage de données",
      DOWNLOAD_DFM: "Télécharger DFM", //Download DFM files
      CONFIG: "Config",
      CONTEXTSERVICES: "Services de contexte",
      LOGVIEWER: "LogViewer",
    },

    Provisioning: {
      SERVICES: "SERVICES",
      MOBILESERVICE: "SERVICE MOBILE",
      RESOURCES: "RESSOURCES",
      PATTERNS: "MODÈLES",
      SERVICETEMPLATES: "MODÈLES DE SERVICE",
      STATISTICS: "STATISTIQUES",
      QUEUEMANAGEMENT: "GESTION DE FILES D'ATTENTE"
    },

    MobileService: {
      SESSIONID: "ID de session",
      SERVICENAME: "Nom du service",
      STARTTIME: "Heure de début",
      ENDTIME: "Heure de fin",
      DURATION: "Durée",
      RESULT: "Résultat",
      SESSION: "Session",
      SERVICE: "Service",
      MINUTE: "minute",
      MINUTES: "minutes",
      SUCCESS: "Succès",
      FAIL: "Échec",
      OTHERS: "Autres"
    },

    //Prompt for adding a new GMS Service
    NewService: {
      ADDNEWSERVICE: "Ajouter un nouveau service",
      NEWSERVICENAME: "Nom du nouveau service",
      SERVICENAME: "Nom du service",
      MUSTFILL: "Veuillez remplir tout le formulaire.",
      RIGHTOPTION: "Sélectionnez une option.",
      UNIQUENAME: "Choisissez un nom unique.",
      DEFAULTCONFIG: "Sélectionnez une option de configuration par défaut.",
      ILLEGALCHARS: "Certains des caractères ne sont pas permis dans un nom de service",
      CONFIGURESERVICE: "Configurer le service",
      SELECTOPTION: "Sélectionner une option...",
      SAVE: "Enregistrer",
      PROFILES: "Configurations par défaut",
      NAMEEXCEEDSLENGTH: "Entrez un nom de service qui ne dépasse pas 56 caractères."
    },

    //Prompt for removing a GMS Service Setting
    RemoveSetting: {
        REMOVESETTING: "Retirer le paramètre",
        AREYOUSURE: "Êtes-vous certain ?",
        REMOVE: "Retirer",
        CANCEL: "Annuler",
     },

     //Prompt for removing a GMS Service
    RemoveService: {
      REMOVESERVICE: "Retirer le service",
      AREYOUSURE: "Êtes-vous certain ?",
      REMOVE: "Retirer",
      CANCEL: "Annuler",
    },

    //Container that contains all of the GMS Services
    ServicesView: {
      CONFIGURE: "Services configurés",
      ADDSERVICE: "Ajouter un service",
      NOSERVICES: "Le modèle de service sélectionné n'a pas de service configuré.",
      SHOWADVANCED: "Paramètres avancés",
      EXPANDALL: "Développer tout",
      COLLAPSEALL: "Réduire tout",
      ALLSERVICETEMPLATES: "Tous les modèles de service",
      SERVICESPERPAGE: "Services par page",
      NEXT: "Suivant",
      PREVIOUS: "Précédent",
      COMMUNICATIONPROBLEM: "Un problème de communication est survenu. Actualisez votre navigateur et réessayez.",
      ERRORMESSAGE: "Une erreur s'est produite. Essayez d'actualiser votre navigateur.",
      RESOURCESERROR: "Erreur de ressources",
      AUTHENTICATIONERROR: "Veuillez vous connecter pour ajouter un nouveau service.",
    },

    //Container for a GMS Service
    ServiceView: {
      REMOVE: "Retirer le service",
      NAME: "Nom",
      VALUE: "Valeur",
      DESCRIPTION: "Description",
      ADD: "Ajouter un paramètre",
      SETKEY: "cliquer pour définir la clé",
      SETVALUE: "cliquer pour définir la valeur",
      INVALID_OR_MISSING_VALUE: "Valeur non valide ou manquante : L'information entrée dépasse la plage permise.",
      UNIQUENESS_VIOLATION: "Violation d'unicité : Attendez au moins une seconde entre chaque copie de paramètre.",
    },

    //Container for GMS Service Setting
    SettingView: {
      MONDAY: "Lundi",
      TUESDAY: "Mardi",
      WEDNESDAY: "Mercredi",
      THURSDAY: "Jeudi",
      FRIDAY: "Vendredi",
      SATURDAY: "Samedi",
      SUNDAY: "Dimanche",
      SETTINGINFOTOOLTIP: "Ceci est un paramètre de requête. Si vous le définissez ici, il remplacera le paramètre spécifié dans la requête.",
      REQUIREDPARAMETER: "Ce paramètre est obligatoire, et son nom ne peut être modifié.",
      VALUECANNOTCHANGE: "Cette valeur ne peut être modifiée.",
      NOTSPECIFIED: "Non spécifié",
      SELECTOPTION:"Sélectionnez une option.",
      SETVALUEDATE:"Cliquez ici pour définir la date.",
      SETVALUEDAY: "cliquer ici pour définir le jour de début",
      LENGTHEXCEEDED: "La valeur spécifiée dépasse la longueur maximale de 64 caractères",
    },

    //Prompt for adding a new GMS Pattern
    NewPatternGroupDialog: {
      ADD: "Ajouter un nouveau groupe de modèles",
      COMPLETE: "Vous devez remplir tous les champs obligatoires.",
      UNIQUENAME: "Vous devez choisir un nom unique.",
      ILLEGAL: "Utilisez seulement les caractères autorisés.",
      UNIQUEPATTERN: "Spécifiez un nom de groupe de modèles unique :",
      CONTINUE: "Continuer",
      NEWPATTERNGROUPNAME: "Nom du nouveau groupe de modèles",
      ADD_LABEL: "Ajouter",
      CANCEL_LABEL: "Annuler",
    },

    //View that keeps track of GMS Statistics
    StatisticsView: {
      STATISTICS: "Statistiques",
      STATISTIC: "Statistique",
      VALUE: "Valeur",
      SELECTION: "Veuillez faire votre choix...",
      METRIC: "Mesure",
      OBJECTTYPE: "Type d'objet",
      NOSTATSMESSAGE: "Il n'y a aucune statistique pour la mesure et le type d'objet sélectionnés.",
      REFRESH_EVERY: "Actualiser toutes les (secondes)",
      ZOOMINONTABLE: "Zoomer sur les tableaux",
      PLEASE_SELECT_STATISTIC: "Sélectionnez une statistique à afficher.",
      DROP_STATISTIC: "Menu déroulant des statistiques sur lesquelles se concentrer",
      TOGGLE_CONFIGURE_WATCHED_STATISTICS: "Basculer pour configurer les statistiques surveillées",
      AGENT: "Agent",
      ROUTEPOINT: "RoutePoint",
      ADDMETRIC: "Ajouter une mesure",
      ADDSTATISTIC: "Ajouter une statistique",
      CLEAR: "Effacer",
      LOAD_PREFERENCES: "Charger les préférences",
      //Thresholds are MAX/MIN limits for any GMS statistic
      SET_THRESHOLD: "Définir les valeurs seuil",
      HIGH_THRESHOLD: "Valeur seuil supérieur",
      LOW_THRESHOLD: "Valeur seuil inférieur",
      FIRST: "1re",
      SECOND: "2e",
      NOT_INTEGER_ERROR: "Entrée non valide : Entrez un nombre entier pour les champs sélectionnés.",
      THRESHOLD_ERROR: "Entrée non valide : Définissez un seuil plus élevé.",
      EMPTY_ERROR: "ERREUR : Les statistiques sont vides.",
   },

   //View to upload a new Service Template into GMS
    ServiceTemplatesView: {
      SERVICETEMPLATES: "Modèles de service",
      ADD: "Ajouter un modèle de service",
      NOTEMPLATE: "Aucun modèle de service n'a été téléversé dans le système. Pour en ajouter un nouveau, téléversez un modèle en fichier compressé (ZIP) en cliquant sur le bouton Ajouter un modèle de service.",
      TEMPLATEUPLOAD: "ERREUR : Un problème est survenu lors du téléversement du modèle XXX.zip.",
      ZIPFILE: "Sélectionnez un fichier ZIP.",
    },

    ServiceTemplateView: {
      NAME: "Nom",
      DEFAULT: "Valeur par défaut",
      DESCRIPTION: "Description",
      REMOVETEMPLATE: "Retirer le modèle de service",
    },

    ReloadServiceTemplate: {
      RELOADSERVICETEMPLATE: "Un modèle avec le même nom a déjà été téléversé dans le système.",
      AREYOUSURE: "Voulez-vous le charger de nouveau ?"
    },

    RemovePatternGroup: {
      REMOVEPATTERN: "Retirer le groupe de modèles",
      AREYOUSURE: "Êtes-vous certain ?",
    },

    NewResourceGroup: {
      ADDGROUP: "Ajouter de nouveaux groupes de ressources",
      NEWNAME: "Spécifiez un nom de groupe de ressources unique:",
      NEWGROUPNAME: "Nom du nouveau groupe de ressources",
    },

    RemoveResourceGroup: {
      REMOVEGROUP: "Retirer le groupe de ressources",
    },

    ResourcesView: {
      RESOURCES: "Ressources",
      NEWGROUP: "Nouveau groupe de ressources",
      ADDRESOURCE: "Ajouter une ressource",
      REMOVEGROUP: "Supprimer le groupe de ressources",
      NORESOURCESSELECTED: "Aucun groupe de ressources n'est sélectionné. Sélectionnez-en un à gauche.",
      NORESOURCESDEFINED: "Aucun groupe de ressources n'est défini.",
      REFRESH: "Actualiser les mesures",
      AVAILABLE_RESOURCES: "Ressources disponibles :",
      TOTAL_RESOURCES: "Nombre total des ressources :",
      ADD_NEW_RESOURCE_GROUP: "Ajouter un nouveau groupe de ressources",
      NEW_GROUP_NAME: "Nom du groupe de ressources",
      ADD_LABEL: "Ajouter",
      DELETE_LABEL: "Supprimer",
      CANCEL_LABEL: "Annuler",
      CONFIRM_LABEL: "Confirmer",
      SEARCH_PLACEHOLDER: "Rechercher des éléments",
      NEW_GROUP_PLACEHOLDER: "Nom du nouveau groupe de ressources",
      RESOURCE_GROUPS: "Groupe de ressources.",
      
      //delete group modal 
      REMOVE_GROUP: "Supprimer le groupe de ressources",
      //delete 
      DELETE_RESOURCE: "Supprimer la ressource",
      REMOVE_CONFIRMATION: "Voulez-vous vraiment retirer",
      DELETE_SUCCESS: "Suppression réussie",
      ROW_NOT_SELECTED_FOR_DELETE: "Ligne non sélectionnée pour la suppression.",

      //page
      NAME_LABEL: "Nom",
      VALUE_LABEL: "Valeur",
      REFRESH_BUTTON: "Actualiser",
      ADD_NEW_BUTTON: "Ajouter",
      DELETE_BUTTON: "Supprimer",
      TABLE_SEARCH_PLACEHOLDER: "Rechercher dans tableau",
      NO_RESOURCE_GROUPS: "Il n'y a pas de groupe de ressources défini.",
      CLICK_TO_SET_KEY: "Cliquez ici pour définir la clé.",
      CLICK_TO_SET_VALUE: "Cliquez ici pour définir la valeur.",

      //toasts
      ERROR: "Erreur",
      AUTHENTICATION_ERROR_RELOAD: "Erreur d'authentification",
      KEY_EMPTY: "Remplissez le champ.",
      KEY_ALREADY_EXISTS: "Cette clé existe déjà.",
      FETCHING_ERROR: "Erreur de récupération de groupe de ressources",

      SUCCESS: "Succès",
      //sidebar messages/errors
      NEW_NAME: "Entrez le nom du nouveau groupe de ressources.",
      TOO_LONG: "Le nom du groupe de ressources est trop long.",
      NOT_UNIQUE: "Le nom du groupe de ressources doit être unique.",
      ILLEGAL_CHARS: "Utilisez seulement les caractères autorisés.",
      CREATED: "Groupe de ressources créé",
      FAILED_CREATE: "Échec de la création du groupe de ressources",
    },
    ICalenderView:{
      NOEVENTS: "Il n'y a aucun événement pour cette période.",
      SPECIFIC_EVENTS_AFTER: "événements:",
      NEXT: "suivant",
      PREV: "précédent",
      NEXTEVENTS: "Événements à venir :",
      GO_TO_EVENT_URL: "Voir l'événement",
      //values for the template
      TITLE: "Titre",
      DESCRIPTION: "Description",
      DATE: "Date",
      STARTTIME:"Heure de début",
      ADDEVENT:"Ajouter un événement",
      CALENDARS:"Calendriers",
      NOFILE: "sélectionnez un fichier",
      },

    PatternGroupView: {
      PATTERNS: "Modèles",
      NEWGROUP: "Nouveau groupe de modèles",
      REMOVEGROUP: "Retirer le groupe de modèles",
      ADDPATTERN: "Ajouter un modèle",
      TEST: "Tester la valeur du modèle",
      NOPATTERNSSELECTED: "Aucun groupe de modèles n'est sélectionné. Sélectionnez un groupe de modèles à gauche.",
      NOPATTERNSDEFINED: "Aucun groupe de modèles n'est défini.",
      CLOSE: "Fermer",
      ADD_NEW: "Ajouter",
      DELETE: "Supprimer",
      REFRESH: "Actualiser",
      NAME: "Nom",
      VALUE: "Valeur",
      CONFIRM: "Confirmer",
      DELETE_PATTERN: "Supprimer le groupe de modèles",
      REMOVE_CONFIRMATION: "Voulez-vous vraiment retirer",

      //toasts
      REFRESHED: "Actualisé",
      INVALID_FIRST_CHAR: "La valeur ne peut pas commencer par ",
      FETCHING_ERROR: "Erreur de récupération des modèles",
      KEY_EMPTY: "Remplissez le champ.",
      KEY_ALREADY_EXISTS: "Cette clé existe déjà.",
      AUTHENTICATION_ERROR_RELOAD: "Erreur d'authentification",
      DELETE_SUCCESS: "Suppression réussie",
      SUCCESS: "Succès",
      CANNOT_DELETE_PARAMETER: "Impossible de supprimer un paramètre obligatoire.",
      ROW_NOT_SELECTED_FOR_DELETE: "Ligne non sélectionnée pour la suppression.",
      //Help
      HELP: "Aide",
      REGULAREXPRESSIONTITLE: "Une expression régulière",
      REGULAREXPRESSIONDEF: " définit un modèle de recherche de chaînes. Une expression régulière peut servir à rechercher, à modifier ou à manipuler du texte.",
      REGULAREXPRESSION: "Expression régulière",
      DESCRIPTION: "Description",
      MATCH: "Correspond à n'importe quel caractère",
      BEGIN: "L'expression régulière doit correspondre au début de la ligne",
      END: "L'expression régulière doit correspondre à la fin de la ligne",
      OR: "Définition établie, peut correspondre à la lettre a, b ou c",
      ORFOLLOW: "Définition établie, peut correspondre à la lettre a, b, ou c suivie de la lettre v ou z",
      BEGINEXCEPT: "Quand ce caractère ^ apparaît comme premier caractère entre des [], cela annule le modèle. Cela peut correspondre à n'importe quel caractère à l'exception de a, b ou c",
      RANGE: "Plages, lettres entre a et d et chiffres de 1 à 7, ne correspondront pas à d1",
      XORZ: "Trouve X ou Z",
      TELEPHONE: "Numéro de téléphone selon le format (XXX)XXX-XXXX",
      EMAIL: "Format de courriel simple : X@X.X, où X peut représenter n'importe quel chiffre ou lettre",
      POSTAL: "Code postal au Canada : A0A 0A0",
      DETAIL: "Pour plus de détails, consultez ",
      ORACLE: "Leçon sur l'expression régulière Java par Oracle",
      URL: "URL",
      POST: "Publier",

      SEARCH_PLACEHOLDER: "Rechercher des éléments",
      TEST_PATTERN: "Tester la valeur du modèle",
      SEARCH_TABLE: "Rechercher dans tableau",
      //sidebar messages/errors
      NEW_NAME: "Entrez le nom du nouveau groupe de modèles.",
      TOO_LONG: "Groupe de modèles trop long",
      NOT_UNIQUE: "Le nom du groupe de modèles doit être unique.",
      ILLEGAL_CHARS: "Utilisez seulement les caractères autorisés.",
      CREATED: "Groupe de modèles créé",
      FAILED_CREATE: "Échec de la création du groupe de modèles",
    },
  
  DownloadDfmTemplate: {
        FILENAME: "Nom du fichier :",
        DOWNLOADLINK: "Lien de téléchargement :",
        CALLBACK: "Callback.jsp",
        NOTIFICATION: "Notification.jsp",
        SERVICES: "Services.jsp",
        STORAGE: "Storage.jsp",
    STATISTIC: "Statistic.jsp",
        DOWNLOADCALLBACK: "Télécharger Callback.jsp",
        DOWNLOADNOTIFICATION: "Télécharger Notification.jsp",
        DOWNLOADSERVICES: "Télécharger Services.jsp",
        DOWNLOADSTORAGE: "Télécharger Storage.jsp",
    DOWNLOADSTATISTIC: "Télécharger Statistic.jsp"
    },

    TemplateChangeDialog: {
      CHANGESERVICETEMPLATETITLE: "Modifier le modèle de service",
      CHANGETEMPLATEHEADER: "Il est possible que des paramètres perdent leurs restrictions de modèle.",
      CHANGETEMPLATEBODY: "Voulez-vous toujours modifier le modèle de service ?",
      CANCEL: "Annuler",
      CHANGE: "Modifier",
    },

    RemoveNodeDialog: {
      REMOVENODETITLE: "Retirer le nœud",
      REMOVENODEBODY: "Cette opération supprimera le nœud sélectionné de l'anneau ? Voulez-vous continuer ?",
      REMOVE: "Retirer",
      CANCEL: "Annuler",
    },

    ModelManagement: {
      MODELMANAGER: "GESTIONNAIRE DE MODÈLES",
      TENANTID: "ID de locataire",
      MODELNAME: "Nom du modèle",
      SEARCH: "Rechercher",
      UPLOAD: "Téléverser",
      DELETE: "Supprimer",
      BROWSE: "Parcourir",
      CANCEL: "Annuler",
      BACK: "Retour",
      UPDATE_MODEL: "Mettre le modèle à jour",
      ERROR_MODEL_NOT_FOUND: "Erreur : Modèle introuvable.",
      ERROR_UPLOAD_MODEL: "Erreur : Échec du téléversement du modèle.",
      ERROR_DELETE_MODEL: "Erreur : Échec de la suppression du modèle.",
      ERROR_EMPTY_FIELD: "Erreur : Les champs ne doivent pas être vides!",
      ERROR_EMPTY_MODEL: "Erreur : Le modèle ne doit pas être vide!",
      ERROR_INVALID_TENANTID: "Erreur : L'ID de locataire que vous avez entré est non valide!",
      ERROR_INVALID_MODELNAME: "Erreur : Le nom de modèle que vous avez entré est non valide!",
      SUCCESS_MODEL_UPDATE: "Le modèle a été mis à jour.",
      SUCCESS_MODEL_UPLOAD: "Le modèle a été téléversé.",
      SUCCESS_MODEL_DELETE: "Le modèle a été supprimé.",
      BASIC_EDIT: "Édition de base",
      ADVANCED_EDIT: "Édition avancée",
      DISCARD_CHANGES: "Ignorer les modifications",
      AGGREGATES: "AGRÉGATS",
      ACTIVITYNAME: "Nom de l'activité",
      GROUPBY: "Regrouper par",
      SETPROPERTIESFILTERS: "Définissez les filtres des propriétés.",
      RUNQUERY: "Exécuter la requête",
      AGGREGATEGROUPS: "GROUPES D'AGRÉGATS",
      COMBINED_LOOKUPS: "RECHERCHES COMBINÉES",

    },

    DataDepotCenter: {
      MODEL_MANAGEMENT: "Gestion des modèles",
      MODEL_BUILDER: "Créateur de modèle",
      RUN_QUERY: "Exécuter la requête",
      ERROR_MODEL_NOT_FOUND: "Aucun modèle trouvé!",
      ERROR_EMPTY_FIELD: "Erreur : Les champs ne doivent pas être vides!",
      ERROR_INVALID_TENANTID: "Erreur : L'ID de locataire que vous avez entré est non valide!",
      ERROR_INVALID_MODELNAME: "Erreur : Le nom de modèle que vous avez entré est non valide!",
      FINISH_EDITING: "Terminer l'édition",
      HOME: "Accueil",
      DATA_DEPOT_CENTER: "Centre de stockage de données",
      WORK_WITH_NEW_OR_EXSISTING_MODEL: "Voulez-vous travailler avec un nouveau modèle ou un modèle existant ?",
      NEW: "Nouveau",
      EXISTING: "Existant",
      BUILD_OR_UPLOAD_MODEL: "Voulez-vous créer ou téléverser un modèle ?",
      BUILD: "Créer",
      UPLOAD: "Téléverser",
      MODELNAME: "Nom du modèle",
      TENANTID: "ID de locataire",
      FILTER: "Filtrer",
      CLEAR: "Effacer"
    },

    RunQuery: {
      TENANTID: "ID de locataire",
      MODELNAME: "Nom du modèle",
      SEARCH: "Rechercher",
      ERROR_QUERY_FAILED: "Aucun résultat trouvé!",
      ERROR_EMPTY_FIELD: "Erreur : Remplissez tous les champs obligatoires.",
      ERROR_INVALID_MAX_EVENTS: "Erreur : Le nombre maximal d'événements doit être un nombre entier. " +
              "10 sera utilisé comme valeur par défaut si vous laissez le champ vide.",
      uRUNQUERY: "EXÉCUTER LA REQUÊTE",
      PROPERTIES: "Propriétés",
      lAGGREGATES: "Agrégats",
      REQUEST_PARAMETERS: "PARAMÈTRES DE REQUÊTE",
      FEILDS_WITH: "Les champs avec",
      ARE_MANDATORY:"sont obligatoires, sauf pour les requêtes de clé primaire",
      START_TIME: "heure de début",
      END_TIME: "heure de fin",
      TRUE: "Vrai",
      FALSE: "Faux",
      RETURN_EVENTS: "événements retour",
      MAX_EVENTS: "événements max.",
      ROLLUP_PERIOD: "période de cumul",
      QUARTER_HOUR: "QUART D'HEURE",
      HALF_HOUR: "DEMI-HEURE",
      HOUR: "HEURE",
      DAY: "JOUR",
      WEEK: "SEMAINE",
      MONTH:"MOIS",
      QUARTER_YEAR:"TRIMESTRE",
      YEAR:"ANNÉE",
      TIME_ZONE: "fuseau horaire",
      QUERY_UNIQUE_VALUES: "Valeurs uniques de la requête",
      QUERY_RESULTS: "RÉSULTATS DE LA REQUÊTE",
      URL_NA: "URL : S.O"
    },
    ContextServices:{
      TASKS:"Tâches",
      TASK:"Tâche",
      TASKID:"Task_ID",
      STATES:"États",
      STATE:"État",
      NAME:"Nom",
      VALUE:"Valeur",
      COMPLETE:"Terminé"
    },

    KPIInfo: {
      NO_INFO: "Information non disponible ",
      ONLY_ACTIVE_JOURNEYS: "Impossible de calculer, seuls des parcours actifs existent.",
      ONLY_ACTIVE_STATES: "Impossible de calculer, seuls des états actifs existent.",
      NO_JOURNEYS: "Impossible de calculer, aucun parcours existant." ,
      ABOUT: "À propos de",
      SERVICE_NOT_DONE: "Service pas encore terminé",
      IN_PROGRESS: "et en cours",
      HOURS: "heures",
      DAYS: "jours",
      MINUTES: "minutes",
      CANNOT_CALCULATE: "Impossible de calculer",
      NO_STATES : "Impossible de calculer, aucun état existant.",
      ALL_SERVICES: "Tous les services"
    },

    TimelineGeneral: {
     MULTIPLE_CUSTOMERS: "Auxquels de ces clients faites-vous référence ?",
     CANCEL: "Annuler",
     ANON_ID : "ID anonyme :",
     SELECT_SERVICE : "Sélectionnez un service pour consulter ses informations.",
     NO_SERVICE: "Aucun service existant.",
     NO_STATES: "Aucun état existant.",
     CURR_SELECTED: "Actuellement sélectionné(s)"
    },

    FormControl: {
      CONNECT_FAILED: "Impossible de se connecter aux services de contexte.",
      EMAIL_FIND_FAILED: "Aucun service associé au client ayant ce courriel n'a été trouvé.",
      PHONE_FIND_FAILED: "Aucun service associé au client ayant ce numéro de téléphone n'a été trouvé.",
      FIND_FAILED: "Aucun service associé au"
    },


    ConfigView: {
        PORTRESTRICTION: "Configuration des restrictions de ports :",
        PORTNOTENABLED: "Les restrictions de ports n'ont pas été activées."
    }, 

    DownloadDfmTemplate: {
        FILENAME: "Nom du fichier :",
        DOWNLOADLINK: "Lien de téléchargement :",
        CALLBACK: "Callback.jsp",
        NOTIFICATION: "Notification.jsp",
        SERVICES: "Services.jsp",
        STORAGE: "Storage.jsp",
    STATISTIC: "Statistic.jsp",
        DOWNLOADCALLBACK: "Télécharger Callback.jsp",
        DOWNLOADNOTIFICATION: "Télécharger Notification.jsp",
        DOWNLOADSERVICES: "Télécharger Services.jsp",
        DOWNLOADSTORAGE: "Télécharger Storage.jsp",
    DOWNLOADSTATISTIC: "Télécharger Statistic.jsp"
    },
  
  MonitorView: {
    STATE_TYPES: {
      ACTIVE: "Actif",
      INACTIVE: "Inactive"
    },
    MAIN: {
      DATA_CENTERS: "Centres de données",
      ANALYTICS: "Analyses",
      OPTIONS: "Options",
      API_USAGE: "Utilisation API",
      MONITOR: "Surveillance",
      NODES: "Nœuds",
    },
    //Nodes page
    FILTER_STATUS: "Filtrer par état",
    FILTER_DATA_CENTER: "Rechercher dans Centre de données",
    FILTER_DISPLAY: "Affichage",
    FILTER_EXTERNAL: "Externe",
    FILTER_INTERNAL: "Interne",
    LAST_UPDATED: "Dernière mise à jour",
    EXTERNAL_CASSANDRA: "Configuration Cassandra externe",
    INFO_IP: "IP",
    INFO_TOKEN: "Jeton",
    INFO_NAME: "Nom",
    INFO_STATUS: "État",
    INFO_LOAD: "Charger",
    INFO_DATA_CENTER: "Centre de données",
    INFO_RACK: "Rack",
    INFO_OWN: "Personnel",
    RUNNING_SINCE: "Fonctionne depuis",
    REMOVE_NODE: "Retirer le nœud",
    REMOVE_NODE_INFO: "Cette opération supprimera le nœud sélectionné ? Voulez-vous continuer ?",
    BUTTON_REMOVE: "Retirer",
    BUTTON_CANCEL: "Annuler",
    GET_NODES_ERROR: "Erreur de récupération des informations de nœud",
    REMOVE_NODE_SUCCESS: "Succès du retrait du nœud",
    REMOVE_NODE_ERROR: "Retirer l'erreur de nœud",
    NO_DATA_CENTER: "Aucune info sur le centre de données",
    NO_NODES_FOUND: "Aucun nœuds trouvé.",
    HOST_IP: "Adresse IP de l'hôte",
    EXTERNAL_URL: "URL externe",
    NODE_HOST_NAME: "Nom de l'hôte",
    URI: "URI",
    SERVERS: "Serveurs",

    //monitor-options page
    SET_CONFIGURATION: "Définir la configuration",
    SEARCH_WIDGET: "Rechercher des widgets",
    NAME: "Nom",
    FETCH_DATA_INTERVAL: "Récupérer des intervalles de données (millisecondes)",
    VISUAL_ADJUSTMENTS: "Ajustements visuels",
    ENTER_PERCENTAGE: "Entrer le pourcentage",
    SET_ANALYTICS_THRESHOLD: "Définir la valeur seuil d'avertissement du nœud",
    CHOOSE_POSITIVE_INTEGER: "Veuillez entrer un nombre entier positif",
    
    //API Usage Page
    START: "Début",
    END: "Fin",
    INTERVAL : "Intervalle",
    QUERY_TYPE: "Type de requête",
    CALL_NAME: "Nom de l'appel",
    HOST_NAME: "Nom de l'hôte",
    CONTACT_CENTER_ID: "ID du contre de contacts :",
    SELECT_SERVICE: "Sélectionner un service",
    SELECT_ALL: "Tout sélectionner",
    QUARTER_HOUR: "15 min",
    HALF_HOUR: "30 min",
    HOUR: "Heure",
    DAY: "Jour",
    WEEK: "Semaine",
    MONTH: "Mois",
    COUNT: "Nombre",
    AVERAGE_DURATION : "Durée moyenne",
    START_NOT_BEFORE_END_DATE: "La date de début doit être antérieure à la date de fin.",
    DATE_RANGE_TOO_LARGE: "La plage de date est trop grande pour l'intervalle sélectionné.",
    PLEASE_SPECIFY: "Spécifiez",
    HOSTNAME_WARNING: "Aucun nom d'hôte n'est sélectionné.",
    NO_DATA_AVAILABLE: "Aucune donnée disponible",
    Y_AXIS_LABEL_AVG: "Temps de réponse moyen de l'API (millisecondes)",
    Y_AXIS_LABEL_COUNT: "Nombre d'appels d'API",
    CHOOSE_FROM_FOLLOWING: "Choisissez parmi les éléments suivants :",
    
    
  },

  //SAMPLES page

  SampleView: {
    FIRST_NAME: "Prénom",
    LAST_NAME: "Nom de famille",
    PASSWORD: "Mot de passe",
    SCENARIO: "Scénario",
    PROBLEM: "Problème",
    URL: "URL",
    SERVICE: "Service",
    PROVIDE_CODE: "Fournir le code",
    CONTACT_NUMBER: "Numéro du contact",
    COMET_NOTIFICATIONS: "Notifications Comet",
    SETTINGS:"Paramètres",
    CHAT: "Clavardage",
    QUEUE: "File d'attente",
    LAST_KNOWN_POSITION_IN_QUEUE: "Dernière position dans la file",
    LAST_KNOWN_ESTIMATED_TIME_TO_ANSWER: "Dernière heure de traitement (URS) :",
    AGENT_READY_THRESHOLD_PASSED: " Dépassement du seuil Agent prêt :",
    TOTAL_NUMBER_OF_INTERACTIONS_WAITING_FOR_THE_SAME_TARGET: "Nombre d'interactions en attente de la même cible :",
    RESET: "Réinitialiser",
    CONNECT: "Se connecter",
    NOT_APPLICABLE: "s.o.",
    ON: "Activé",
    OFF: "Désactivé",
    CLEAR: "Effacer",
    END_CHAT: "Terminer le clavardage",
    SEND: "Envoyer",
    NUMBER_TO_CALL: "Numéro à appeler",
    ACCESS_CODE: "Code d'accès",
    CLOSE: "Fermer",
    DIAL_PHONE: "Téléphone numérotation",
    DIAL_NUMBER: "Numéro numérotation",
    REFRESH_QUEUE_INFO: "Actualiser les infos de la file",
    VIEW_LOGS: "Afficher les journaux",
    CONFIRMATION: "Confirmation",
    OK: "OK",
    RESPONSE_FROM_GMS: "<--- Réponse de GMS : ",
    RESPONSE_FROM_GES: "<--- Réponse de GES : ",
    RESPONSE_FROM_GMS_VIA_COMET: "<--- Réponse de GMS via (Comet) : ",
    RESPONSE_FROM_GES_VIA_COMET: "<--- Réponse de GES via (Comet) : ",
    REQUEST_TO_GMS: "---> Demande vers GMS : ",
    REQUEST_TO_GES: "--->  Demande vers GES : ",

  },

    ModelBuilder: {
        AGGREGATES: "Agrégats",
        SAVEAGGREGATES: "Enregistrer les agrégats",
        NAME: "Nom",
        ENTER_AGGREGATE_NAME: "Entrer le nom de l'agrégat",
        DUPLICATE_AGGREGATE_NAME: "Dupliquer le nom de l'agrégat",
        CALCULATION: "Calcul",
        COUNT: "NOMBRE",
        SUM: "TOT",
        AVG: "MOY",
        UNIQUE: "UNIQUE",
        UNIQUE_TEXT: "UNIQUE_TEXT",
        TRIGGEREVENT: "Événement déclencheur",
        GLOBAL: "Global",
        GROUPBY: "Grouper par",
        PROPERTY: "Propriété",
        MUST_SELECT_PROPERTY: "Vous devez sélectionner une propriété pour le calcul.",
        TRUE: "Vrai",
        COMBINEDLOOKSUPS: "Recherches combinées",
        SAVEDCOMBINEDLOOKSUPS: "Enregistrer les recherches combinées",
        LOOKUPNAME: "Nom de la recherche",
        ENTER_LOOKUP_NAME: "Entrer le nom de la recherche",
        DUPLICATE_LOOKUP_NAME: "Dupliquer le nom de la recherche",
        MUST_BE_AT_LEAST_ONE_PROPERTY_SELECTED: "Vous devez sélectionner au moins une propriété",
        INDEXINGEVENTS: "Indexation des événements",
        MUST_BE_AT_LEAST_ONE_EVENT_SELECTED: "Vous devez sélectionner au moins un événement",
        MIN: "MIN",
        HOUR: "HEURE",
        DAY: "JOUR",
        NUMBER: "Numéro ?",

        EVENT_NAME: "Nom de l'événement",
        EVENT_DESCRIPTION: "Description de l'événement",
        PROPERTY_SAVE_EVENT: "Événement d'enregistrement de propriétés",
        TIME_TRACKED_EVENT: "Événement de suivi de temps",
        P_S_E_GOES_HERE: "L'aide pour les événements d'enregistrement de propriétés va ici.",
        T_T_E_GOES_HERE: "L'aide pour les événements de suivi de temps va ici.",

        SAVEEVENTS: "Enregistrer les événements",
        EVENTS: "Événements",

        DATADEPOT_MODEL: "Modèle de centre de stockage",
        EXPORT: "Exporter",
        RELOAD: "Recharger",
        IMPORT: "Importer",
        MODELNAME: "Nom du modèle",
        ENTER_YOUR_MODEL_NAME: "Entrez le nom de votre modèle.",
        ACTIVITY_NAME: "Nom de l'activité",
        ENTER_YOUR_ACTIVITY_NAME: "Entrez le nom de votre activité",
        ADD_ACTIVITY: "Ajouter une activité",
        DELETE_ACTIVITY: "Supprimer l'activité",
        PASTE_JSO_FILE_HERE: "Collez votre fichier JSON ici.",
        FAILEDTOLOAD: "Échec de chargement du fichier",

        WARNING_EDITING_JSON_DIRECTLY: "Attention : Modifier directement le fichier JSON ne garantit pas la validité du modèle.",
        PLEASE_USE_TOOL_ON_THE_LEFT: "Si possible, utilisez l'outil à gauche.",
        CLICKING_WILL_DISCARD_INVALID_CHANGES: "Cliquer sur Enregistrer ou Exporter éliminera tous les changements non valides.",
        MODEL_HAS_BEEB_UPDATED: "Le modèle a été mis à jour.",
        MODEL_NOT_GUARANTEED_TO_BE_VALID: "La validité du modèle n'est toutefois pas garantie.",

        PROPERTY_NOT_USED: "Propriété non utilisée dans les agrégats ou la recherche combinée",
        PROPERTY_NAME: "Nom de la propriété,",
        DEFAULT_VALUE: "Valeur par défaut",
        PRIMARY: "Primaire",
        P_K_I_GOES_HERE:"L'aide pour l'entrée d'une clé primaire va ici.",
        L_U_K_GOES_HERE: "L'aide pour l'entrée d'une clé de recherche va ici.",
        ENTER_PROPERTY_NAME: "Entrer le nom de la propriété",
        DUPLICATE_PROPERTY_NAME: "Dupliquer le nom",

        PROPERTIES: "Propriétés",
        SAVEPROPERTIES: "Enregistrer les propriétés",

        SEARCH_SETTINGS: "Paramètres de recherche",
        ROOLLUP_RANGE: "Plage de cumul des événements de suivi de temps",
        POSITIVE_NUMBER_PLEASE: "Entrez un nombre positif.",
        PROPERTIES_TTL_SETTINGS: "Durée de vie des propriétés en secondes",
        EVENTS_TTL_SETTINGS: "Durée de vie des événements en secondes",
        SAVE_SEARCH_SETTINGS: "Enregistrer les paramètres de recherche"
    },

    CallbackView_ANGULAR: {
        //Callback View with common Strings
        NEWCALLBACK: "Ajouter un nouveau rappel",
        COMPLETESCHEDULED: "Vous devez entrer l'heure de rappel souhaitée pour un rappel planifié.",
        CALLBACKTYPE: "Type de rappel",
        SERVICENAME: "Nom du service",
        IMMEDIATE: "Immédiat",
        SCHEDULED: "Planifié",
        CALLBACKPARAMETERS: "Paramètres de rappel",
        ADDITIONALPARAMETERS: "Propriétés supplémentaires",
        URSVIRTUALQUEUE: "File d'attente virtuelle URS",
        REQUESTQUEUETIMESTAT: "Demander les statistiques de temps pour la file d'attente",
        CANCEL: "Annuler",
        CONTINUE: "Continuer",
        SUBMIT: "Soumettre",
        STATE: "État",
        DESIREDCALLBACKTIME: "Heure de rappel souhaitée",
        PHONENUMBER: "Numéro de téléphone",
        REFRESH: "Actualiser",
        CREATECALLBACK: "Créer un rappel",
        ADVACEDOPTIONS: "Options avancées",
        CALLBACKSFOUND: "Rappel(s) trouvé(s)",
        CUSTOM_DATE_RANGE: "Plage de dates personnalisée",
        INCLUDE_SERVICE_ID_COLUMN: "Inclure une colonne d'ID de service",
        INCLUDE_SERVICE_NAME_COLUMN: "Inclure la colonne du nom de service",
        DISPLAY_CALLBACK_FOR: "Afficher les rappels pour",
        CUSTOMFIELDS: "Champs personnalisés",
        NO_CALLBACKS_FOUND: "Aucun rappel trouvé.",
        NOT_SPECIFIED: "Non spécifié",
        last_day: "24 dernières heures",
        last_week: "7 derniers jours",
        last_month: "30 derniers jours",
        day: "24 prochaines heures",
        week: "7 prochains jours",
        month: "30 prochains jours",
        current: "Aujourd'hui",
        _customer_number: "Numéro de téléphone",
        _service_name: "Nom du service",
        _desired_time_formatted: "Heure de rappel souhaitée",
        _callback_state: "État",
        _id: "ID de service",
        _day: "jour",
    DISPLAYING: "Affichage",
    OF: "de",
    LIMIT_REACHED: "Nombre maximal de rappels chargés. Il est possible qu'il y en ait davantage.",
    EWT: "Temps d'attente estimé",
    POSITION_IN_QUEUE: "Position dans la file d'attente",
    ETA_MINS: "minute(s)",
    ETA_SECS: "seconde(s)",
    LEGEND_USERTERMINATED: "Rappel USERTERMINATED",
    LEGEND_USERORIGINATED: "Rappel USERORIGINATED",
    LEGEND_FILTER: "Colonne filtrée",
    BACK_TO_TOP: "Retour au début",	
        EXPORT_CANCELLED_REPORTS: "Exporter les rapports annulés",	  

        //Callback Diagnostics
        EWT: "Temps d'attente estimé",
        POSITION_IN_QUEUE: "Position dans la file d'attente",
        ETA_HOURS: "heure(s)",
        ETA_MINS: "minute(s)",
        ETA_SECS: "seconde(s)",
        PRIORITY: "Priorité actuelle",
        AGENTSLOGGEDIN: "Agents connectés",
        ORSURL: "ORS URL",
        ORSSESSIONID: "ID session ORS",
        EWTATOFFER: "Temps d'attente estimé lors de l'offre de rappel",
        POSATOFFER: "Position à l'offre de rappel",
        CALLBACKTYPE: "Type de rappel",
        CALLBACKTIMEACCEPTED: "Heure rappel acceptée",
        CHANNEL: "Canal",
        SKILLEXPRESSION: "Routage cible",
        EWTATFIRSTDIAL: "Temps d'attente estimé lors du premier appel sortant",
        POSATFIRSTDIAL: "Position au premier appel sortant",
        TIMEATFIRSTDIAL: "Heure premier appel sortant",
        DIALATTEMPT: "Numéro tenté numérotation",
        TIMENEXTDIALATTEMPT: "Heure appel sortant suivant",
        ISSNOOZED: "Est mis en rappel",
        DIALRESULT: "Résultat numérotation",
        TIMECUSTOMERCONNECTED: "Heure connexion du client",
        REFRESH_ERROR: "Échec du chargement du rappel. Essayez d'actualiser le tableau.",
        APPVERSION: "Version du rappel",
        //Advanced Callback View
        ADD_COLUMN_FIELD: "Ajouter un champ de colonne",
        FILTER_TABLE_S_A_S: "Filtrer le tableau par états et service",
        CONFIGURE_COLUMNS: "Configurer les colonnes",
        ADD_A_COLUMN_FIELD: "Ajouter un champ de colonne",
        STATES: "États",
        SCHEDULED: "PLANIFIÉ",
        QUEUED: "EN FILE D'ATTENTE",
        ROUTING:"ROUTAGE",
        PROCESSING: "TRAITEMENT EN COURS",
        COMPLETED: "TERMINÉ",
        PAUSED: "EN PAUSE",
        SERVICES: "Services",
        ANYSERVICE: "N'importe quel service",
        MAX_NUMBER_OF_CALLBACKS_PER_SERVICE: "Nombre max. de rappels par service",
        CONFIGURE_DISPLAY: "Configurer l'affichage",
    CONFIGURE_RANGES: "Configurer la plage de dates personnalisée",
    ADD_RANGES: "Ajouter une plage de dates personnalisée",
    DAYS_PREVIOUS: "Jours auparavant",
        DAYS_AHEAD: "Prochains jours",

        //Edit Callback View
        EDIT_CALLBACK: "Modifier le rappel",
        CHANGE_DESIRED_DATE: "Changer l'heure souhaitée",
        DESIRED_DATE: "Date souhaitée",
        DESIRED_TIME: "Heure souhaitée",
        CHECK_AVAILABILITY: "Vérifier la disponibilité",
        AVAILABLE_TIMESLOT: "Plage horaire disponible",
        EDIT_CUSTOMER_LOOKUP_KEYS: "Modifier les clés de recherche de client",
        CLICK_THE_BUTTON_AGAIN:"Cliquez à nouveau sur ce bouton pour confirmer.",
        CONFIRM_CANCELLATION: "Confirmer l'annulation",
        CANCEL_CALLBACK: "Annuler le rappel",
        ORS_FAILURE_CANCEL_TOAST: "Annulation du rappel terminée malgré l'échec ORS",
        CURRENT_CALLBACK_INFO: "Informations à propos du rappel actuel",
        CALLBACK_TIME:"Heure du rappel",
        CALLBACK_NUMBER: "Numéro du rappel",

        //Reschedule Completed Callback View
        RESCHEDULE_COMPLETED_CALLBACK: "Replanifier le rappel terminé",
        LAST_CALLBACK_INFO: "Informations sur le dernier rappel",
        LAST_CALLBACK_TIME: "Heure du dernier rappel",
        DESIRED_CALLBACK_TIME: "Heure de rappel souhaitée",
        RESCHEDULE: "Replanifier",

        //New Callback View
        IMMEDIATE: "Immédiat",
        _SCHEDULED: "Planifié",
        CUSTOMER_NUMBER: "Numéro de client",
        ADD_NEW_PROPERTY: "Ajouter une nouvelle propriété",
        SELECT_PLACEHOLDER: "Choisissez parmi les éléments suivants",
        DEFINED_NUMBER: "_customer_number est défini pour le service de rappel.",
        DEFINED_TIME: "Le service de rappel a l'heure _desired_time définie.",

        //Cancel Callback View
        CANCEL_CALLBACK_BUTTON_LABEL: "Annuler les rappels",
        CANCEL_CALLBACK_MODAL_TITLE: "Annuler la confirmation des rappels",
        CANCEL_CALLBACK_CONFIRMATION: "Confirmer et annuler les rappels",
        NUMBER_OF_CALLBACKS_TO_CANCEL: "Rappels à annuler dans la page actuelle : ",
        ERROR_IN_CANCELLING_CALLBACKS: "Échec",
        CANCEL_CALLBACKS_FROM_ALL_PAGES: "Annuler tous les rappels dans la plage horaire actuelle",
        CANCELLATION_REASON: "Motif de l'annulation",
        ERROR_IN_CANCELLING_CALLBACKS_LABEL: "Erreur d'annulation : ",

        //Cancellations Report View
        DOWNLOAD_REPORT_CANCEL_CSV: "Exporter les rappels annulés",
        CANCELLATION_REPORT: "Rapport du résumé des annulations",

        //Placeholders
        SEARCH: "Rechercher",
        ALLFIELDS: "Tous les champs",
        SELECT_START_DATE: "Sélectionnez votre date de début",
        SELECT_END_DATE: "Sélectionnez votre date de fin",
        COLUMN_NAME: "Nom de la colonne",
        ALIAS: "Pseudonyme (facultatif)",
        SELECT_YOUR_DATE: "Sélectionnez votre date",
        HOUR: "Heure",
        MINUTE: "Min",
        LOOK_UP_VALUE: "Valeur de recherche",
        OPTIONAL: "Facultatif",
        PARAMETER_NAME: "Nom du paramètre",
        PARAMETER_VALUE: "Valeur du paramètre",
        YOUR_CALLBACK_NUMBER: "Votre numéro de rappel",
    RANGE_NAME: "Nom de la page",
    OFFSET: "Décalage",

        //ERROR MESSAGES
        ERROR: "Erreur",
        AUTHENTICATION_ERROR_RELOAD: "Votre session a expiré. Rechargez la fenêtre.",
        PLEASE_CHOOSE_A_DATE: "Sélectionnez une date.",
        MAX_RANGE_ONE_MONTH: "La plage maximale est d'un mois!",
        START_DATE_NOT_BEFORE_END_DATE: "La date de début est ultérieure à la date de fin!",
        MUST_BE_NUMBER: "Le maximum de rappels doit être une valeur numérique",
    MUST_BE_NUMBER_RANGE: "Le décalage doit être une valeur numérique",
        MUST_BE_UNIQUE: "Les noms de colonnes doivent être uniques",
    MUST_BE_UNIQUE_RANGE: "Les noms de plages doivent être uniques",
    MUST_ENTER_OFFSET: "Vous devez entrer un décalage.",
    MUST_ENTER_RANGE_NAME: "Vous devez entrer un nom pour la plage de dates personnalisée.",
    OFFSET_MUST_BE_AFTER: "La date de fin de la plage personnalisée doit être ultérieure à la date de début",
        INVALID_TIME_INPUT: "Vos données d'heure ne sont pas valides.",
        MUST_SELECT_TIMESLOT: "Vous devez sélectionner une plage horaire.",
        NEW_DATE_TIME_SELECTED: "Vous devez choisir une nouvelle date/heure pour replanifier.",
        OFFICE_IS_CLOSED: "Nos bureaux sont actuellement fermés.",
        TIME_PASSED_ALREADY: "L'heure que vous avez entrée est déjà passée.",
        BUSINESS_HOURS_SERVICE_OPTION_IS_INVALID: "L'option _business_hours_service n'est pas valide pour ce service.",
        CAPACITY_SERVICE_NOT_CONFIGURED: "Configurez les services _capacity et/ou _capacity_add dans le service capacité.",
        SERVICE_USERORIGINATED: "Impossible de créer un service de type USERORIGINATED depuis Admin UI.",
        INVALID_CUSTOMER_NUMBER: "Entrez un numéro de client valide.",
        SELECT_DESIRED_DATE: "Vous devez sélectionner la date souhaitée.",
        NO_TIMESLOTS: "Aucune plage horaire n'est disponible pour cette date. Sélectionnez une nouvelle date.",
        SELECT_DESIRED_TIME: "Vous devez sélectionner l'heure souhaitée.",
        CREATE: "Créer",
        NAME_TOO_LONG : "Limitez le nom à 64 caractères.",
        SEARCH_PLACEHOLDER: "Rechercher dans tableau",
    NO_SERVICE_SELECTED: "Aucun service sélectionné",
	
	//Exceptions
	//TODO: add exceptions
	//NUMBER_ALREADY_BOOKED(40001)
	NUMBER_ALREADY_BOOKED: "There is already {max_queued} or more Callbacks QUEUED for this number, please refer to {queue_checking} for detail.",
	
	//THROTTLE_SERVICE_LIMIT(40002)	
    THROTTLE_SERVICE_LIMIT: "Limit of queued callbacks for {service} is reached.",
	//THROTTLE_SERVICE_INTERVAL_LIMIT(40003)	
    THROTTLE_SERVICE_INTERVAL_LIMIT: "Limit of queued callbacks for {service} is reached for interval {interval}s.",
	//THROTTLE_SERVICE_PARAMETER_LIMIT(40004)
    THROTTLE_SERVICE_PARAMETER_LIMIT: "Limit of queued callbacks for {service} is reached for parameter {parameter}. Reached {attempts} times today.",
	
    // BAD_PARAMETER(40010)
	MISSING_CALLBACK_OPTION: "Cannot create service, missing mandatory callback option {option}",
    EMPTY_CALLBACK_OPTION: "Cannot create service, empty mandatory callback option {option}",	
    NO_TIME_SLOTS: "No time slots available. The requested time period is in the past.",
    DAY_PARAM_RANGE: "day parameter must be between 1 and 7, inclusively. Actual value is: {day}",
    CALLBACK_TIME_IN_PAST: "Callback request contains _desired_time property in the past (-{rejectTimePastLimit} < {rawdiff} < {rejectTimeFutureLimit}) - epoch {epoch}",
    CALLBACK_TIME_IN_FUTURE: "Callback request contains _desired_time property too far in future (-{rejectTimePastLimit} < {rawdiff} < {rejectTimeFutureLimit}) - epoch {epoch}",
    CALLBACK_NO_LOOKUP_KEYS: "Callback {id} does not contain the mandatory customer lookup keys {keys}",
    CALLBACK_NO_TIME_PROP: "Callback {id} does not contain _desired_time property.",
    NO_PROPERTIES: "No lookup possible. No properties to look for.",
    NO_PARAMETERS: "No lookup possible. Try parameters {lookup_key_string}",
    MISSING_CALLBACK_PARAM: "Cannot create service, missing mandatory callback parameter {customer_number}",
	
    //INVALID_OPERATION(40020)	
	REQUEST_CALLBACK_CHECK_PARAM: "Request cannot be processed because callback {id} to copy is not COMPLETED. Check parameter _copy_from_id",
    CHECK_REQUEST_OR_SERVICE: "Tenant ID '{ccid}' is not managed by this application, check request parameter or service option ",
    ADJUST_QUERY_PARAM_OPTIONS: "Query range spans too much rows (%d) while limit is %d rows. Adjust query parameters or options (%s).",
    CALLBACK_LOST_SERVICE_NAME: "Callback {id} cannot be processed. Lost service name.",
    CALLBACK_NO_ORS_FOUND: "Callback {id} cannot be cancelled - No ORS session found. (_callback_state=QUEUED while _ors_session_id=null?)",
    UNABLE_PROCESS_ORS_CANCEL_REQ: "Callback {id} cannot be cancelled - unable to process ORS cancel request : {message}",
    CALLBACK_ORS_RESP_NULL: "Callback {id} cannot be cancelled - ORS response is null.",
    INVALID_SERVICE_CALLBACK: "Invalid service stored for callback {id}.",
    REJECTING_UPDATE: "Rejecting update : {service}=[{id} @ {time}] - reached state COMPLETED",
    CALLBACK_NO_DESIRED_TIME_PROP: "Callback {id} does not contain _desired_time property.",
    CALLBACK_CANCELLED_OR_COMPLETED: "Callback {id} cannot be cancelled or completed - _callback_state={state}",
    CALLBACK_CANNOT_DELETE: "Callback {id} cannot be deleted - _callback_state={state}",
    CALLBACK_NOT_SCHEDULED: "Callback {id} is no longer scheduled. State={state}",
    CALLBACK_INVALID_TIME_STORED: "Callback {id} has invalid desired time stored.",
    CANNOT_PROCESS_FILTER_PARAM: "Cannot process 'filter' parameter correctly : {filter}",
    SERVICE_NOT_SPECIFIED: "Service name not specified", 

	//CALLBACK_NOT_FOUND(40030)
    CALLBACK_NOT_FOUND: "Callback {id} to copy from cannot be found",
	NO_SUCH_REQUEST: "No such request :{serviceId}",
	CALLBACK_ID_CANNOT_BE_FOUND: "Callback {id} cannot be found",
	NO_SUCH_REQ_TO_UPDATE: "No such request to update : {service_name}=[{serviceId} @ {desiredTimeStr}]",
	CALLBACK_ID_CANNOT_BE_FOUND_1: "Callback {id} cannot be found - {service}=[{id} @ {time}]",
	CALLBACK_ID_NOT_FOUND_PING: "Callback {id} cannot be found (ping process)",
	
	//NUMBER_REJECTED(40040)
    INVALID_CHECK_OPTION: "Customer Number is not allowed, because it is invalid. Check option {impossible_phone_nos} ",
    PREMIUM_CHECK_OPTION: "Customer Number is not allowed, because it's a premium number. Check option {premium_phone_nos} ",
    FAILED_VALIDATING: "Customer Number is not allowed, because it failed validating. Check option {impossible_phone_nos} ",
    OPTION_EXCEPTIONS: "Customer Number is not allowed. Check option {exceptions} ",
  
    //SLOT_UNAVAILABLE(40050)
    PROPOSING_TIME_SLOTS: "{reason}. Proposing time slots.",
	
	//SLOT_UNAVAILABLE_PROPOSAL(40051)
    NO_TIME_SLOTS_1: "No time slots available.",
	
    //CAPACITY_ERROR(50004)    
    CAPACITY_ERROR: "{error}",
	
	//CALENDAR_ERROR(50005)
    CALENDAR_ERROR: "{message}",
	
	//ORS_MAX_SUBMIT_RETRIES(50006)
    ORS_MAX_SUBMIT_RETRIES: "Callback {id} reached maximum attempts to submit to ORS reached ({max-attempts})",
	
	//CALLBACK_LOCKED(50007)
    CALLBACK_LOCKED: "Error processing callback {id} - unable to lock callback in {interval}ms",
	
	//BAD_CONFIGURATION(50020)
    SERVICE_NOT_CONFIGURED: "Option service.{service} / {business_hours} not configured.",
	MISSING_CHAT_ENDPOINT: "Missing default_chat_endpoint option in chat section because this service has parameter _media_type=chat",
	MISSING_CLIENT_TIMEOUT: "Missing default _client_timeout option in chat section because this service has parameter _media_type=chat",
	SERVICE_CONFIGURED_INCORRECTLY: "Option service.{service} / {option} configured incorrectly.",
	OPTION_INVALID: "Option {business_hours} is invalid: {error}",
	VALIDATE_COUNTRY_PHONE_NO: "Service option {service} / {default_country} is not configured. But option {impossible_phone_nos} is set. We cannot validate phone numbers without knowing the country.",						
    VALIDATE_COUNTRY_PHONE_NOS_PREMIUM: "Service option {service} / {default_country} is not configured. But option {premium_phone_nos} is set. We cannot validate phone numbers without knowing the country.",
	SERVICE_UNDEFINED: "Service undefined: {service}",
	SERVICE_UNKNOWN_VALUE: "Service {service} has unknown value for option {option_type}",
	SERVICE_HAS_OPTION: "Service {service} has option {option_type} != {option_ors}",
	SERVICE_OPTION_DEFAULT: "Service {service} has option {option_service} != {option_service_default}",
	UNABLE_TO_PARSE_OPTION: "Unable to parse option: {wait_time} ={statistic}",
	
    //ORS_ERROR(50030)
	UNABLE_TO_CREATE_ORS_SESSION: "Unable to create ORS session.",
    ORS_SERVICE_CREATE_ERROR: "Unable to create service using ORS. Check ORS logs for errors.",
    CALLBACK_ORS_RESPONSE: "{response}",
    INVALID_ORS_SESSION: "Invalid ORS response",

	//SERVICE_REDIRECT_FAILED(50040)
    SERVICE_REDIRECT_FAILED: "{message}",
	
    //UNKNOWN_ERROR(50050)
	ERROR_PROCESSING_CALLBACK: "Error processing callback {serviceId}",
    FAILED_TO_SUBMIT_ORS: "Failed to submit to ORS",
    ERROR_DELETING_CALLBACK: "Error deleting callback {uuid}", 

    //STORAGE_ERROR(50060)
	FAILURE_QUEUE_CALLBACK: "Failure queuing callback : ",
    REGISTER_QUEUE: "Register Queue - {queueName} - Failure : ", 
    UNREGISTER_QUEUE: "Failure Unregister Queue - {queueName}",
    FAILURE_DELETING_CALLBACK: "Failure deleting callback : ",
	

        CANCELLATION_REASONS : {
          AM_CONNECTED : "SUIS_CONNECTÉ",
          RESCHEDULED : "REPLANIFIÉ",
          REDIAL_LIMIT_REACHED : "LIMITE_RENUMÉROTATION_ATTEINTE",
          FAILED : "ÉCHEC",
          ABANDONED_IN_QUEUE : "ABANDONNÉ_DANS_FILE",
          AGENT : "AGENT",
          FAIL_LOAD_MESSAGE_FILE : "ÉCHEC_CHARGEMENT_FICHIER_MESSAGE",
          CANCELLED : "ANNULÉ",
          NOT_AVAILABLE : "NON_DISPONIBLE",
          FAIL_INTERACTION_DELETED : "ÉCHEC_CAR_INTERACTION_SUPPRIMÉE",
          AGENT_CONNECTED : "AGENT_CONNECTÉ",
          FAIL_TARGET_NOT_FOUND : "ÉCHEC_CAR_CIBLE_INTROUVABLE",
          FAIL_ERROR : "ÉCHEC_CAR_ERREUR",
          FAIL_TIMEOUT_TTL : "ÉCHEC_CAR_DÉLAI_DÉPASSÉ",
          FAIL_IXN_UNKNOWN_MEDIA_TYPE : "ÉCHEC_CAR_TYPE_MÉDIA_INCONNU",
          FAIL_NO_CUSTOMER_NUMBER : "ÉCHEC_CAR_AUCUN_NUMÉRO_CLIENT",
          FAIL_USER_NO_CONFIRM : "ÉCHEC_CAR_CONFIRMATION_UTILISATEUR_MANQUE",
          FAIL_QUEUEING : "ÉCHEC_DE_MISE_EN_FILE_ATTENTE",
          FAIL_AGENT_CONNECT : "ÉCHEC_DE_CONNEXION_À_AGENT",
          FAIL_CALL_TO_CUSTOMER : "ÉCHEC_DE_CONNEXION_AU_CLIENT",
          FAIL_INCORRECT_CONFIG_MEDIA_TYPE : "ÉCHEC_CAR_TYPE_MÉDIA_INCORRECT",
          FAIL_FAX_REACHED : "ÉCHEC_CAR_ENVOYÉ_À_TÉLÉCOPIEUSE",
          SUBMIT_ERROR : "ERREUR_SUBMISSION",
          SUBMIT_FAILED: "ÉCHEC_SOUMISSION",
          FAIL_USER_UNREACHABLE : "ÉCHEC_CAR_UTILISATEUR_INTROUVABLE",
          CANCELLED_BY_ADMIN : "ANNULÉ_PAR_ADMIN",
          AGENT_PREVIEW_CANCEL_AFTER_n_REJECTS : "APERÇU_AGENT_ANNULÉ_APRÈS_<n>_RÉJECTIONS", //leave <n> in translated version. <n> will be replaced by number returned from API,
          NO_AGENT_DISPOSITION : "AUCUNE_DISPOSITION_AGENT",
          SUCCESS : "RÉUSSITE",
          BUSY : "OCCUPÉ",
          NO_ANSWER : "PAS_DE_RÉPONSE",
          SIT_TONE : "TONALITÉ_SIT",
          ANSWERING_MACHINE : "RÉPONDEUR",
          CUSTOMER_NOT_KNOWN : "CLIENT_INCONNU",
          CUSTOMER_NOT_PRESENT : "CLIENT_ABSENT",
          WRONG_CUSTOMER_NUMBER : "MAUVAIS_NUMÉRO_CLIENT"
        },
    },
  
  CapacityView: {
  CANCEL: "Annuler",
  SAVE: "Enregistrer",
  RESET: "Réinitialiser",
  GROUP_EDIT_ROW_LABEL: "Définir la plage horaire",
  GROUP_EDIT_COL_LABEL: "Définir le jour",
  TIMESTAMP: "Horodatage",
  CAPACITY: "Capacité",
  CAPACITY_ADD_LIST_LABEL: "Exceptions de capacité",
  CAPACITY_ADD_INPUT_LABEL: "Ajouter une exception de capacité",
      CAPACITY_EMPTY: "Cliquez pour modifier.",
  FIRST_DAY_INDEX: "6",
  SHORTDAY: [
    "lun.",
    "mar.",
    "mer.",
    "jeu.",
    "ven.",
    "sam.",
    "dim."
      ],
  TOASTER:{
    UPDATE_SUCCESS: "Mise à jour des données réussie",
    UPDATE_ERROR: "Erreur de chargement des données",
    CONNECTION_ERROR: "Erreur de connexion au serveur",
    PERCENTAGE_ERROR: "Entrez un chiffre compris entre 0 et 100.",
  }
  },

    OfficeHourView:{
      SEARCH_ITEMS: "Rechercher des éléments",
      SEARCH: "Rechercher",
      SEARCH_FOR:"Rechercher",
      NOT_FOUND: "introuvable",
      CONFIGURED_SERVICES: "Services configurés",
      OFFICE_HOURS: "Heures d'ouverture",
      CAPACITY: "Capacité",
      TODAY: "Aujourd'hui",
      DAY: "Jour",
      WEEK: "Semaine",
      MONTH: "Mois",
      HOURS: "heures",
      SETTINGS: "Paramètres",
      CHECKBOX_LABEL: "Heures normales d'ouverture",
      BH_REGULAR_EVENT_LABEL: "Heures normales d'ouverture",
      BH_ADD_EVENT_LABEL: "Heures d'ouverture spéciales",
      HOLIDAY_EVENT_LABEL: "Congé",
      ALL_DAY: "Toute la journée",
      TIME: "Heure",
      NEW_OFFICE_HOURS: "Nouvelles heures d'ouverture",
      MODIFY_OFFICE_HOURS: "Changer les heures d'ouverture",
      BLOCK_TYPE: "Type de bloc",
      WEEKS_SELECTED: "Semaines sélectionnées :",
      FOR_DAYS: "Pour les jours :",
      BLOCK_ERROR: "Erreur : L'heure De doit impérativement être antérieure à l'heure À.",
  NO_DATE_ERROR: "Erreur : Aucune date sélectionnée.",
  DELETE_ERROR_PREFIX: "Bouton Supprimer désactivé :",
  ALLOCATE_ERROR_PREFIX: "Bouton Créer/Mettre à jour désactivé",
  CUSTOM_ERROR: "Une erreur s'est produite.",
      BH_REGULAR_TYPE: "Heures normales d'ouverture (bh_regular)",
      BH_ADD_TYPE: "Exception (bh_add)",
      HOLIDAY_TYPE: "Congé (jour férié)",
      THIS_IS_AN_ALL_DAY_EVENT: "Cet événement dure toute la journée.",
      BLOCK_TIME_SLOT: "Bloc plage horaire",
      FROM: "De",
      TO: "À",
      CANCEL: "Annuler",
      DELETE: "Supprimer",
      UPDATE: "Mettre à jour",
      CREATE: "Créer",
      CONFIRM: "Confirmer",
      MOVE: "Déplacer",
      RESIZE: "Redimensionner",
      TOASTER_SUCCESS: "Heures d'ouverture créées/mises à jour avec succès.",
      TOASTER_UPDATE_FAIL: "Échec de création/mise à jour des heures d'ouverture.",
      TOASTER_DELETE_SUCCESS: "Heures d'ouverture supprimées avec succès.",
      TOASTER_CANCELLED: "Annulation de la création/mise à jour des heures d'ouverture.",
      BH_REGULAR: "BH Regular",
      BH_ADD: "BH Add",
      HOLIDAY: "Congé",
      OLD_TIME: "Ancienne heure",
      NEW_TIME: "Nouvelle heure",
      MODAL_TITLE: "Paramètres",
      ALL_DAY_ROW: "Afficher la ligne Toute la journée",
      POPOVERS: "Fenêtres Popover",
      CHECKBOX: "Case à cocher",
      ON: "Activé",
      OFF: "Désactivé",
      TIME_INTERVAL: "Intervalle de temps par bloc",
      FIRST_DAY: "Premier jour de la semaine",
      DAYS_TO_HIDE: "Jours à masquer",
      DISPLAYED_CALENDARS: "Calendriers affichés",
      OFFICE_TIMEZONE: "Fuseau horaire du bureau",
      DISPLAY_TIMEZONE: "Fuseau horaire de l'affichage",
      TIMEZONE_ERROR: "Le fuseau horaire spécifié est non valide",
      CLOSE: "Fermer",
      SAVE: "Enregistrer les modifications",
      NONE: "Aucun",
      ERROR: "Erreur",
      SETTINGS_ERROR: "Vous ne devez pas masquer au moins une journée",
      AUTHENTICATION_ERROR_RELOAD: "Votre session a expiré. Rechargez la fenêtre.",
      DURATION_ERROR: "Les heures d'ouverture ne peuvent pas être plus longues que",
      START_NOT_BEFORE_END: "L'heure de début doit être antérieure à l'heure de fin.",
      ALL_PARAMETERS: "Tous les paramètres",
  CUSTOM_ERROR_MESSAGE: "Une erreur s'est produite.",
  NO_DATE_ERROR_MESSAGE: "Aucune date sélectionnée",
  DELETE_ERROR_PREFIX: "Erreur - Impossible de supprimer l'événement : ",
  ALLOCATE_ERROR_PREFIX: "Erreur - Impossible de mettre à jour l'événement : ",
  TIMEZONE_NOT_EQUAL: "Le calendrier est en mode lecture seule, car le fuseau horaire du bureau ne correspond pas au fuseau horaire affiché.",
      NO_OFFICE_HOURS_TEMPLATE_FOUND: "Aucun modèle d'heures d'ouverture trouvé"
    },

    ConfiguredServicesView:{
      SERVICES: "Services",
      EXPAND: "Développer tout",
      COLLAPSE: "Réduire tout",
      ADVANCED_PARAMETERS: "Paramètres avancés",
      ADD_NEW: "Ajouter",
      CLONE: "Cloner",
      DELETE: "Supprimer",
      REFRESH: "Actualiser",
      NAME: "Nom",
      VALUE: "Valeur",
      DESCRIPTION: "Description",
      REQUEST_PARAMETER: "Paramètre de requête",
      CREATE: "Créer",
      DELETE_SETTING: "Supprimer le paramètre",
      REMOVE_CONFIRMATION: "Voulez-vous vraiment retirer",
      DELETE_SERVICE: "Supprimer le service",
      DELETE_CONFIRMATION: "Voulez-vous vraiment supprimer",
      CANCEL: "Annuler",
      DELETE: "Supprimer",
      CONFIRM: "Confirmer",
      ERROR: "Erreur",
      ADD_NEW_SERVICE: "Ajouter un nouveau service",
      ADD_NEW_OFFICE_HOURS: "Ajouter de nouvelles heures d'ouverture",
      SERVICE_TEMPLATE: "Modèle de service",
      SERVICE_NAME: "Nom du service",
      COMMON_DEFAULT_CONFIGURATIONS: "Configuration par défaut",
      ADD: "Ajouter",
      SETTING_PLACEHOLDER: "cliquer ici pour définir la clé",
      REQUIRED_PARAMETER_TOOLTIP: "Ce paramètre est obligatoire et ne peut pas être modifié.",
      REQUEST_PARAMETER_TOOLTIP: "Ceci est un paramètre de requête.  Si vous le définissez ici, il remplacera le paramètre fourni dans la requête.",
      REVERT_PARAMETER_TOOLTIP: "Revenir à la valeur par défaut/globale",
      SUCCESS: "Succès",
      RENAME_ERROR: "Erreur renommé et supprimé",
      NOT_VALID: "Non valide",
      NO_CATEGORIES_TO_CHOOSE_FROM: "Aucune catégorie disponible",
      CHOOSE_FROM_FOLLOWING: "Choisissez parmi les éléments suivants...",
      SELECT_CATEGORIES_TO_SHOW: "Sélectionner des catégories",
      SEARCH_PLACEHOLDER: "Rechercher dans tableau",
      SELECT_ALL: "Tout sélectionner",
      MAX_LENGTH_PLACEHOLDER: "Sélectionné",
      PARAMETER_EXISTS: "Le paramètre existe déjà",
      DUPLICATE_SUCCESS: "Duplication réussie",
      DUPLICATE_ERROR: "Erreur de duplication",
      CANNOT_BE_DUPLICATED: "Cet élément ne peut pas être dupliqué",
      REFRESHED: "Actualisé",
      SERVICE_DELETED: "Service supprimé",
      SERVICE_DELETE_FAILED: "Échec de suppression du service",
      ROW_NOT_SELECTED_FOR_DELETE: "Ligne non sélectionnée pour la suppression.",
      CANNOT_DELETE_PARAMETER: "Impossible de supprimer un paramètre obligatoire.",
      DELETE_SUCCESS: "Suppression réussie!",
      CHOOSE_A_TEMPLATE: "Sélectionnez un modèle.",
      CHOOSE_A_NAME: "Sélectionnez un nom.",
      NAME_TOO_LONG: "Limitez le nom à 64 caractères.",
      NAME_EXISTS: "Le nom existe déjà. Veuillez en choisir un autre.",
      SERVICE_CREATED: "Service créé",
      SERVICE_CREATE_FAILED: "Échec de création du service",
      NEW_SERVICE_NAME: "Nom du nouveau service",
      CLICK_TO_SET_KEY: "cliquer ici pour définir la clé",
      CLICK_TO_SET_VALUE: "cliquer ici pour définir la valeur",
      AUTHENTICATION_ERROR_RELOAD: "Votre session a expiré. Rechargez la fenêtre.",
      TABLE: "Tableau",
      CALENDAR: "Calendrier",
  REQUIRED_PARAMETER_POP: "Spécifiez une valeur pour ",
      NO_SERVICES_FOUND: "Aucun service trouvé",
      DUPLICATE_IMPORT: "Les heures d'ouverture sont déjà importées.",
      RESULTS: "Résultats",
      OF: "de",
      CALLBACK: "Rappel",
      OFFICE_HOURS: "Heures d'ouverture",
      CAPACITY: "Capacité",
      GET: "Obtenir",
      MATCH_INTERACTION : "Correspondance d'interaction",
      REQUEST_ACCESS: "Demande d'accès",
      REQUEST_CHAT: "Demande de clavardage",
      URS_STAT: "Statistique URS",
      REQUEST_INTERACTION: "Demande d'interaction",
      MISCELLANEOUS: "Divers",

      ServiceTemplateProfiles: {
        USER_ORIGINATED_IMMEDIATE: "Rappel immédiat par le client",
        USER_ORIGINATED_DELAYED: "Rappel différé par le client",
        USER_TERMINATED_IMMEDIATE: "Rappel immédiat du client",
        USER_TERMINATED_DELAYED: "Rappel différé du client",
        USER_TERMINATED_AGENT_PREVIEW: "Rappel du client avec prévisualisation de l'agent", 
        CHAT_IMMEDIATE: "Immédiat",
        CHAT_DELAYED: "Chat différé",
        SAMPLES: "Examples",
      },
    },
  
  ServiceTemplatesViewNew:{
  SERVICE_TEMPLATES_LABEL: "Modèles de service",
  ID_LABEL: "ID",
  DEFAULT_VALUE_LABEL: "Valeur par défaut",
  DESCRIPTION_LABEL : "Description",
  TABLE_SEARCH_PLACEHOLDER: "Rechercher dans le tableau",
  SELECT_CATEGORIES_TO_SHOW: "Sélectionner des catégories",
  NO_CATEGORIES_TO_CHOOSE_FROM: "Aucune catégorie disponible",
  SELECT_ALL: "Tout sélectionner",
  MAX_LENGTH_PLACEHOLDER: "Sélectionné",
  UPLOAD_LABEL: "Téléverser",
  DELETE_LABEL: "Supprimer",
  TEMPLATE_SEARCH_PLACEHOLDER: "Modèles de service de recherche",
  NO_SERVICE_TEMPLATES: "Aucun modèle de service trouvé",
  UPLOAD_SUCCESS: "Téléversement réussi",
  UPLOAD_ERROR: "Erreur de téléversement",
  FETCHING_ERROR: "Erreur de récupération des modèles",
  FILETYPE_ERROR: "Type de fichier non valide",
  DELETE_TEMPLATE_LABEL: "Supprimer",
  CANCEL_LABEL: "Annuler",
  CONFIRM_LABEL: "Confirmer",
  DELETE_SUCCESS: "Suppression réussie",
  DELETE_ERROR: "Erreur de suppression de modèle",
  REFRESH_TEMPLATE_LABEL: "Actualiser",
  REFRESH_SUCCESS: "Actualisation réussie",
  REFRESH_ERROR: "Échec de l'actualisation"
    },

    HOMEVIEW: {
      ADMIN_UI: "Services et Outils",
      SERVICES: "Services",
  CALLBACKENGAGEMENT: "Rappel",
      CONTEXT_SERVICES: "Services de contexte",
      JOURNEY_TIMELINE: "Chronologie de parcours",
  MESSAGE_INFO: "Il n'y a pas d'option disponible pour ce rôle.",
  MESSAGE_ERROR: "Aucun rôle n'a été trouvé pour l'utilisateur actuel. Assurez-vous que les rôles sont configurés correctement et connectez-vous de nouveau."
    },

    ErrorModal: {
      CLOSE: "Fermer",
      RELOAD: "Recharger"
    },

    NavBar: {
        nav_header:                       "Services mobiles",
        nav_dashboards:                   "Tableaux de bord",
    nav_monitor:						"Surveillance",
        nav_callback:                     "Rappel",
        nav_configured_services:          "Services",
    nav_tools:						"Outils",
    nav_tools_resources:				"Ressources",
    nav_tools_patterns:				"Modèles",
    nav_tools_service_templates:		"Modèles de service",
    nav_tools_download_dfm:			"Télécharger DFM",
    nav_tools_config:           "Config",
        nav_cs:                           "Services de contexte",
        nav_dashboards_handletime:        "Temps de traitement",
        nav_reports:                      "Rapports",
        nav_account:                      "Nom d'utilisateur",
        nav_account_manageaccount:        "Gérer le compte...",
        nav_account_settings:             "Paramètres...",
        nav_logout:                       "Se déconnecter",
        nav_search:                       "Rechercher",
        nav_help:                         "Aide",
        nav_tools_reporting:              "Rapports",
        nav_tools_metrics:                "Mesures", //will replace above
        nav_tools_sample:                 "Échantillon",
        nav_office_hours:                 "Heures d'ouverture",
        nav_journey_timeline:             "Chronologie de parcours"
        
    },

    Main_Login: {
      title: "Brezhoneg",
      APP_NAME_GMS_LOGIN: "GMS Management UI - Connexion",
      APP_NAME_GES_LOGIN: "GES Management UI - Connexion",
      loginFormTitle: {
          username:"Nom d'utilisateur",
          password:"Mot de passe",
          language:"Yezh",
          button: "Kennaskañ",
          forgotPassword:"Mot de passe oublié ?",
          page:"Degemer mad",
          copyright:"2020 Genesys Telecommunications Laboratories",
          version:"1.0.0",
          termOfUse:"Conditions générales d'utilisation",
          privacyPolicy:"Politique de confidentialité"
      },
      errorMessages: {
          incorrectLogin: "Nom d'utilisateur et/ou mot de passe incorrect(s).",
          frameWorkConnectionError: "Perte de la connexion au serveur de configuration.",
          emptyField: "Remplissez tous les champs obligatoires.",
          connectionError: "Erreur de connexion au serveur",
          maxSessions: "Cet utilisateur a atteint le nombre maximum de connexions simultanées autorisé."
      }
    },

    DATETIME_FORMATS: {
      DAY: [
        "Sul",
        "Lun",
        "Meurzh",
        "Merc'her",
        "Yaou",
        "Gwener",
        "Sadorn"
      ],
      MONTH: [
        "Genver",
        "C'hwevrer",
        "Meurzh",
        "Ebrel",
        "Mae",
        "Mezheven",
        "Gouere",
        "Eost",
        "Gwengolo",
        "Here",
        "Miz Du",
        "Kerzu"
      ],
      SHORTDAY: [
        "dim",
        "lun",
        "mar",
        "mer",
        "jeu",
        "ven",
        "sam"
      ],
      MINDAY: [
        "dim",
        "lun",
        "mar",
        "mer",
        "jeu",
        "ven",
        "sam"
      ],
      SHORTMONTH: [
        "janv.",
        "févr.",
        "mars",
        "avr.",
        "mai",
        "juin",
        "juil.",
        "août",
        "sept.",
        "oct.",
        "nov.",
        "déc."
      ]
    },
});