/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.composer.querybuilder.util;

import com.genesyslab.composer.core.security.crypto.ComposerCryptoAES128Utils;
import com.genesyslab.composer.core.security.crypto.ComposerCryptoException;
import com.genesyslab.composer.core.security.crypto.IComposerDecrypt;
import com.genesyslab.composer.core.security.crypto.IComposerEncrypt;
import com.genesyslab.composer.core.security.crypto.IComposerKeyProvider;
import com.genesyslab.studio.querybuilder.model.CVDBConnProfile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class CVDBConnProfileBuilder {
    public static final String TYPE_SUFFIX = ".type";
    public static final String HOSTNAME_SUFFIX = ".hostname";
    public static final String PORT_SUFFIX = ".port";
    public static final String INSTANCE_SUFFIX = ".instance";
    public static final String DATABASENAME_SUFFIX = ".database";
    public static final String ISSID_SUFFIX = ".isSID";
    public static final String USERNAME_SUFFIX = ".username";
    public static final String PASSWORD_SUFFIX = ".password";
    public static final String PASSWORD_ENCRYPTED_SUFFIX = ".passwordEncrypt";
    public static final String POOLING_SUFFIX = ".isPooled";
    public static final String DATASOURCE_SUFFIX = ".dataSourceName";
    public static final String CUSTOMPARAMETERSJDBC_SUFFIX = ".customParametersJDBC";
    public static final String CUSTOMPARAMETERSOLEDB_SUFFIX = ".customParametersOLEDB";
    public static final String SECURITY_SUFFIX = ".encrypt";
    public static final String TRUSTCRT_SUFFIX = ".trustServerCertificate";
    public static final String MATCHCRTSUBJECT_SUFFIX = ".matchCertificateSubject";
    public static final String HOSTNAMEINCERTIFICATE_SUFFIX = ".hostnameInCertificate";
    public static final String TRUSTSTORE_SUFFIX = ".trustStoreLocation";
    public static final String TRUSTSTORETYPE_SUFFIX = ".trustStoreType";
    public static final String TRUSTSTOREPWD_SUFFIX = ".trustStorePassword";
    public static final String CUSTOM_OLEDB_CONNSTRING = ".customConnString";

    public static CVDBConnProfile readProfile(Properties properties, String string) throws Exception {
        return CVDBConnProfileBuilder.readProfile(properties, string, null, null);
    }

    public static CVDBConnProfile readProfile(Properties properties, String string, IComposerDecrypt iComposerDecrypt, IComposerKeyProvider iComposerKeyProvider) throws Exception {
        Object object;
        CVDBConnProfile cVDBConnProfile = new CVDBConnProfile();
        cVDBConnProfile.setName(string);
        String string2 = properties.getProperty(string + TYPE_SUFFIX);
        String string3 = properties.getProperty(string + HOSTNAME_SUFFIX);
        String string4 = properties.getProperty(string + PORT_SUFFIX);
        String string5 = properties.getProperty(string + INSTANCE_SUFFIX);
        String string6 = properties.getProperty(string + DATABASENAME_SUFFIX);
        String string7 = properties.getProperty(string + USERNAME_SUFFIX);
        String string8 = properties.getProperty(string + POOLING_SUFFIX);
        String string9 = properties.getProperty(string + DATASOURCE_SUFFIX);
        String string10 = properties.getProperty(string + ISSID_SUFFIX);
        String string11 = properties.getProperty(string + CUSTOMPARAMETERSJDBC_SUFFIX);
        String string12 = properties.getProperty(string + CUSTOMPARAMETERSOLEDB_SUFFIX);
        String string13 = properties.getProperty(string + SECURITY_SUFFIX);
        String string14 = properties.getProperty(string + TRUSTSTORE_SUFFIX);
        String string15 = properties.getProperty(string + TRUSTSTOREPWD_SUFFIX);
        String string16 = properties.getProperty(string + TRUSTSTORETYPE_SUFFIX);
        String string17 = properties.getProperty(string + TRUSTCRT_SUFFIX);
        String string18 = properties.getProperty(string + MATCHCRTSUBJECT_SUFFIX);
        String string19 = properties.getProperty(string + HOSTNAMEINCERTIFICATE_SUFFIX);
        String string20 = properties.getProperty(string + CUSTOM_OLEDB_CONNSTRING);
        boolean bl = Boolean.parseBoolean(string8);
        cVDBConnProfile.setPooled(bl);
        boolean bl2 = Boolean.parseBoolean(string10);
        cVDBConnProfile.setIsSID(bl2);
        boolean bl3 = Boolean.parseBoolean(string13);
        cVDBConnProfile.setSecured(bl3);
        boolean bl4 = Boolean.parseBoolean(string17);
        cVDBConnProfile.setTrustCer(bl4);
        boolean bl5 = Boolean.parseBoolean(string18);
        cVDBConnProfile.setMatchCrtSubject(bl5);
        if (bl && (string9 == null || string9.trim().length() == 0)) {
            throw new MissingPropertyException(string + DATASOURCE_SUFFIX);
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new MissingPropertyException(string + TYPE_SUFFIX);
        }
        if (string7 == null || string7.trim().length() == 0) {
            throw new MissingPropertyException(string + USERNAME_SUFFIX);
        }
        if (string3 == null || string3.trim().length() == 0) {
            throw new MissingPropertyException(string + HOSTNAME_SUFFIX);
        }
        if (string6 == null || string6.trim().length() == 0) {
            throw new MissingPropertyException(string + DATABASENAME_SUFFIX);
        }
        try {
            object = CVDBConnProfile.DatabaseType.valueOf(string2);
            cVDBConnProfile.setType((CVDBConnProfile.DatabaseType)((Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidDBTypeException(string + TYPE_SUFFIX + "=" + string2);
        }
        if (string4 == null || string4.trim().length() == 0) {
            cVDBConnProfile.setPort("");
        } else {
            try {
                Integer.parseInt(string4);
                cVDBConnProfile.setPort(string4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidPortException(string + PORT_SUFFIX + "=" + string4);
            }
        }
        cVDBConnProfile.setInstance(string5);
        cVDBConnProfile.setHostname(string3);
        cVDBConnProfile.setDatabase(string6);
        cVDBConnProfile.setUsername(string7);
        cVDBConnProfile.setDataSourceName(string9);
        cVDBConnProfile.setCustomParametersJDBC(string11);
        cVDBConnProfile.setCustomParametersOLEDB(string12);
        cVDBConnProfile.setSecured(bl3);
        cVDBConnProfile.setTrustStore(string14);
        cVDBConnProfile.setTrustStoreType(string16);
        cVDBConnProfile.setTrustStorePassword(string15);
        cVDBConnProfile.setHostNameInCrt(string19);
        cVDBConnProfile.setCustomOLEDBConnString(string20);
        object = properties.getProperty(string + PASSWORD_ENCRYPTED_SUFFIX);
        boolean bl6 = Boolean.parseBoolean((String)object);
        cVDBConnProfile.setPasswordEncrypted(bl6);
        String string21 = properties.getProperty(string + PASSWORD_SUFFIX);
        if (bl6 && string21 != null && iComposerDecrypt != null && iComposerKeyProvider != null) {
            string21 = ComposerCryptoAES128Utils.decodeWithIVAndDecrypt(string21, iComposerDecrypt, iComposerKeyProvider);
        }
        cVDBConnProfile.setPassword(string21);
        return cVDBConnProfile;
    }

    public static List<String> getAllConnProfilesNames(Properties properties) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : properties.keySet()) {
            String string = (String)object;
            int n = string.indexOf(46);
            String string2 = string.substring(0, n);
            hashSet.add(string2);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashSet);
        return arrayList;
    }

    public static Properties writeProfile(CVDBConnProfile cVDBConnProfile) throws ComposerCryptoException {
        return CVDBConnProfileBuilder.writeProfile(cVDBConnProfile, null, null);
    }

    public static Properties writeProfile(CVDBConnProfile cVDBConnProfile, IComposerEncrypt iComposerEncrypt, IComposerKeyProvider iComposerKeyProvider) throws ComposerCryptoException {
        String string = cVDBConnProfile.getName();
        Properties properties = new Properties();
        properties.setProperty(string + TYPE_SUFFIX, cVDBConnProfile.getType().toString());
        properties.setProperty(string + HOSTNAME_SUFFIX, cVDBConnProfile.getHostname());
        properties.setProperty(string + PORT_SUFFIX, cVDBConnProfile.getPort());
        properties.setProperty(string + INSTANCE_SUFFIX, cVDBConnProfile.getInstance());
        properties.setProperty(string + DATABASENAME_SUFFIX, cVDBConnProfile.getDatabase());
        properties.setProperty(string + USERNAME_SUFFIX, cVDBConnProfile.getUsername());
        properties.setProperty(string + POOLING_SUFFIX, Boolean.toString(cVDBConnProfile.isPooled()));
        properties.setProperty(string + DATASOURCE_SUFFIX, cVDBConnProfile.getDataSourceName());
        properties.setProperty(string + ISSID_SUFFIX, Boolean.toString(cVDBConnProfile.isSID()));
        properties.setProperty(string + CUSTOMPARAMETERSJDBC_SUFFIX, cVDBConnProfile.getCustomParametersJDBC());
        properties.setProperty(string + CUSTOMPARAMETERSOLEDB_SUFFIX, cVDBConnProfile.getCustomParametersOLEDB());
        properties.setProperty(string + SECURITY_SUFFIX, Boolean.toString(cVDBConnProfile.isSecured()));
        properties.setProperty(string + TRUSTSTORE_SUFFIX, cVDBConnProfile.getTrustStore());
        properties.setProperty(string + TRUSTSTOREPWD_SUFFIX, cVDBConnProfile.getTrustStorePassword());
        properties.setProperty(string + TRUSTSTORETYPE_SUFFIX, cVDBConnProfile.getTrustStoreType());
        properties.setProperty(string + TRUSTCRT_SUFFIX, Boolean.toString(cVDBConnProfile.isTrustCer()));
        properties.setProperty(string + MATCHCRTSUBJECT_SUFFIX, Boolean.toString(cVDBConnProfile.isMatchCrtSubject()));
        properties.setProperty(string + HOSTNAMEINCERTIFICATE_SUFFIX, cVDBConnProfile.getHostNameInCrt());
        properties.setProperty(string + CUSTOM_OLEDB_CONNSTRING, cVDBConnProfile.getCustomOLEDBConnString());
        boolean bl = cVDBConnProfile.isPasswordEncrypted();
        properties.setProperty(string + PASSWORD_ENCRYPTED_SUFFIX, Boolean.toString(bl));
        String string2 = cVDBConnProfile.getPassword();
        if (bl && iComposerEncrypt != null && iComposerKeyProvider != null) {
            string2 = ComposerCryptoAES128Utils.encryptAndEncodeWithIV(string2, iComposerEncrypt, iComposerKeyProvider);
        }
        properties.setProperty(string + PASSWORD_SUFFIX, string2);
        return properties;
    }

    public static class MissingPropertyException
    extends Exception {
        public MissingPropertyException(String string) {
            super(string);
        }
    }

    public static class InvalidPortException
    extends Exception {
        public InvalidPortException(String string) {
            super(string);
        }
    }

    public static class InvalidDBTypeException
    extends Exception {
        public InvalidDBTypeException(String string) {
            super(string);
        }
    }
}

