/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.studio.backendlogic;

import com.genesyslab.studio.backendlogic.BackendLogManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.log4j.Logger;

public class RecordCapturingBackendProcessor {
    private static final Logger logger = BackendLogManager.getLogger("recordCapture");
    public static final String SAVE_FILE_SUCCESS = "SaveFile:Success";
    private HttpServletRequest request;
    public String result = "SaveFile:Success";
    public String recFileName = "error";
    private String audioFormat = "";

    public RecordCapturingBackendProcessor(HttpServletRequest httpServletRequest) {
        logger.info((Object)"RecordCapturingBackendProcessor() constructor");
        logger.info((Object)("JSPPagerequest: " + httpServletRequest.toString()));
        this.request = httpServletRequest;
    }

    public void parseRequest() {
        logger.info((Object)"RecordCapturingBackendProcessor.parseRequest() in");
        boolean bl = ServletFileUpload.isMultipartContent((HttpServletRequest)this.request);
        if (bl) {
            ServletFileUpload servletFileUpload = new ServletFileUpload();
            try {
                FileItemIterator fileItemIterator = servletFileUpload.getItemIterator(this.request);
                String string = "";
                while (fileItemIterator.hasNext()) {
                    Object object;
                    FileItemStream fileItemStream = fileItemIterator.next();
                    String string2 = fileItemStream.getFieldName();
                    logger.info((Object)("name: " + string2));
                    InputStream inputStream = fileItemStream.openStream();
                    if (fileItemStream.isFormField()) {
                        if (string2.equals("captureLocation")) {
                            string = Streams.asString((InputStream)inputStream);
                            logger.info((Object)("path: " + string));
                        } else if (string2.equals("recFileName")) {
                            object = Streams.asString((InputStream)inputStream);
                            string = ((String)object).length() <= 0 ? string + this.getAutogenerateFileName() + this.getFileExt() : (((String)object).indexOf(".") != -1 ? string + (String)object : string + (String)object + this.getFileExt());
                            logger.info((Object)("path: " + string));
                        } else {
                            object = Streams.asString((InputStream)inputStream);
                            logger.info((Object)("redDest: " + (String)object));
                            this.audioFormat = ((String)object).substring(((String)object).lastIndexOf("."), ((String)object).length());
                            logger.info((Object)("audioFormat: " + this.audioFormat));
                        }
                    } else if (string.length() > 0) {
                        logger.info((Object)"Process the input stream");
                        object = new byte[4096];
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        int n = 0;
                        while ((n = inputStream.read((byte[])object, 0, 4096)) != -1) {
                            byteArrayOutputStream.write((byte[])object, 0, n);
                        }
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        byteArrayOutputStream.close();
                        this.recFileName = string;
                        this.saveFile(byArray, string);
                    } else {
                        logger.error((Object)"result = FAILURE");
                        this.result = "FAILURE";
                    }
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                logger.error((Object)("GVADS:Error in MultiPartHTTPRequestProcessor:" + exception.getMessage()));
                this.result = "FAILURE";
            }
        }
        logger.info((Object)"RecordCapturingBackendProcessor.parseRequest() out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(byte[] byArray, String string) {
        logger.info((Object)("RecordCapturingBackendProcessor.saveFile(path: '" + string + "') in"));
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists()) {
                file2.mkdirs();
            }
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
        }
        catch (Exception exception) {
            logger.error((Object)("GVADS:Error in MultiPartHTTPRequestProcessor:" + exception.getMessage()), (Throwable)exception);
            this.result = "FAILURE";
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    logger.warn((Object)"Failed to close file output stream", (Throwable)iOException);
                }
            }
        }
        logger.info((Object)"RecordCapturingBackendProcessor.saveFile() out");
    }

    String getAutogenerateFileName() {
        logger.info((Object)"RecordCapturingBackendProcessor.getAutogenerateFileName() in");
        String string = "";
        Random random = new Random();
        String string2 = "";
        DecimalFormat decimalFormat = new DecimalFormat("00");
        DecimalFormat decimalFormat2 = new DecimalFormat("0000");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        DecimalFormat decimalFormat3 = new DecimalFormat("0000000000");
        string2 = "recording-";
        string2 = string2 + decimalFormat2.format(calendar.get(1));
        string2 = string2 + "-";
        string2 = string2 + decimalFormat.format(calendar.get(2) + 1);
        string2 = string2 + "-";
        string2 = string2 + decimalFormat.format(calendar.get(5));
        string2 = string2 + "-";
        string2 = string2 + decimalFormat.format(calendar.get(11));
        string2 = string2 + "-";
        string2 = string2 + decimalFormat.format(calendar.get(12));
        string2 = string2 + "-";
        string2 = string2 + decimalFormat.format(calendar.get(13));
        string2 = string2 + "-";
        string = string2 = string2 + decimalFormat.format(calendar.get(14));
        string = string + "-";
        string = string + decimalFormat3.format(Math.abs(random.nextInt()));
        logger.info((Object)("fileName: " + string));
        logger.info((Object)"RecordCapturingBackendProcessor.getAutogenerateFileName() out");
        return string;
    }

    String getFileExt() {
        logger.info((Object)"RecordCapturingBackendProcessor.getFileExt() in");
        String string = ".vox";
        if (this.audioFormat.length() > 0) {
            string = this.audioFormat;
        }
        logger.info((Object)("fileExt: " + string));
        logger.info((Object)"RecordCapturingBackendProcessor.getFileExt() out");
        return string;
    }
}

