/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.studio.backendlogic;

import com.genesyslab.studio.backendlogic.BackendLogManager;
import com.genesyslab.studio.backendlogic.WebServiceSOAPRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebServiceBackendProcessor {
    private static final String SOAP = "SOAP";
    private static final String HTTP_POST_METHOD = "POST";
    private static final String HTTP_GET_METHOD = "GET";
    private static final Logger logger = BackendLogManager.getLogger("getWebService");
    private static final String UTF_8_ENCODING_TYPE = "UTF-8";
    private static final String HTTP_SOAP_ACTION_HEADER = "SoapAction";
    private static final String HTTP_CONNECTION_HEADER_VALUE_CLOSE = "Close";
    private static final String HTTP_CONNECTION_HEADER = "Connection";
    private static final String HTTP_DEF_CONTENT_TYPE_TEXT_XML = "text/xml;charset=UTF-8";
    private static final String HTTP_CONTENT_TYPE_HEADER = "Content-Type";
    private static final String HTTP_CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String HTTP_POST = "HTTPPOST";
    private static final String HTTP_GET = "HTTPGET";
    private static final String HTTP_AUTHEN_HEADER_PREFIX_BASIC = "Basic ";
    private static final String HTTP_AUTHORIZATION_HEADER = "Authorization";
    private static final String SOAP_SIGNATURE_WITH_HTTP_BASIC_AUTHENTICATION = "SOAPSignatureWithHTTPBasicAuthentication";
    private static final String HTTP_BASIC_AUTHENTICATION = "HTTPBasicAuthentication";
    private String uRL = "";
    private String methodName = "";
    private String parameters = "";
    private String protocol = "";
    private String authenAccess = "";
    private String userName = "";
    private String password = "";
    private String soapActionURI = "";
    private String targetNameSpace = "";
    private String keyStorePass;
    private String keyStoreFilePath;
    private String privateKeyPass;
    private String privateKeyAlias;
    private String certAlias;
    private String sigAlgorithm;
    private String timeout;
    private JSONObject namespacePrefixMap;
    private Map<String, String> ParameterMap = new LinkedHashMap<String, String>();
    private String jsonString;
    private String headerJsonString;
    private JSONArray jsonArray;
    private JSONObject jsonObj;
    private String nsJsonStr;
    private HttpURLConnection con = null;
    private URL url = null;
    private int responseCode = 0;
    private boolean isSOAPFault = false;
    private HttpServletRequest request;
    private WebServiceSOAPRequest wsSoapRequest = null;

    public WebServiceBackendProcessor(HttpServletRequest httpServletRequest) {
        logger.info((Object)"WebServiceBackendProcessor() constructor");
        logger.info((Object)("Pagerequest: " + httpServletRequest.toString()));
        this.request = httpServletRequest;
    }

    public void parseRequest() {
        logger.info((Object)"WebServiceBackendProcessor.parseRequest() in");
        try {
            BufferedReader bufferedReader = this.request.getReader();
            StringWriter stringWriter = new StringWriter();
            logger.info((Object)this.request.getContentType());
            char[] cArray = new char[256];
            while (true) {
                logger.info((Object)"READING BUFFER ENTRY");
                int n = bufferedReader.read(cArray);
                if (n == -1) break;
                stringWriter.write(cArray, 0, n);
                logger.info((Object)("READER BUFFER" + cArray.toString()));
            }
            String string = stringWriter.toString();
            logger.info((Object)("jsonStr = " + string));
            JSONObject jSONObject = new JSONObject(string);
            this.uRL = jSONObject.getString("WebUrl");
            this.protocol = jSONObject.getString("Protocol");
            this.authenAccess = jSONObject.getString("AuthenAccess");
            if (this.authenAccess.equals(HTTP_BASIC_AUTHENTICATION) || this.authenAccess.equals(SOAP_SIGNATURE_WITH_HTTP_BASIC_AUTHENTICATION)) {
                this.userName = jSONObject.optString("UserName");
                this.password = jSONObject.optString("Password");
            }
            if (this.protocol.equalsIgnoreCase(SOAP)) {
                this.keyStorePass = jSONObject.getString("KeyStorePass");
                this.keyStoreFilePath = jSONObject.getString("KeyStoreFilePath");
                this.privateKeyPass = jSONObject.getString("PrivateKeyPass");
                this.privateKeyAlias = jSONObject.getString("PrivateKeyAlias");
                this.certAlias = jSONObject.getString("CertAlias");
                this.sigAlgorithm = jSONObject.getString("SigAlgorithm");
                this.soapActionURI = jSONObject.getString("SOAPActionURI");
                this.targetNameSpace = jSONObject.getString("targetNameSpaceUri");
                this.timeout = jSONObject.optString("Timeout");
                this.nsJsonStr = jSONObject.getString("NameSpaceMap");
                this.namespacePrefixMap = new JSONObject(this.nsJsonStr);
            }
            this.methodName = jSONObject.getString("MethodName");
            String string2 = jSONObject.optString("Parameters");
            logger.info((Object)("Parameters passed in JSON string: " + string2));
            this.jsonString = string2.startsWith("(") ? string2.substring(1, string2.length() - 1) : string2;
            if (this.jsonString.length() > 0) {
                this.jsonArray = new JSONArray(this.jsonString);
                String string3 = null;
                String string4 = null;
                JSONObject jSONObject2 = null;
                for (int i = 0; i < this.jsonArray.length(); ++i) {
                    jSONObject2 = this.jsonArray.getJSONObject(i);
                    if (!this.parameters.equals("")) {
                        this.parameters = this.parameters + "&";
                    }
                    string3 = jSONObject2.getString("name");
                    string4 = jSONObject2.getString("value");
                    this.parameters = this.parameters + URLEncoder.encode(string3, UTF_8_ENCODING_TYPE) + "=" + URLEncoder.encode(string4, UTF_8_ENCODING_TYPE);
                    this.ParameterMap.put(string3, string4);
                }
                logger.info((Object)("parameters = " + this.parameters));
            }
            string2 = jSONObject.optString("CustomHeaders");
            logger.info((Object)("Parameters custom passed in JSON string: " + string2));
            this.headerJsonString = string2.startsWith("(") ? string2.substring(1, string2.length() - 1) : string2;
            logger.info((Object)("Headers passed in JSON Header string: " + this.headerJsonString));
        }
        catch (JSONException jSONException) {
            logger.error((Object)("parseRequest exception:JSONex: " + jSONException.getMessage()));
            logger.error((Object)BackendLogManager.printStackTrace((Exception)((Object)jSONException)));
        }
        catch (IOException iOException) {
            logger.error((Object)("parseRequest exception:IOex: " + iOException.getMessage()));
            logger.error((Object)BackendLogManager.printStackTrace(iOException));
        }
        catch (Exception exception) {
            logger.error((Object)("parseRequest exception:Common: " + exception.getMessage()));
            logger.error((Object)BackendLogManager.printStackTrace(exception));
        }
        logger.info((Object)"WebServiceBackendProcessor.parseRequest() out");
    }

    public URL formURI() {
        logger.info((Object)"WebServiceBackendProcessor.formURI() in");
        try {
            this.url = this.methodName.length() > 0 ? (this.protocol.equalsIgnoreCase(HTTP_GET) ? new URL(this.uRL + "/" + this.methodName + "?" + this.parameters) : (this.protocol.equalsIgnoreCase(HTTP_POST) ? new URL(this.uRL + "/" + this.methodName) : new URL(this.uRL))) : (this.protocol.equalsIgnoreCase(HTTP_GET) ? new URL(this.uRL + "?" + this.parameters) : new URL(this.uRL));
        }
        catch (Exception exception) {
            logger.info((Object)"WebServiceBackendProcessor.formURI() out null");
            return null;
        }
        logger.info((Object)("url: " + this.url.toString()));
        logger.info((Object)"WebServiceBackendProcessor.formURI() out");
        return this.url;
    }

    public void formHTTPMessage(String string, String string2) {
        block12: {
            logger.info((Object)"WebServiceBackendProcessor.formHTTPMessage() in");
            try {
                String string3;
                Object object;
                Object object2;
                this.con = (HttpURLConnection)this.url.openConnection();
                this.setTimeoutConfigurations(string, string2);
                if (this.authenAccess.equals(HTTP_BASIC_AUTHENTICATION) || this.authenAccess.equals(SOAP_SIGNATURE_WITH_HTTP_BASIC_AUTHENTICATION)) {
                    object2 = this.userName + ":" + this.password;
                    logger.info((Object)("encodedAuthenDetails: " + (String)object2));
                    object = ((String)object2).getBytes();
                    string3 = new String(Base64.encodeBase64((byte[])object));
                    this.con.setRequestProperty(HTTP_AUTHORIZATION_HEADER, HTTP_AUTHEN_HEADER_PREFIX_BASIC + string3);
                    logger.info((Object)("encodedString: " + string3));
                }
                if (this.protocol.equalsIgnoreCase(HTTP_GET)) {
                    this.con.setRequestMethod(HTTP_GET_METHOD);
                    break block12;
                }
                if (this.protocol.equalsIgnoreCase(HTTP_POST)) {
                    this.con.setRequestMethod(HTTP_POST_METHOD);
                    this.con.setDoOutput(true);
                    object2 = new PrintWriter(new OutputStreamWriter(this.con.getOutputStream()));
                    ((PrintWriter)object2).print(this.parameters);
                    ((PrintWriter)object2).close();
                    break block12;
                }
                logger.info((Object)("tns" + this.targetNameSpace + "method" + this.methodName + "Pmap" + this.ParameterMap + "authAcc" + this.authenAccess + "UserName" + this.userName + "Pwd" + this.password + "NsPrefix" + this.namespacePrefixMap));
                this.wsSoapRequest = new WebServiceSOAPRequest(this.targetNameSpace, this.methodName, this.ParameterMap, this.authenAccess, this.userName, this.password, this.namespacePrefixMap);
                object2 = this.wsSoapRequest.generateSOAPRequest(this.keyStorePass, this.keyStoreFilePath, this.privateKeyPass, this.privateKeyAlias, this.certAlias, this.sigAlgorithm);
                if (object2 == null) {
                    throw new Exception("SOAP message could not be created");
                }
                this.con.setRequestMethod(HTTP_POST_METHOD);
                this.con.setDoOutput(true);
                this.con.setRequestProperty(HTTP_CONTENT_LENGTH_HEADER, String.valueOf(((String)object2).length()));
                this.con.setRequestProperty(HTTP_CONTENT_TYPE_HEADER, HTTP_DEF_CONTENT_TYPE_TEXT_XML);
                this.con.setRequestProperty(HTTP_CONNECTION_HEADER, HTTP_CONNECTION_HEADER_VALUE_CLOSE);
                if (this.soapActionURI.isEmpty()) {
                    this.con.setRequestProperty(HTTP_SOAP_ACTION_HEADER, "\"\"");
                } else {
                    this.con.setRequestProperty(HTTP_SOAP_ACTION_HEADER, this.soapActionURI);
                }
                try {
                    if (this.headerJsonString != null && this.headerJsonString.length() > 0) {
                        this.jsonObj = new JSONObject(this.headerJsonString);
                        object = this.jsonObj.keys();
                        while (object.hasNext()) {
                            string3 = (String)object.next();
                            String string4 = this.jsonObj.getString(string3);
                            logger.info((Object)("Custom:" + string3 + string4));
                            this.con.setRequestProperty(string3, string4);
                        }
                    }
                }
                catch (JSONException jSONException) {
                    logger.error((Object)("Custom Header exception: " + jSONException.getMessage()));
                    logger.error((Object)BackendLogManager.printStackTrace((Exception)((Object)jSONException)));
                }
                object = new PrintWriter(new OutputStreamWriter(this.con.getOutputStream()));
                ((PrintWriter)object).print((String)object2);
                logger.info((Object)("soapMessage: " + (String)object2));
                ((PrintWriter)object).close();
            }
            catch (Exception exception) {
                logger.error((Object)BackendLogManager.printStackTrace(exception));
                logger.error((Object)"Error in Form HTTP Message.");
            }
        }
        logger.info((Object)"WebServiceBackendProcessor.formHTTPMessage() out");
    }

    private void setTimeoutConfigurations(String string, String string2) {
        logger.info((Object)"WebServiceBackendProcessor.setTimeoutConfigurations() in");
        try {
            if (this.timeout != null && this.timeout.trim().length() > 0) {
                try {
                    int n = Integer.parseInt(this.timeout);
                    if (n != -1) {
                        string = Integer.toString(n * 1000);
                        string2 = Integer.toString(n * 1000);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.con.setConnectTimeout(Integer.valueOf(string));
            this.con.setReadTimeout(Integer.valueOf(string2));
        }
        catch (Exception exception) {
            logger.error((Object)"Error in setTimeoutConfigurations.");
            logger.error((Object)BackendLogManager.printStackTrace(exception));
        }
        logger.info((Object)"WebServiceBackendProcessor.setTimeoutConfigurations() out");
    }

    public void connectToURL() {
        logger.info((Object)"WebServiceBackendProcessor.connectToURL() in");
        try {
            this.con.connect();
            this.responseCode = this.con.getResponseCode();
        }
        catch (Exception exception) {
            this.responseCode = 500;
            logger.error((Object)("connectToURL exception: " + exception.getMessage()));
        }
        logger.info((Object)"WebServiceBackendProcessor.connectToURL() out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readWebServiceresponse() {
        logger.info((Object)"WebServiceBackendProcessor.readWebServiceresponse() in");
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            if (this.responseCode == 200) {
                logger.info((Object)"readWebServiceresponse OK");
                bufferedReader = new BufferedReader(new InputStreamReader(this.con.getInputStream(), "utf-8"));
            } else {
                this.isSOAPFault = true;
                logger.error((Object)("readWebServiceresponse NOT OK: " + this.responseCode + ":" + this.con.getResponseMessage()));
                bufferedReader = new BufferedReader(new InputStreamReader(this.con.getErrorStream(), "utf-8"));
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + "\n");
            }
            try {
                String string3 = stringBuffer.toString();
                string3 = string3.replaceAll("+", "#+#");
                string = URLDecoder.decode(string3, UTF_8_ENCODING_TYPE);
                string = string.replaceAll("#+#", "+");
                logger.info((Object)("postData: " + string));
            }
            catch (Exception exception) {
                logger.error((Object)BackendLogManager.printStackTrace(exception));
                string = stringBuffer.toString();
            }
        }
        catch (Exception exception) {
            logger.error((Object)("readWebServiceresponse exception:" + exception.getMessage()));
            string = null;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.warn((Object)"Failed to close reader", (Throwable)iOException);
                }
            }
        }
        logger.info((Object)"WebServiceBackendProcessor.readWebServiceresponse() in");
        return string;
    }

    public String processSOAPMessage(String string) {
        logger.info((Object)"WebServiceBackendProcessor.processSOAPMessage() in");
        logger.info((Object)("value: " + string));
        String string2 = string;
        if (this.wsSoapRequest != null) {
            string2 = this.wsSoapRequest.processSOAPMessage(string);
        }
        logger.info((Object)("data: " + string2));
        logger.info((Object)"WebServiceBackendProcessor.processSOAPMessage() out");
        return string2;
    }

    public String replaceXMLChars(String string) {
        logger.info((Object)"WebServiceBackendProcessor.replaceXMLChars() in");
        logger.info((Object)("value: " + string));
        String string2 = string;
        string2 = string2.replace(">", "&gt;");
        string2 = string2.replace("<", "&lt;");
        string2 = string2.replace("&", "&amp;");
        string2 = string2.replace("\"", "&quot;");
        logger.info((Object)("data: " + string2));
        logger.info((Object)"WebServiceBackendProcessor.replaceXMLChars() out");
        return string2;
    }

    public String formReturnTag(String string) {
        logger.info((Object)"WebServiceBackendProcessor.formReturnTag() in");
        logger.info((Object)("value: " + string));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<var name='result' expr=\"value\"/>");
        stringBuffer.append("<block>");
        stringBuffer.append("<return namelist='result'/>");
        stringBuffer.append("</block></form>");
        stringBuffer.append("</vxml>");
        logger.info((Object)("returnData: " + stringBuffer.toString()));
        logger.info((Object)"WebServiceBackendProcessor.formReturnTag() out");
        return stringBuffer.toString();
    }

    public void disconnectConnection() {
        logger.info((Object)"WebServiceBackendProcessor.disconnectConnection() in");
        if (this.con != null) {
            this.con.disconnect();
        }
        logger.info((Object)"WebServiceBackendProcessor.disconnectConnection() out");
    }

    public String raiseVXMLException(String string, String string2) {
        logger.info((Object)"WebServiceBackendProcessor.raiseVXMLException() in");
        logger.info((Object)("exception: " + string + ", message: " + string2));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("''");
        stringBuffer.append("\"/>");
        stringBuffer.append("<block>");
        stringBuffer.append("<return event='");
        stringBuffer.append(string);
        stringBuffer.append("'");
        stringBuffer.append(" message='");
        stringBuffer.append(string2);
        stringBuffer.append("'");
        stringBuffer.append("/>");
        stringBuffer.append("</block></form>");
        stringBuffer.append("</vxml>");
        logger.info((Object)("sb: " + stringBuffer.toString()));
        logger.info((Object)"WebServiceBackendProcessor.raiseVXMLException() out");
        return stringBuffer.toString();
    }

    public boolean isSOAPFault() {
        logger.info((Object)("WebServiceBackendProcessor.isSOAPFault(): " + this.isSOAPFault));
        return this.isSOAPFault;
    }
}

