/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.studio.backendlogic;

import com.genesyslab.studio.backendlogic.BackendLogManager;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.KeyStore;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.log4j.Logger;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.Merlin;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WebServiceSOAPRequest {
    private static final Logger logger = BackendLogManager.getLogger("getWebService");
    private static final String SOAP_MESSAGE_LEVEL_BASIC_AUTHENTICATION = "SOAPMessageLevelBasicAuthentication";
    private static final String SOAP_SIGNATURE_WITH_HTTP_BASIC_AUTHENTICATION = "SOAPSignatureWithHTTPBasicAuthentication";
    private static final String SOAP_DIGITAL_SIGNATURE_AUTHENTICATION = "SOAPDigitalSignatureAuthentication";
    private static final String SIG_ALGORITHM_DSA = "DSA";
    private static final String JKS_KESSTORE_TYPE = "JKS";
    private static final String MUST_UNDERSTAND_ATTR_VALUE = "1";
    private static final String MUST_UNDERSTAND_ATTR = "mustUnderstand";
    private static final String BASIC_AUTH_PASSWORD_TAG = "Password";
    private static final String BASIC_AUTH_NAME_TAG = "Name";
    private static final String HTTP_SOAP_AUTHENTICATION_ORG_BASIC_NS = "http://soap-authentication.org/basic/2001/10/";
    private static final String BASIC_AUTH_HEADER_PREFIX = "h";
    private static final String BASIC_AUTH_HEADER = "BasicAuth";
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private String methodName = "";
    private String targetNameSpaceUri = "";
    private String authenAccess = "";
    private String userName = "";
    private String password = "";
    private JSONObject namespacePrefixMap;

    public WebServiceSOAPRequest(String string, String string2, Map<String, String> map, String string3, String string4, String string5, JSONObject jSONObject) {
        logger.info((Object)"WebServiceSOAPRequest() constructor");
        this.parameters = map;
        this.methodName = string2;
        this.targetNameSpaceUri = string;
        this.authenAccess = string3;
        this.userName = string4;
        this.password = string5;
        this.namespacePrefixMap = jSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateSOAPRequest(String string, String string2, String string3, String string4, String string5, String string6) {
        SOAPEnvelope sOAPEnvelope;
        logger.info((Object)"WebServiceSOAPRequest.generateSOAPRequest() in");
        SOAPMessage sOAPMessage = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            Object object;
            Object object2;
            String string7;
            Name name;
            sOAPMessage = MessageFactory.newInstance().createMessage();
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            sOAPEnvelope = sOAPPart.getEnvelope();
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            try {
                name = sOAPEnvelope.createName(this.methodName, "", this.namespacePrefixMap.getString(this.methodName));
            }
            catch (JSONException jSONException) {
                name = sOAPEnvelope.createName(this.methodName);
            }
            SOAPBodyElement sOAPBodyElement = sOAPBody.addBodyElement(name);
            Set<String> set = this.parameters.keySet();
            Iterator iterator = set.iterator();
            String string8 = "";
            Object object3 = null;
            logger.info((Object)"Constructing params");
            while (iterator.hasNext()) {
                Object object4;
                String string9;
                String string10;
                String string11;
                StringTokenizer stringTokenizer;
                StringTokenizer stringTokenizer2;
                string7 = (String)iterator.next();
                object2 = this.parameters.get(string7);
                StringTokenizer stringTokenizer3 = new StringTokenizer(string7, ":");
                logger.info((Object)("KEY:" + string7 + "_" + (String)object2));
                if (stringTokenizer3.countTokens() == 2) {
                    String string12;
                    String string13 = stringTokenizer3.nextToken();
                    try {
                        string12 = this.namespacePrefixMap.getString(string13);
                    }
                    catch (JSONException jSONException) {
                        string12 = null;
                    }
                    logger.info((Object)("prefix:" + string13 + "_" + string12));
                    object = stringTokenizer3.nextToken();
                    stringTokenizer2 = new StringTokenizer(string8, ".");
                    stringTokenizer = new StringTokenizer((String)object, ".");
                    string11 = null;
                    if (stringTokenizer.hasMoreTokens()) {
                        string10 = stringTokenizer.nextToken();
                        string9 = "";
                        if (stringTokenizer2.hasMoreTokens()) {
                            string9 = stringTokenizer2.nextToken();
                        }
                        if (object3 != null && object3.getTagName().equals(string10)) {
                            string11 = object3;
                            while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
                                object4 = stringTokenizer.nextToken();
                                if (((String)object4).equals(stringTokenizer2.nextToken())) {
                                    Iterator iterator2 = string11.getChildElements();
                                    while (iterator2.hasNext() && !(string11 = (SOAPElement)iterator2.next()).getTagName().equals(object4)) {
                                    }
                                    continue;
                                }
                                string11 = string11.addChildElement((String)object4);
                            }
                        } else {
                            string11 = string12 != null ? sOAPBodyElement.addChildElement(string10, "", string12) : sOAPBodyElement.addChildElement(string10);
                            object3 = string11;
                        }
                        while (stringTokenizer.hasMoreTokens()) {
                            string11 = string11.addChildElement(stringTokenizer.nextToken());
                        }
                    } else {
                        string11 = string12 != null ? sOAPBodyElement.addChildElement((String)object, "", string12) : sOAPBodyElement.addChildElement((String)object);
                    }
                    string11.addTextNode((String)object2);
                    string8 = object;
                    continue;
                }
                object = null;
                stringTokenizer2 = new StringTokenizer(string7, ".");
                stringTokenizer = new StringTokenizer(string8, ".");
                if (stringTokenizer2.hasMoreTokens()) {
                    string11 = stringTokenizer2.nextToken();
                    string10 = "";
                    if (stringTokenizer.hasMoreTokens()) {
                        string10 = stringTokenizer.nextToken();
                    }
                    if (object3 != null && object3.getTagName().equals(string11)) {
                        object = object3;
                        while (stringTokenizer2.hasMoreTokens() && stringTokenizer.hasMoreTokens()) {
                            string9 = stringTokenizer2.nextToken();
                            if (string9.equals(stringTokenizer.nextToken())) {
                                object4 = object.getChildElements();
                                while (object4.hasNext() && !(object = (SOAPElement)object4.next()).getTagName().equals(string9)) {
                                }
                                continue;
                            }
                            object = object.addChildElement(string9);
                        }
                    } else {
                        object3 = object = sOAPBodyElement.addChildElement(string11);
                    }
                    while (stringTokenizer2.hasMoreTokens()) {
                        object = object.addChildElement(stringTokenizer2.nextToken());
                    }
                } else {
                    object = sOAPBodyElement.addChildElement(string7);
                }
                object.addTextNode((String)object2);
                string8 = string7;
            }
            if (this.authenAccess.equals(SOAP_MESSAGE_LEVEL_BASIC_AUTHENTICATION)) {
                string7 = sOAPHeader.addHeaderElement(sOAPEnvelope.createName(BASIC_AUTH_HEADER, BASIC_AUTH_HEADER_PREFIX, HTTP_SOAP_AUTHENTICATION_ORG_BASIC_NS));
                object2 = sOAPEnvelope.createName(MUST_UNDERSTAND_ATTR);
                string7.addAttribute((Name)object2, MUST_UNDERSTAND_ATTR_VALUE);
                object = string7.addChildElement(BASIC_AUTH_NAME_TAG);
                object.addTextNode(this.userName);
                object = string7.addChildElement(BASIC_AUTH_PASSWORD_TAG);
                object.addTextNode(this.password);
            } else if (this.authenAccess.equals(SOAP_DIGITAL_SIGNATURE_AUTHENTICATION) || this.authenAccess.equals(SOAP_SIGNATURE_WITH_HTTP_BASIC_AUTHENTICATION)) {
                string7 = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
                string7 = string6.equals(SIG_ALGORITHM_DSA) ? "http://www.w3.org/2000/09/xmldsig#dsa-sha1" : "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                object2 = KeyStore.getInstance(JKS_KESSTORE_TYPE);
                fileInputStream = new FileInputStream(string2);
                ((KeyStore)object2).load(fileInputStream, string.toCharArray());
                sOAPMessage = WebServiceSOAPRequest.signSOAPEnvelope(sOAPEnvelope, (KeyStore)object2, string4, string3, string7);
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (sOAPMessage == null) {
                logger.error((Object)("\nGenerated SOAP ERROR: " + byteArrayOutputStream.toString() + "\n"));
                string7 = null;
                return string7;
            }
            sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
            logger.info((Object)("\nGenerated SOAP: " + byteArrayOutputStream.toString() + "\n"));
            logger.info((Object)"Soap Message Generation: SUCCESS");
            string7 = byteArrayOutputStream.toString();
            return string7;
        }
        catch (Exception exception) {
            logger.error((Object)"Error in Generating Soap Message: generateSOAPRequest()");
            logger.error((Object)BackendLogManager.printStackTrace(exception));
            sOAPEnvelope = null;
            return sOAPEnvelope;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.error((Object)"Error in Generating Soap Message: generateSOAPRequest()");
                logger.error((Object)BackendLogManager.printStackTrace(iOException));
            }
            logger.info((Object)"WebServiceSOAPRequest.generateSOAPRequest() out");
        }
    }

    public String processSOAPMessage(String string) {
        logger.info((Object)"WebServiceSOAPRequest.processSOAPMessage()");
        logger.info((Object)("message: " + string));
        return this.getSoapMessage(string);
    }

    public String getSoapMessage(String string) {
        logger.info((Object)"Entered getSoapMessage()");
        String string2 = "";
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage sOAPMessage = messageFactory.createMessage();
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string.toString())));
            DOMSource dOMSource = new DOMSource(document);
            sOAPPart.setContent((Source)dOMSource);
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            if (sOAPBody.hasFault()) {
                logger.info((Object)("getSoapMessage: SOAP fault response received: " + sOAPBody.toString()));
            }
            Iterator iterator = sOAPBody.getChildElements();
            block7: while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                WebServiceSOAPRequest.removePrefix(node);
                OutputFormat outputFormat = new OutputFormat();
                StringWriter stringWriter = new StringWriter();
                XMLSerializer xMLSerializer = new XMLSerializer(stringWriter, outputFormat);
                switch (node.getNodeType()) {
                    case 9: {
                        xMLSerializer.serialize((Document)node);
                        break;
                    }
                    case 1: {
                        xMLSerializer.serialize((Element)node);
                        break;
                    }
                    case 11: {
                        xMLSerializer.serialize((DocumentFragment)node);
                        break;
                    }
                    default: {
                        logger.info((Object)("Node type is neither doc, element nor doc fragment, skipping the serialization: " + node.toString()));
                        continue block7;
                    }
                }
                string2 = stringWriter.toString();
            }
            logger.info((Object)"Exit getSoapMessage()");
            return string2;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public static SOAPMessage signSOAPEnvelope(SOAPEnvelope sOAPEnvelope, KeyStore keyStore, String string, String string2, String string3) throws Exception {
        logger.info((Object)"Entered signSOAPEnvelope()\n");
        WSSecSignature wSSecSignature = new WSSecSignature();
        wSSecSignature.setUserInfo(string, string2);
        wSSecSignature.setKeyIdentifierType(3);
        wSSecSignature.setSignatureAlgorithm(string3);
        Document document = sOAPEnvelope.getOwnerDocument();
        Merlin merlin = new Merlin();
        merlin.setKeyStore(keyStore);
        WSSecHeader wSSecHeader = new WSSecHeader();
        wSSecHeader.insertSecurityHeader(document);
        Document document2 = wSSecSignature.build(document, (Crypto)merlin, wSSecHeader);
        DOMSource dOMSource = new DOMSource(document2);
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage sOAPMessage = messageFactory.createMessage();
        sOAPMessage.getSOAPPart().setContent((Source)dOMSource);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
        logger.info((Object)"\n Exit signSOAPEnvelope() \n");
        return sOAPMessage;
    }

    private static void removePrefix(Node node) {
        logger.info((Object)"WebServiceSOAPRequest.removePrefix() in");
        if (node.getPrefix() != null) {
            node.setPrefix(null);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getPrefix() != null) {
                node2.setPrefix(null);
            }
            if (!node2.hasChildNodes()) continue;
            WebServiceSOAPRequest.removePrefix(node2);
        }
        logger.info((Object)"WebServiceSOAPRequest.removePrefix() out");
    }
}

