/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.studio.backendlogic.security.crypto;

import com.genesyslab.composer.core.security.crypto.ComposerCryptoException;
import com.genesyslab.composer.core.security.crypto.IComposerKeyProvider;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public class ComposerBackendKeyProvider
implements IComposerKeyProvider {
    private ServletContext servletContext;
    private Logger logger;

    public ComposerBackendKeyProvider(ServletContext servletContext, Logger logger) {
        this.servletContext = servletContext;
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getKey() throws ComposerCryptoException {
        String string;
        Object object;
        Throwable throwable;
        Closeable closeable;
        String string2 = this.servletContext.getRealPath("/WEB-INF/composer.properties");
        try {
            closeable = new FileInputStream(string2);
            throwable = null;
            try {
                object = new Properties();
                ((Properties)object).load((InputStream)closeable);
                string = ((Properties)object).getProperty("composerEncryptionKey");
                if (string == null) {
                    throw new ComposerCryptoException("Encryption key file not specified in composer.properties");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (closeable != null) {
                    if (throwable != null) {
                        try {
                            ((FileInputStream)closeable).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((FileInputStream)closeable).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.logger.error((Object)"Exception while reading composer.properties", (Throwable)iOException);
            throw new ComposerCryptoException("Failed to read composer.properties", iOException);
        }
        try {
            closeable = new BufferedReader(new FileReader(string));
            throwable = null;
            try {
                byte[] byArray;
                while ((object = ((BufferedReader)closeable).readLine()) != null && (((String)object).trim().startsWith("#") || ((String)object).trim().length() <= 0)) {
                }
                if (object == null) throw new ComposerCryptoException("Key should be 32 hex digits long");
                if (((String)object).trim().length() != 32) {
                    throw new ComposerCryptoException("Key should be 32 hex digits long");
                }
                byte[] byArray2 = byArray = Hex.decodeHex((char[])((String)object).trim().toCharArray());
                return byArray2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (closeable != null) {
                    if (throwable != null) {
                        try {
                            ((BufferedReader)closeable).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((BufferedReader)closeable).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.logger.error((Object)"Failed to read keyfile", (Throwable)iOException);
            throw new ComposerCryptoException("Failed to read keyfile at " + string, iOException);
        }
        catch (DecoderException decoderException) {
            this.logger.error((Object)"Failed to decode keyfile", (Throwable)decoderException);
            throw new ComposerCryptoException("Key was not hex encoded", decoderException);
        }
    }
}

