/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.studio.querybuilder.model;

import java.util.HashMap;
import java.util.Map;

public class CVDBConnProfile {
    private static final String ORACLE_PROTOCOL_UNSECURED = "tcp";
    private static final String ORACLE_PROTOCOL_SECURED = "tcps";
    private String name;
    private boolean isPooled;
    private boolean isSecured;
    private boolean trustCer;
    private boolean isSID;
    private String dataSourceName;
    private DatabaseType type;
    private String username;
    private String password;
    private boolean passwordEncrypted;
    private String hostname;
    private String port;
    private String instance;
    private String database;
    private String customParametersJDBC;
    private String customParametersOLEDB;
    private boolean matchCrtSubject;
    private String hostNameInCrt;
    private String trustStore;
    private String trustStoreType;
    private String trustStorePassword;
    private String customOLEDBConnString;

    public DatabaseType getType() {
        return this.type;
    }

    public void setType(DatabaseType databaseType) {
        this.type = databaseType;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String string) {
        this.instance = string;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String string) {
        this.database = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isPasswordEncrypted() {
        return this.passwordEncrypted;
    }

    public void setPasswordEncrypted(boolean bl) {
        this.passwordEncrypted = bl;
    }

    public String getJDBCURL() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case MSSQL: {
                stringBuffer.append("jdbc:sqlserver://");
                stringBuffer.append(this.hostname);
                if (this.port != null && this.port.length() > 0) {
                    stringBuffer.append(":").append(this.port);
                }
                if ((this.port == null || this.port.length() <= 0) && this.instance != null && this.instance.length() > 0) {
                    stringBuffer.append("\\").append(this.instance);
                }
                stringBuffer.append(";databaseName=").append(this.database);
                if (this.isSecured) {
                    stringBuffer.append(";encrypt=").append("true");
                    if (this.trustCer) {
                        stringBuffer.append(";trustServerCertificate=").append("true");
                    } else {
                        if (this.isMatchCrtSubject() && this.hostNameInCrt != null && this.hostNameInCrt.length() > 0) {
                            stringBuffer.append(";hostNameInCertificate=").append(this.hostNameInCrt);
                        }
                        if (this.trustStore != null && this.trustStore.length() > 0) {
                            stringBuffer.append(";trustStore=").append(this.trustStore);
                        }
                        if (this.trustStorePassword != null && this.trustStorePassword.length() > 0) {
                            stringBuffer.append(";trustStorePassword=").append(this.trustStorePassword);
                        }
                    }
                }
                if (this.customParametersJDBC == null) break;
                stringBuffer.append(";" + this.customParametersJDBC);
                break;
            }
            case ORACLE: {
                stringBuffer.append("jdbc:oracle:thin:@");
                stringBuffer.append("(DESCRIPTION=");
                stringBuffer.append("(ADDRESS=");
                stringBuffer.append("(PROTOCOL=");
                if (this.isSecured) {
                    stringBuffer.append(ORACLE_PROTOCOL_SECURED).append(")");
                } else {
                    stringBuffer.append(ORACLE_PROTOCOL_UNSECURED).append(")");
                }
                stringBuffer.append("(HOST=").append(this.hostname);
                stringBuffer.append(")");
                stringBuffer.append("(PORT=").append(this.port);
                stringBuffer.append(")");
                stringBuffer.append(")");
                if (!this.isSID) {
                    stringBuffer.append("(CONNECT_DATA=");
                    stringBuffer.append("(SERVICE_NAME=").append(this.database);
                    stringBuffer.append(")");
                    stringBuffer.append(")");
                } else {
                    stringBuffer.append("(CONNECT_DATA=");
                    stringBuffer.append("(SID=").append(this.database);
                    stringBuffer.append(")");
                    stringBuffer.append(")");
                }
                if (this.matchCrtSubject && this.hostNameInCrt != null && this.hostNameInCrt.trim().length() > 0) {
                    stringBuffer.append("(SECURITY=");
                    stringBuffer.append("(SSL_SERVER_CERT_DN=\"");
                    stringBuffer.append(this.hostNameInCrt).append("\"");
                    stringBuffer.append(")");
                    stringBuffer.append(")");
                }
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    public void setCustomParametersJDBC(String string) {
        this.customParametersJDBC = string;
    }

    public void setCustomParametersOLEDB(String string) {
        this.customParametersOLEDB = string;
    }

    public void setCustomParametersJDBCMap(HashMap<String, String> hashMap) {
        this.customParametersJDBC = this.mapToStr(hashMap);
    }

    public void setCustomParametersOLEDBMap(HashMap<String, String> hashMap) {
        this.customParametersOLEDB = this.mapToStr(hashMap);
    }

    public String getCustomParametersJDBC() {
        return this.customParametersJDBC;
    }

    public String getCustomParametersOLEDB() {
        return this.customParametersOLEDB;
    }

    public Map<String, String> getCustomParametersOLEDBMap() {
        return this.strToMap(this.customParametersOLEDB);
    }

    public Map<String, String> getCustomParametersJDBCMap() {
        return this.strToMap(this.customParametersJDBC);
    }

    private String mapToStr(HashMap<String, String> hashMap) {
        StringBuffer stringBuffer = new StringBuffer();
        if (hashMap == null || hashMap.isEmpty()) {
            return "";
        }
        for (String string : hashMap.keySet()) {
            stringBuffer.append(string).append("=").append(hashMap.get(string)).append(";");
        }
        return stringBuffer.toString();
    }

    private Map<String, String> strToMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(";")) {
                String[] stringArray2 = string2.split("=");
                if (stringArray2.length < 2) continue;
                hashMap.put(stringArray2[0], stringArray2[1]);
            }
        }
        return hashMap;
    }

    public String getDriverClass() {
        switch (this.type) {
            case MSSQL: {
                return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            }
            case ORACLE: {
                return "oracle.jdbc.driver.OracleDriver";
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isPooled() {
        return this.isPooled;
    }

    public void setPooled(boolean bl) {
        this.isPooled = bl;
    }

    public boolean isSID() {
        return this.isSID;
    }

    public void setIsSID(boolean bl) {
        this.isSID = bl;
    }

    public boolean isSecured() {
        return this.isSecured;
    }

    public void setSecured(boolean bl) {
        this.isSecured = bl;
    }

    public boolean isTrustCer() {
        return this.trustCer;
    }

    public void setTrustCer(boolean bl) {
        this.trustCer = bl;
    }

    public boolean isMatchCrtSubject() {
        return this.matchCrtSubject;
    }

    public void setMatchCrtSubject(boolean bl) {
        this.matchCrtSubject = bl;
    }

    public String getHostNameInCrt() {
        return this.hostNameInCrt;
    }

    public void setHostNameInCrt(String string) {
        this.hostNameInCrt = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String string) {
        this.trustStore = string;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String string) {
        this.trustStoreType = string;
    }

    public void setTrustStorePassword(String string) {
        this.trustStorePassword = string;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getCustomOLEDBConnString() {
        return this.customOLEDBConnString;
    }

    public void setCustomOLEDBConnString(String string) {
        this.customOLEDBConnString = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getJDBCURL()).append(System.getProperty("line.separator"));
        String string = this.getPassword() == null ? "****" : this.getPassword().replaceAll(".", "*");
        stringBuffer.append(this.getUsername()).append('/').append(string);
        switch (this.type) {
            case ORACLE: {
                stringBuffer.append(System.getProperty("line.separator"));
                if (this.isSecured) {
                    stringBuffer.append("javax.net.ssl.trustStore=").append(this.trustStore);
                    stringBuffer.append(System.getProperty("line.separator"));
                    stringBuffer.append("javax.net.ssl.trustStoreType=").append(this.trustStoreType);
                    stringBuffer.append(System.getProperty("line.separator"));
                    stringBuffer.append("javax.net.ssl.trustStorePassword=").append(this.getTrustStorePassword().replaceAll(".", "*"));
                    stringBuffer.append(System.getProperty("line.separator"));
                }
                stringBuffer.append(this.getCustomParametersJDBC());
                return stringBuffer.toString();
            }
        }
        return stringBuffer.toString();
    }

    public static enum DatabaseType {
        MSSQL(1433),
        ORACLE(1521);

        private final int defaultPort;

        private DatabaseType(int n2) {
            this.defaultPort = n2;
        }

        public int getDefaultPort() {
            return this.defaultPort;
        }
    }
}

