    var coords;
	var gmsInterface = new Object();
	var gmsNotificationClient = new Object();
	gmsNotificationClient.cometConnected = false;
	var cometdConnectListener = null;
	var cometdDisconnectListener = null;
	var cometdGenesysSubscription = null;
	
    $(function() {
		$.support.cors = true;

		try {
			navigator.geolocation.getCurrentPosition(
				function(d) { 
					coords = d.coords.latitude + ',' + d.coords.longitude;    
				}, 
				function() { 
					//window.console && console.log('error getting coords'); 
				},
				{maximumAge:600000}
			);
		} catch (e) {
			coords = "n/a";
		}
		gmsInterface.createCallback = function (scenario, gms_service_uri, params, headers, responseProcessorFn) {
			if (gmsNotificationClient.cometConnected) {
				params._device_os = "comet";
			}
			if (scenario == "VOICE-NOW-USERORIG") {	
				params._call_direction = "USERORIGINATED";
				params._wait_for_agent = "false";
				params._wait_for_user_confirm = "false";
				params._media_type = "voice";
			} else if (scenario =="VOICE-WAIT-USERORIG") {
				params._call_direction = "USERORIGINATED";
				params._wait_for_agent = "true";
				params._wait_for_user_confirm = "true";
				params._media_type = "voice";
			} else if (scenario =="VOICE-NOW-USERTERM") {
				params._call_direction = "USERTERMINATED";
				params._wait_for_agent = "false";
				params._wait_for_user_confirm = "false";
				params._media_type = "voice";
			} else if (scenario =="VOICE-WAIT-USERTERM") {
				params._call_direction = "USERTERMINATED";
				params._wait_for_agent = "true";
				params._wait_for_user_confirm = "true";
				params._media_type = "voice";
			} else if (scenario =="CHAT-NOW") {
				params._wait_for_agent = "false";
				params._wait_for_user_confirm = "false";
				params._media_type = "chat";
			} else if (scenario =="CHAT-WAIT") {
				params._wait_for_agent = "true";
				params._wait_for_user_confirm = "true";
				params._media_type = "chat";
			} else { // CUSTOM
			}

			gmsInterface.postHttp (gms_service_uri, params, headers, responseProcessorFn);
		}

		gmsInterface.getDialog = function (gms_service_specific_url, dialogName, responseProcessorFn) {
			gmsInterface.getHttp (gms_service_specific_url + dialogName, responseProcessorFn);
		}
		
		gmsInterface.getHttp = function (requestUrl, responseProcessorFn) {
			var currentRequest = {
				url: requestUrl,
				cache: false,
				dataType: "json",
				type: 'GET',
				crossDomain: true,
				success: function (data) {
					responseProcessorFn (data);
				},
				async: false
			};
			$.ajax(currentRequest);
		}
		
		gmsInterface.postHttp = function (requestUrl, params, headers, responseProcessorFn) {
			/* fails in IE<10
			var data = new FormData();
			jQuery.each(params, function(name, value) {
				if (value != "UNDEFINED") {
					data.append(name, value);
				}
			});
			*/
            var boundary = 'AaB03x';
            var data = '';
			jQuery.each(params, function(name, value) {
				if (value != "UNDEFINED") {
					data += '--' + boundary + '\r\nContent-Disposition: form-data; name="' + name + '"\r\n\r\n' + value + "\r\n";
				}
			});
			
			if (data != '') {
				data += '--' + boundary;
			}


			var currentRequest = {
				url: requestUrl,
				data: data,
				cache: false,
				dataType: "json",
                contentType:'multipart/form-data;boundary=' + boundary + ';charset=UTF-8',
				processData: false,
				type: 'POST',
				crossDomain: true,
				success: function (data) {
					responseProcessorFn (data);
				},
				error: function (data) {
					responseProcessorFn (data);
				},
				headers: headers,
				async: false
			};
			$.ajax(currentRequest);
		};
			
/*		gmsInterface.call_agent = function() {
			alert ("About to call agent...");
            var gsg_uri = 'http://216.38.144.134:8080/genesys/1/service/callback/cb813';
            var boundary = '--AaB03x\r\nContent-Disposition: form-data; name=';
            var requestBody = '';

//            var phone_number = $('#phone_number_text').attr('value');
//            var provideCode = "false";
//            var login_txt = $('#hidden_login_txt').attr('value');
//            var stop_value = $('#hidden_stop_text').attr('value');

			var provideCode = "false";
			var phoneNumber = "6502388511";
			var name = "John Doe";
            requestBody += boundary + '"_provide_code"\r\n\r\n' + provideCode + "\r\n";
            requestBody += boundary + '"context"\r\n\r\ncallback demo\r\n';
            requestBody += boundary + '"coords"\r\n\r\n' + coords + "\r\n";
            requestBody += boundary + '"name"\r\n\r\n' + name +"\r\n";
            requestBody += boundary + '"_customer_number"\r\n\r\n'+phoneNumber+'\r\n';
            requestBody += boundary + '"_call_direction"\r\n\r\nUSERORIGINATED\r\n';
            requestBody += boundary + '"_wait_for_agent"\r\n\r\nfalse\r\n';
            requestBody += boundary + '"_wait_for_user_confirm"\r\n\r\nfalse\r\n';
            requestBody += boundary + '"_media_type"\r\n\r\nvoice\r\n';
            requestBody += "--AaB03x";

            $.ajax({
                type:'POST',
                contentType:'multipart/form-data;boundary=AaB03x;charset=UTF-8',
                url:gsg_uri,
                data:requestBody,
                success:function(data) {
                    g_data = data;
                    window.console &&  console.log('received response');
                    //alert('call : +1' + data._access_number);
                    document.location.href =  'tel:+1' + data._access_number;
                }
            });


		};
*/		
		gmsNotificationClient.enableComet = function (gmsUser, onCometNotification) {
			gmsNotificationClient.cometEnabled = true;
			gmsNotificationClient.startCometClient(gmsUser, onCometNotification);
		};
		gmsNotificationClient.disableComet = function () {
			gmsNotificationClient.cometEnabled = false;
			gmsNotificationClient.stopCometClient();
		};
		gmsNotificationClient.startCometClient = function (gmsUser, callbackFn) {
			try {
				if (gmsNotificationClient.cometEnabled && !gmsNotificationClient.cometConnected) {
								$.ajaxSetup({async: true});
					var cometd = $.cometd;
					cometd.websocketEnabled = false;

					cometd.configure({
						url: window.location.protocol + "//" + window.location.host + "/genesys/cometd",
						requestHeaders: { "gms_user": gmsUser}
					});
					cometdConnectListener = cometd.addListener("/meta/connect", function(message)
					{
						if (cometd.isDisconnected()) {
							gmsNotificationClient.cometConnected = false;
							return;
						}
						gmsNotificationClient.cometConnected = true;
						//window.console &&  console.log ("Comet (re)connected");
					});
					cometdDisconnectListener = cometd.addListener("/meta/disconnect", function(message)
					{
						gmsNotificationClient.cometConnected = false;
						//window.console &&  console.log( JSON.stringify( e ) );
						//window.console &&  console.log ("Comet disconnected");
					});
					cometd.handshake();
					cometdGenesysSubscription = cometd.subscribe("/_genesys", callbackFn);
					//$("#assigned_cid").text( cometd.clientId );
					gmsNotificationClient.cometConnected = true;
				} else {
					return false;
				}
			} catch (e) {
				alert(e);
				//window.console &&  console.log ("Unable to setup comet connection:" + JSON.stringify(e));
				return false;
			}
		};
		gmsNotificationClient.stopCometClient = function () {
			var cometd = $.cometd;
			if (cometdGenesysSubscription) {
				cometd.unsubscribe (cometdGenesysSubscription);
				cometdGenesysSubscription = null;
			}
			if (cometdConnectListener) {
				cometd.removeListener(cometdConnectListener);
				cometdConnectListener = null;
			}
			if (cometdDisconnectListener) {
				cometd.removeListener(cometdDisconnectListener);
				cometdDisconnectListener = null;
			}
			cometd.disconnect();
		};
    });


