/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.composer.core.security.crypto;

import com.genesyslab.composer.core.security.crypto.ComposerCryptoException;
import com.genesyslab.composer.core.security.crypto.IComposerDecrypt;
import com.genesyslab.composer.core.security.crypto.IComposerEncrypt;
import com.genesyslab.composer.core.security.crypto.IComposerKeyProvider;
import org.apache.commons.codec.binary.Base64;

public final class ComposerCryptoAES128Utils {
    public static String encryptAndEncodeWithIV(String string, IComposerEncrypt iComposerEncrypt, IComposerKeyProvider iComposerKeyProvider) throws ComposerCryptoException {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = iComposerEncrypt.encrypt(byArray, iComposerKeyProvider);
            byte[] byArray3 = iComposerEncrypt.getIV();
            byte[] byArray4 = new byte[byArray3.length + byArray2.length];
            System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
            System.arraycopy(byArray2, 0, byArray4, byArray3.length, byArray2.length);
            return new String(Base64.encodeBase64((byte[])byArray4), "UTF-8");
        }
        catch (ComposerCryptoException composerCryptoException) {
            throw composerCryptoException;
        }
        catch (Exception exception) {
            throw new ComposerCryptoException(exception);
        }
    }

    public static String decodeWithIVAndDecrypt(String string, IComposerDecrypt iComposerDecrypt, IComposerKeyProvider iComposerKeyProvider) throws ComposerCryptoException {
        try {
            byte[] byArray = Base64.decodeBase64((byte[])string.getBytes("UTF-8"));
            byte[] byArray2 = new byte[16];
            byte[] byArray3 = new byte[byArray.length - 16];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            System.arraycopy(byArray, byArray2.length, byArray3, 0, byArray3.length);
            byte[] byArray4 = iComposerDecrypt.decrypt(byArray3, iComposerKeyProvider, byArray2);
            return new String(byArray4, "UTF-8");
        }
        catch (ComposerCryptoException composerCryptoException) {
            throw composerCryptoException;
        }
        catch (Exception exception) {
            throw new ComposerCryptoException(exception);
        }
    }
}

