/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.composer.core.security.crypto;

import com.genesyslab.composer.core.security.crypto.ComposerCryptoException;
import com.genesyslab.composer.core.security.crypto.IComposerDecrypt;
import com.genesyslab.composer.core.security.crypto.IComposerEncrypt;
import com.genesyslab.composer.core.security.crypto.IComposerKeyProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class ComposerEncryptionAES128
implements IComposerEncrypt,
IComposerDecrypt {
    private Logger logger;
    private Cipher cipher;
    private byte[] iv = null;

    public ComposerEncryptionAES128() {
        this.logger = Logger.getLogger((String)ComposerEncryptionAES128.class.getName());
    }

    public ComposerEncryptionAES128(Logger logger) {
        this.logger = logger;
    }

    @Override
    public byte[] encrypt(byte[] byArray, IComposerKeyProvider iComposerKeyProvider) throws ComposerCryptoException {
        try {
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(iComposerKeyProvider.getKey(), "AES");
            IvParameterSpec ivParameterSpec = null;
            if (this.iv != null) {
                ivParameterSpec = new IvParameterSpec(this.iv);
            }
            if (ivParameterSpec != null) {
                this.cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            } else {
                this.cipher.init(1, secretKeySpec);
            }
            return this.cipher.doFinal(byArray);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            this.logger.error((Object)"Failed to get cipher instance", (Throwable)generalSecurityException);
            throw new ComposerCryptoException(generalSecurityException);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
            this.logger.error((Object)"Failed to initialize cipher", (Throwable)generalSecurityException);
            throw new ComposerCryptoException(generalSecurityException);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            this.logger.error((Object)"Failed to perform encryption", (Throwable)generalSecurityException);
            throw new ComposerCryptoException(generalSecurityException);
        }
    }

    @Override
    public byte[] getIV() {
        return this.cipher.getIV();
    }

    @Override
    public byte[] decrypt(byte[] byArray, IComposerKeyProvider iComposerKeyProvider, byte[] byArray2) throws ComposerCryptoException {
        try {
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(iComposerKeyProvider.getKey(), "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            this.cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            return this.cipher.doFinal(byArray);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            this.logger.error((Object)"Failed to get cipher instance", (Throwable)generalSecurityException);
            throw new ComposerCryptoException(generalSecurityException);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
            this.logger.error((Object)"Failed to initialize cipher", (Throwable)generalSecurityException);
            throw new ComposerCryptoException(generalSecurityException);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            this.logger.error((Object)"Failed to perform encryption", (Throwable)generalSecurityException);
            throw new ComposerCryptoException(generalSecurityException);
        }
    }
}

