/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.composer.storedprocedurehelper.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

public class CVDBProcParam
implements Serializable {
    private static final long serialVersionUID = -6440343843071741287L;
    public static final int COLUMN_TYPE_ALL = Integer.MAX_VALUE;
    private Object procedure;
    private String parameterName;
    private String parameterValue;
    private int dataType;
    private int parameterType;
    private boolean valueVarType;

    public CVDBProcParam(String string, int n, int n2) {
        this.parameterName = string;
        this.parameterType = n;
        this.dataType = n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ParamName:").append(this.parameterName);
        stringBuilder.append("::Type:").append(this.parameterType);
        stringBuilder.append("::SQLType:").append(this.dataType);
        stringBuilder.append("::Value:").append(this.parameterValue);
        return stringBuilder.toString();
    }

    public int getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(int n) {
        this.parameterType = n;
    }

    public String getParameterValue() {
        return this.parameterValue;
    }

    public void setParameterValue(String string) {
        this.parameterValue = string;
    }

    public String getParameterTypeString() {
        switch (this.parameterType) {
            case 1: {
                return "IN";
            }
            case 4: {
                return "OUT";
            }
            case 2: {
                return "INOUT";
            }
            case 5: {
                return "RETURN";
            }
            case 3: {
                return "RESULT";
            }
        }
        return "UNKNOWN";
    }

    public static int getParameterType(String string) {
        if (string.equalsIgnoreCase("IN") || string.equalsIgnoreCase("INPUT")) {
            return 1;
        }
        if (string.equalsIgnoreCase("OUT") || string.equalsIgnoreCase("OUTPUT")) {
            return 4;
        }
        if (string.equalsIgnoreCase("INOUT")) {
            return 2;
        }
        if (string.equalsIgnoreCase("RETURN")) {
            return 5;
        }
        if (string.equalsIgnoreCase("RESULT")) {
            return 3;
        }
        return -1;
    }

    public Object getProcedure() {
        return this.procedure;
    }

    public void setProcedure(Object object) {
        this.procedure = object;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String string) {
        this.parameterName = string;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int n) {
        this.dataType = n;
    }

    public String getDataTypeString() {
        switch (this.dataType) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -16: {
                return "LONGNVARCHAR";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case -15: {
                return "NCHAR";
            }
            case 2011: {
                return "NCLOB";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case -9: {
                return "NVARCHAR";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case -8: {
                return "ROWID";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2009: {
                return "SQLXML";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "UNKNOWN";
    }

    public static int getSQLType(String string) {
        if (string.equalsIgnoreCase("ARRAY")) {
            return 2003;
        }
        if (string.equalsIgnoreCase("BIGINT")) {
            return -5;
        }
        if (string.equalsIgnoreCase("BINARY")) {
            return -2;
        }
        if (string.equalsIgnoreCase("BIT")) {
            return -7;
        }
        if (string.equalsIgnoreCase("BLOB")) {
            return 2004;
        }
        if (string.equalsIgnoreCase("BOOLEAN")) {
            return 16;
        }
        if (string.equalsIgnoreCase("CHAR")) {
            return 1;
        }
        if (string.equalsIgnoreCase("CLOB")) {
            return 2005;
        }
        if (string.equalsIgnoreCase("DATALINK")) {
            return 70;
        }
        if (string.equalsIgnoreCase("DATE")) {
            return 91;
        }
        if (string.equalsIgnoreCase("DECIMAL")) {
            return 3;
        }
        if (string.equalsIgnoreCase("DISTINCT")) {
            return 2001;
        }
        if (string.equalsIgnoreCase("DOUBLE")) {
            return 8;
        }
        if (string.equalsIgnoreCase("FLOAT")) {
            return 6;
        }
        if (string.equalsIgnoreCase("INTEGER")) {
            return 4;
        }
        if (string.equalsIgnoreCase("JAVA_OBJECT")) {
            return 2000;
        }
        if (string.equalsIgnoreCase("LONGNVARCHAR")) {
            return -16;
        }
        if (string.equalsIgnoreCase("LONGVARBINARY")) {
            return -4;
        }
        if (string.equalsIgnoreCase("LONGVARCHAR")) {
            return -1;
        }
        if (string.equalsIgnoreCase("NCHAR")) {
            return -15;
        }
        if (string.equalsIgnoreCase("NCLOB")) {
            return 2011;
        }
        if (string.equalsIgnoreCase("NULL")) {
            return 0;
        }
        if (string.equalsIgnoreCase("NUMERIC")) {
            return 2;
        }
        if (string.equalsIgnoreCase("NVARCHAR")) {
            return -9;
        }
        if (string.equalsIgnoreCase("OTHER")) {
            return 1111;
        }
        if (string.equalsIgnoreCase("REAL")) {
            return 7;
        }
        if (string.equalsIgnoreCase("REF")) {
            return 2006;
        }
        if (string.equalsIgnoreCase("ROWID")) {
            return -8;
        }
        if (string.equalsIgnoreCase("SMALLINT")) {
            return 5;
        }
        if (string.equalsIgnoreCase("SQLXML")) {
            return 2009;
        }
        if (string.equalsIgnoreCase("STRUCT")) {
            return 2002;
        }
        if (string.equalsIgnoreCase("TIME")) {
            return 92;
        }
        if (string.equalsIgnoreCase("TIMESTAMP")) {
            return 93;
        }
        if (string.equalsIgnoreCase("TINYINT")) {
            return -6;
        }
        if (string.equalsIgnoreCase("VARBINARY")) {
            return -3;
        }
        if (string.equalsIgnoreCase("VARCHAR")) {
            return 12;
        }
        return -1;
    }

    public void setValueVarType(boolean bl) {
        this.valueVarType = bl;
    }

    public boolean isValueVarType() {
        return this.valueVarType;
    }

    public Object getParameterValueObject(Map<String, String> map) {
        String string = this.getParameterValue();
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.startsWith("{") && string.endsWith("}")) {
            if (map == null) {
                System.out.println("Application Variables not available. AppState is null.");
                return null;
            }
            string = string.substring(1, string.length() - 1);
            string = map.get(string);
        }
        Object object = new Object();
        try {
            switch (this.getDataType()) {
                case -1: 
                case 1: 
                case 12: {
                    object = string;
                    break;
                }
                case 2: 
                case 3: {
                    object = new BigDecimal(string);
                    break;
                }
                case -7: 
                case 16: {
                    if (string != null && string.length() > 0 && (string.equalsIgnoreCase("true") || string.equals("1"))) {
                        object = new Boolean("true");
                        break;
                    }
                    object = new Boolean("false");
                    break;
                }
                case 4: {
                    object = Integer.parseInt(string);
                    break;
                }
                case -5: {
                    object = Long.parseLong(string);
                    break;
                }
                case 7: {
                    object = Float.valueOf(Float.parseFloat(string));
                    break;
                }
                case 8: {
                    object = Double.parseDouble(string);
                    break;
                }
                case 91: {
                    object = Date.valueOf(string);
                    break;
                }
                case 92: {
                    object = Time.valueOf(string);
                    break;
                }
                case 93: {
                    object = Timestamp.valueOf(string);
                    break;
                }
                default: {
                    System.out.println("Unsupported data type:" + this.getDataTypeString() + " using String object as input to prepared statement.");
                    object = string;
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to change parameter value " + string + " for " + this.parameterName + " to data type " + this.getDataTypeString());
            exception.printStackTrace();
        }
        return object;
    }
}

