/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.studio.backendlogic;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class BackendLogManager {
    private static boolean configurationChecked = false;

    private static void setdefaultLog4jConfiguration() {
        System.out.println("BackendLogManager: setting default log4j configuration");
        Properties properties = new Properties();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("log4j.rootCategory=DEBUG, R\n");
        stringBuilder.append("log4j.logger.com.dappit.Dapper.parser=ERROR\n");
        stringBuilder.append("log4j.logger.org.w3c.tidy=FATAL\n");
        stringBuilder.append("log4j.appender.R = org.apache.log4j.RollingFileAppender\n");
        stringBuilder.append("log4j.appender.R.File = ${catalina.home}/logs/default_composer.log\n");
        stringBuilder.append("log4j.appender.R.Append = true\n");
        stringBuilder.append("log4j.appender.R.layout = org.apache.log4j.PatternLayout\n");
        stringBuilder.append("log4j.appender.R.layout.ConversionPattern = %d %c{1} [%p] - %m%n\n");
        StringReader stringReader = new StringReader(stringBuilder.toString());
        try {
            properties.load(stringReader);
            PropertyConfigurator.configure((Properties)properties);
            System.out.println("BackendLogManager: setting default log4j configuration done");
        }
        catch (Exception exception) {
            System.out.println("BackendLogManager: error setting default log4j configuration: " + exception.getMessage());
        }
    }

    private static void checkLog4jConfiguration() {
        System.out.println("BackendLogManager: checking log4j configuration");
        String string = System.getProperty("catalina.base") + File.separator + "lib" + File.separator + "log4j.xml";
        File file = new File(string);
        if (file.exists()) {
            System.out.println("BackendLogManager: log4j configuration file exist: " + string);
            PropertyConfigurator.configure((String)string);
        } else {
            System.out.println("BackendLogManager: log4j configuration file not found: " + string);
            BackendLogManager.setdefaultLog4jConfiguration();
        }
        configurationChecked = true;
    }

    public static Logger getLogger(String string) {
        System.out.println("BackendLogManager: getLogger('" + string + "')");
        if (!configurationChecked) {
            BackendLogManager.checkLog4jConfiguration();
        }
        Logger logger = null;
        try {
            logger = Logger.getLogger((String)string);
        }
        catch (Exception exception) {
            System.out.println("BackendLogManager: error gettin logger: " + exception.getMessage());
        }
        return logger;
    }

    public static String printStackTrace(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

