/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.studio.backendlogic;

import com.genesyslab.studio.backendlogic.BackendLogManager;
import com.genesyslab.studio.backendlogic.GVPAppBackendException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class GVPHttpRequestProcessor {
    private static final Logger logger = BackendLogManager.getLogger("dbRequest");
    private HttpServletRequest request;
    private String json;
    private Map<String, String> additionalParams;

    public GVPHttpRequestProcessor(HttpServletRequest httpServletRequest) {
        logger.info((Object)"GVPHttpRequestProcessor() constructor");
        this.request = httpServletRequest;
        this.additionalParams = new HashMap<String, String>();
    }

    public void parseRequest() throws Exception {
        try {
            logger.info((Object)"GVPHttpRequestProcessor.parseRequest() in");
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)this.request)) {
                this.parseMultiPart();
            } else {
                this.parseURLEncoded();
            }
            logger.info((Object)"GVPHttpRequestProcessor.parseRequest() out");
        }
        catch (Exception exception) {
            throw new GVPAppBackendException("Could not parse the request and POST data", exception);
        }
    }

    private void parseMultiPart() throws FileUploadException {
        logger.info((Object)"GVPHttpRequestProcessor.parseMultiPart() in");
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        List list = servletFileUpload.parseRequest(this.request);
        for (FileItem fileItem : list) {
            String string;
            if (!fileItem.isFormField()) continue;
            String string2 = fileItem.getFieldName();
            try {
                string = fileItem.getString("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = fileItem.getString();
            }
            this.saveParam(string2, string);
        }
        logger.info((Object)"GVPHttpRequestProcessor.parseMultiPart() out");
    }

    private void parseURLEncoded() throws GVPAppBackendException {
        logger.info((Object)"GVPHttpRequestProcessor.parseURLEncoded() in");
        Map map = this.request.getParameterMap();
        if (map == null) {
            return;
        }
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            if (!(v instanceof String[])) {
                throw new GVPAppBackendException("Parameter map invalid");
            }
            String[] stringArray = (String[])v;
            String string = stringArray[0];
            String string2 = (String)k;
            this.saveParam(string2, string);
        }
        logger.info((Object)"GVPHttpRequestProcessor.parseURLEncoded() out");
    }

    private void saveParam(String string, String string2) {
        logger.info((Object)("GVPHttpRequestProcessor.saveParam(param: '" + string + "', value: '" + string2 + "') in"));
        if (string.equals("AppStateString")) {
            this.json = string2.startsWith("(") ? string2.substring(1, string2.length() - 1) : string2;
            this.additionalParams.put(string, string2);
        } else {
            if (string.startsWith("AppState.")) {
                string = string.substring(9);
            }
            this.additionalParams.put(string, string2);
        }
        logger.info((Object)"GVPHttpRequestProcessor.saveParam() out");
    }

    public JSONObject getState() {
        logger.info((Object)"GVPHttpRequestProcessor.getState() in");
        if (this.json == null || this.json.trim().length() == 0) {
            logger.info((Object)"GVPHttpRequestProcessor.getState() out null");
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(this.json);
            logger.info((Object)("GVPHttpRequestProcessor.getState() out jsonObject: " + jSONObject.toString()));
            return jSONObject;
        }
        catch (Exception exception) {
            logger.error((Object)BackendLogManager.printStackTrace(exception));
            return null;
        }
    }

    public Map<String, String> getAdditionalParams() {
        logger.info((Object)("GVPHttpRequestProcessor.getAdditionalParams() additionalParams: " + this.additionalParams.toString()));
        return this.additionalParams;
    }
}

