/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.studio.backendlogic.db;

import com.genesyslab.composer.storedprocedurehelper.model.CVDBProcParam;
import com.genesyslab.studio.backendlogic.BackendLogManager;
import com.genesyslab.studio.backendlogic.GVPHttpRequestProcessor;
import com.genesyslab.studio.backendlogic.db.CVDBConnProfileReader;
import com.genesyslab.studio.backendlogic.db.CVDBQueryReader;
import com.genesyslab.studio.querybuilder.model.CVDBConnProfile;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class CVDBBackendHandler {
    private static final Logger logger = BackendLogManager.getLogger("dbRequest");
    private static final String ERROR_TYPE_TIMEOUT = "timeout";
    private static final String ERROR_TYPE_CONNECTION = "connectionerror";
    private static final int DEFAULT_TIMEOUT = 20;
    private static String rConnString = null;

    public static void handleRequest(HttpServletRequest httpServletRequest, final HttpServletResponse httpServletResponse, ServletContext servletContext) {
        Object object;
        String[] stringArray;
        Object object2;
        String string;
        String string2;
        Object object3;
        logger.info((Object)"CVDBBackendHandler.handleRequest() in");
        httpServletResponse.setContentType("application/json;charset=UTF-8");
        JSONObject jSONObject = null;
        Map<String, String> map = null;
        JSONObject jSONObject2 = null;
        rConnString = null;
        try {
            object3 = new GVPHttpRequestProcessor(httpServletRequest);
            ((GVPHttpRequestProcessor)object3).parseRequest();
            jSONObject = ((GVPHttpRequestProcessor)object3).getState();
            map = ((GVPHttpRequestProcessor)object3).getAdditionalParams();
        }
        catch (Exception exception) {
            logger.error((Object)BackendLogManager.printStackTrace(exception));
            CVDBBackendHandler.handleError("Failed to process request", null, exception, httpServletResponse);
            return;
        }
        object3 = map.get("db_query");
        String string3 = map.get("db_name");
        String string4 = map.get("db_query_type");
        if (map.containsKey("connString")) {
            rConnString = map.get("connString");
        } else if (map.containsKey("ConnPropString")) {
            try {
                string2 = map.get("ConnPropString");
                jSONObject2 = new JSONObject(string2.substring(1, string2.length() - 1));
                logger.info((Object)"Override details");
                logger.info((Object)jSONObject2.toString());
            }
            catch (JSONException jSONException) {
                jSONObject2 = null;
                logger.error((Object)BackendLogManager.printStackTrace((Exception)((Object)jSONException)));
            }
        }
        string2 = map.get("AppStateString");
        logger.info((Object)("AppStateString: " + string2));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string4 != null && string4.equalsIgnoreCase("StoredProcedure")) {
            string = map.get("sp_param_list");
            logger.info((Object)("sp_param_list: " + string));
            String[] stringArray2 = string != null ? string.split(" ") : new String[]{};
            object2 = "";
            for (String timeoutException : stringArray2) {
                if (timeoutException == null || timeoutException.trim().length() <= 0 || (stringArray = (object2 = map.get("sp_param_" + timeoutException)) != null ? ((String)object2).split("\\$\\$") : new String[]{}).length < 1) continue;
                object = new CVDBProcParam(timeoutException, CVDBProcParam.getParameterType(stringArray[0]), CVDBProcParam.getSQLType(stringArray[1]));
                if (stringArray.length > 2) {
                    ((CVDBProcParam)object).setParameterValue(stringArray[2]);
                }
                arrayList.add(object);
                logger.info((Object)("Constructed - " + ((CVDBProcParam)object).toString()));
            }
        }
        string = map.get("db_timeout");
        int n = 20;
        if (string != null && string.trim().length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        object2 = null;
        Object var14_19 = null;
        Map map2 = null;
        Future future = null;
        try {
            Object object4;
            Object object5;
            String timeoutException;
            timeoutException = CVDBBackendHandler.getQuery((String)object3, string4, string2, servletContext);
            logger.info((Object)("dbQuery: " + timeoutException));
            stringArray = new CVDBConnProfileReader(string3, servletContext);
            stringArray.readFile();
            object = stringArray.getConnProfile();
            if (rConnString == null) {
                CVDBBackendHandler.overrideValues((CVDBConnProfile)object, jSONObject2);
            }
            ArrayList<Object> arrayList2 = arrayList;
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            if (jSONObject != null) {
                object5 = jSONObject.keys();
                object4 = "";
                logger.info((Object)"App State::");
                while (object5.hasNext()) {
                    object4 = (String)object5.next();
                    hashMap.put(object4, "" + jSONObject.get((String)object4));
                    logger.info((Object)("\t" + (String)object4 + ":" + (String)hashMap.get(object4)));
                }
            }
            object5 = hashMap;
            object4 = new Callable<HashMap<String, Object>>((CVDBConnProfile)object, timeoutException, string4, arrayList2, (Map)object5){
                final /* synthetic */ CVDBConnProfile val$connProfile;
                final /* synthetic */ String val$dbQuery;
                final /* synthetic */ String val$dbQueryType;
                final /* synthetic */ List val$parameters;
                final /* synthetic */ Map val$fAppStateMap;
                {
                    this.val$connProfile = cVDBConnProfile;
                    this.val$dbQuery = string;
                    this.val$dbQueryType = string2;
                    this.val$parameters = list;
                    this.val$fAppStateMap = map;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public HashMap<String, Object> call() throws Exception {
                    Connection connection = null;
                    CallableStatement callableStatement = null;
                    ResultSet resultSet = null;
                    try {
                        int n;
                        int n2;
                        int n3;
                        logger.info((Object)"CVDBBackendHandler queryCallable.call() in");
                        connection = CVDBBackendHandler.getConnection(httpServletResponse, this.val$connProfile);
                        if (connection == null) {
                            HashMap<String, Object> hashMap = null;
                            return hashMap;
                        }
                        callableStatement = connection.prepareCall(this.val$dbQuery);
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        if (this.val$dbQueryType != null && this.val$dbQueryType.equalsIgnoreCase("StoredProcedure")) {
                            CVDBProcParam cVDBProcParam;
                            int n4;
                            boolean bl = false;
                            for (n4 = 0; n4 < this.val$parameters.size(); ++n4) {
                                cVDBProcParam = (CVDBProcParam)this.val$parameters.get(n4);
                                if (cVDBProcParam.getParameterType() != 5) continue;
                                bl = true;
                            }
                            n4 = 0;
                            if (bl) {
                                n4 = 1;
                            }
                            logger.info((Object)("indexOffset: " + n4));
                            block40: for (n3 = 1; n3 <= this.val$parameters.size(); ++n3) {
                                cVDBProcParam = (CVDBProcParam)this.val$parameters.get(n3 - 1);
                                int n5 = cVDBProcParam.getParameterType();
                                switch (n5) {
                                    case 1: {
                                        logger.info((Object)"DatabaseMetaData.procedureColumnIn");
                                        Object object = cVDBProcParam.getParameterValueObject(this.val$fAppStateMap);
                                        if (object != null) {
                                            callableStatement.setObject(n3 + n4, object);
                                            continue block40;
                                        }
                                        callableStatement.setNull(n3 + n4, cVDBProcParam.getDataType());
                                        continue block40;
                                    }
                                    case 2: {
                                        logger.info((Object)"DatabaseMetaData.procedureColumnInOut");
                                        Object object = cVDBProcParam.getParameterValueObject(this.val$fAppStateMap);
                                        if (object != null) {
                                            callableStatement.setObject(n3 + n4, object);
                                        } else {
                                            callableStatement.setNull(n3 + n4, cVDBProcParam.getDataType());
                                        }
                                        callableStatement.registerOutParameter(n3 + n4, cVDBProcParam.getDataType());
                                        continue block40;
                                    }
                                    case 4: {
                                        logger.info((Object)"DatabaseMetaData.procedureColumnOut");
                                        callableStatement.registerOutParameter(n3 + n4, cVDBProcParam.getDataType());
                                        continue block40;
                                    }
                                    case 5: {
                                        logger.info((Object)"DatabaseMetaData.procedureColumnReturn");
                                        callableStatement.registerOutParameter(1, cVDBProcParam.getDataType());
                                        n4 = 0;
                                        continue block40;
                                    }
                                    default: {
                                        logger.info((Object)"default");
                                    }
                                }
                            }
                            callableStatement.setFetchSize(50);
                        }
                        boolean bl = callableStatement.execute();
                        ArrayList arrayList = new ArrayList();
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        if (bl) {
                            logger.info((Object)"resultSetExists");
                            resultSet = callableStatement.getResultSet();
                            ResultSetMetaData resultSetMetaData = callableStatement.getMetaData();
                            n3 = resultSetMetaData.getColumnCount();
                            for (int i = 1; i <= n3; ++i) {
                                arrayList2.add(resultSetMetaData.getColumnLabel(i));
                                logger.info((Object)("columnLabels.add('" + resultSetMetaData.getColumnLabel(i) + "')"));
                            }
                            if (resultSet != null) {
                                while (resultSet.next()) {
                                    if (Thread.interrupted()) {
                                        logger.trace((Object)"Thread interrupted, returning");
                                        HashMap<String, Object> hashMap2 = null;
                                        return hashMap2;
                                    }
                                    ArrayList<String> arrayList3 = new ArrayList<String>();
                                    for (n2 = 0; n2 < n3; ++n2) {
                                        String string = resultSet.getString(n2 + 1);
                                        arrayList3.add(string);
                                    }
                                    arrayList.add(arrayList3);
                                }
                            }
                        }
                        HashMap<String, String> hashMap3 = new HashMap<String, String>();
                        String string = null;
                        CVDBProcParam cVDBProcParam = null;
                        boolean bl2 = false;
                        for (n = 0; n < this.val$parameters.size(); ++n) {
                            cVDBProcParam = (CVDBProcParam)this.val$parameters.get(n);
                            if (cVDBProcParam.getParameterType() != 5) continue;
                            logger.info((Object)"returnValueExists");
                            bl2 = true;
                        }
                        n = 0;
                        if (bl2) {
                            n = 1;
                        }
                        for (int i = 1; i <= this.val$parameters.size(); ++i) {
                            cVDBProcParam = (CVDBProcParam)this.val$parameters.get(i - 1);
                            n2 = cVDBProcParam.getParameterType();
                            string = null;
                            switch (n2) {
                                case 2: 
                                case 4: {
                                    logger.info((Object)"DatabaseMetaData.procedureColumnOut");
                                    string = "" + callableStatement.getObject(i + n);
                                    hashMap3.put(cVDBProcParam.getParameterName(), "NULL");
                                    break;
                                }
                                case 5: {
                                    logger.info((Object)"DatabaseMetaData.procedureColumnReturn");
                                    string = "" + callableStatement.getObject(1);
                                    hashMap3.put(cVDBProcParam.getParameterName(), "NULL");
                                    n = 0;
                                    break;
                                }
                                default: {
                                    logger.info((Object)"default");
                                }
                            }
                            if (string == null) continue;
                            hashMap3.put(cVDBProcParam.getParameterName(), string);
                        }
                        hashMap.put("ResultSetTableHeader", arrayList2);
                        hashMap.put("ResultSetTable", arrayList);
                        hashMap.put("OutputParameters", hashMap3);
                        logger.info((Object)("Result Data::" + hashMap.toString()));
                        logger.info((Object)"CVDBBackendHandler queryCallable.call() out");
                        HashMap<String, Object> hashMap4 = hashMap;
                        return hashMap4;
                    }
                    finally {
                        try {
                            logger.trace((Object)"Closing result set");
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            logger.error((Object)BackendLogManager.printStackTrace(sQLException));
                        }
                        try {
                            logger.trace((Object)"Closing statement");
                            if (callableStatement != null) {
                                callableStatement.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            logger.error((Object)BackendLogManager.printStackTrace(sQLException));
                        }
                        try {
                            logger.trace((Object)"Closing connection");
                            if (connection != null) {
                                connection.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            logger.error((Object)BackendLogManager.printStackTrace(sQLException));
                        }
                        logger.trace((Object)"Done closing stuff");
                    }
                }
            };
            ExecutorService executorService = (ExecutorService)servletContext.getAttribute("COMPOSER_EXECUTOR");
            logger.trace((Object)("Got executor service from ServletContext - " + executorService));
            if (executorService == null) {
                executorService = Executors.newCachedThreadPool();
            }
            HashMap hashMap2 = null;
            logger.trace((Object)("Before DB call, timeout = " + n));
            future = executorService.submit(object4);
            hashMap2 = n != -1 ? (HashMap)future.get(n, TimeUnit.SECONDS) : (HashMap)future.get();
            logger.trace((Object)"DB call completed");
            if (hashMap2 != null) {
                List list = (List)hashMap2.get("ResultSetTableHeader");
                object2 = (List)hashMap2.get("ResultSetTable");
                map2 = (Map)hashMap2.get("OutputParameters");
                JSONObject jSONObject3 = new JSONObject();
                jSONObject3.put("db_result_columns", (Collection)list);
                jSONObject3.put("db_result", (Collection)object2);
                if (map2 != null && map2.size() > 0) {
                    jSONObject3.put("db_outparams", map2);
                }
                String string5 = jSONObject3.toString();
                logger.info((Object)("jsonString: " + string5));
                httpServletResponse.getWriter().print(string5);
            }
        }
        catch (SQLException executionException) {
            logger.error((Object)BackendLogManager.printStackTrace(executionException));
            CVDBBackendHandler.handleError("Database error occurred: ", null, executionException, httpServletResponse);
        }
        catch (TimeoutException exception) {
            boolean bl;
            logger.trace((Object)"DB call timed out");
            logger.error((Object)BackendLogManager.printStackTrace(exception));
            if (future != null && !(bl = future.cancel(true))) {
                logger.warn((Object)"Failed to cancel thread after timeout");
            }
            CVDBBackendHandler.handleError("The query timed out: ", ERROR_TYPE_TIMEOUT, exception, httpServletResponse);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)BackendLogManager.printStackTrace(executionException));
            if (executionException.getCause() instanceof SQLException) {
                CVDBBackendHandler.handleError("Database error occured: ", null, (SQLException)executionException.getCause(), httpServletResponse);
            } else {
                CVDBBackendHandler.handleError("Unknown error occured: ", null, executionException, httpServletResponse);
            }
        }
        catch (Exception exception) {
            logger.error((Object)BackendLogManager.printStackTrace(exception));
            CVDBBackendHandler.handleError("Unknown error occurred: ", null, exception, httpServletResponse);
        }
        logger.info((Object)"CVDBBackendHandler.handleRequest() out");
    }

    private static Connection getConnection(HttpServletResponse httpServletResponse, CVDBConnProfile cVDBConnProfile) {
        logger.info((Object)"CVDBBackendHandler.getConnection() in");
        String string = cVDBConnProfile.getJDBCURL();
        String string2 = cVDBConnProfile.getUsername();
        String string3 = cVDBConnProfile.getPassword();
        String string4 = cVDBConnProfile.getDriverClass();
        logger.info((Object)("dbUrl: " + string + ", dbUser: " + string2 + ", dbPassword: " + string3 + ", dbDriverClass: " + string4));
        boolean bl = cVDBConnProfile.isPooled();
        logger.info((Object)("isPooled: " + bl));
        try {
            if (bl) {
                String string5 = cVDBConnProfile.getDataSourceName();
                InitialContext initialContext = new InitialContext();
                Context context = (Context)initialContext.lookup("java:comp/env");
                DataSource dataSource = (DataSource)context.lookup(string5);
                logger.info((Object)"CVDBBackendHandler.getConnection() out");
                return dataSource.getConnection();
            }
            Class.forName(string4);
            logger.info((Object)"CVDBBackendHandler.getConnection() out");
            if (rConnString != null) {
                logger.info((Object)("using user specified url : " + rConnString));
                return DriverManager.getConnection(rConnString);
            }
            switch (cVDBConnProfile.getType()) {
                case MSSQL: {
                    return DriverManager.getConnection(string, string2, string3);
                }
                case ORACLE: {
                    Properties properties = new Properties();
                    properties.put("user", string2);
                    properties.put("password", string3);
                    if (cVDBConnProfile.isSecured()) {
                        if (cVDBConnProfile.isTrustCer()) {
                            properties.setProperty("oracle.net.ssl_cipher_suites", "(SSL_DH_anon_WITH_3DES_EDE_CBC_SHA, SSL_DH_anon_WITH_RC4_128_MD5,SSL_DH_anon_WITH_DES_CBC_SHA)");
                        } else {
                            properties.put("javax.net.ssl.trustStore", cVDBConnProfile.getTrustStore());
                            properties.put("javax.net.ssl.trustStoreType", cVDBConnProfile.getTrustStoreType());
                            properties.put("javax.net.ssl.trustStorePassword", cVDBConnProfile.getTrustStorePassword());
                        }
                        if (cVDBConnProfile.isMatchCrtSubject()) {
                            properties.put("oracle.net.ssl_server_dn_match", "yes");
                        }
                    }
                    if (!cVDBConnProfile.getCustomParametersJDBCMap().isEmpty()) {
                        logger.info((Object)"oracle ");
                        HashMap hashMap = (HashMap)cVDBConnProfile.getCustomParametersJDBCMap();
                        for (String string6 : hashMap.keySet()) {
                            logger.info((Object)("adding custom : " + string6));
                            properties.put(string6, hashMap.get(string6));
                        }
                    }
                    return DriverManager.getConnection(string, properties);
                }
            }
            return null;
        }
        catch (Exception exception) {
            logger.error((Object)BackendLogManager.printStackTrace(exception));
            CVDBBackendHandler.handleError("Database connection failed", ERROR_TYPE_CONNECTION, exception, httpServletResponse);
            return null;
        }
    }

    private static String getQuery(String string, String string2, String string3, ServletContext servletContext) throws Exception {
        CVDBQueryReader cVDBQueryReader = new CVDBQueryReader(string, string2, servletContext, string3);
        return cVDBQueryReader.getQuery();
    }

    private static void handleError(String string, String string2, Exception exception, HttpServletResponse httpServletResponse) {
        logger.info((Object)"CVDBBackendHandler.handleError() in");
        try {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("errorMsg", (Object)(string + " " + exception.getMessage()));
                if (string2 != null) {
                    jSONObject.put("errorType", (Object)string2);
                }
                logger.info((Object)("json: " + jSONObject.toString()));
                httpServletResponse.getWriter().print(jSONObject.toString());
            }
            catch (JSONException jSONException) {
                logger.error((Object)"{errorMsg:'Server error'}");
                httpServletResponse.getWriter().print("{errorMsg:'Server error'}");
            }
        }
        catch (IOException iOException) {
            logger.error((Object)"CVDBBackendHandler failed");
            logger.error((Object)BackendLogManager.printStackTrace(iOException));
        }
        logger.info((Object)"CVDBBackendHandler.handleError() out");
    }

    private static void overrideValues(CVDBConnProfile cVDBConnProfile, JSONObject jSONObject) {
        JSONObject jSONObject2;
        if (jSONObject == null) {
            return;
        }
        logger.info((Object)jSONObject.toString());
        try {
            if (jSONObject.has("database")) {
                cVDBConnProfile.setDatabase(jSONObject.getString("database"));
            }
            if (jSONObject.has("hostname")) {
                cVDBConnProfile.setHostname(jSONObject.getString("hostname"));
            }
            if (jSONObject.has("port")) {
                cVDBConnProfile.setPort(jSONObject.getString("port"));
            }
            if (jSONObject.has("username")) {
                cVDBConnProfile.setUsername(jSONObject.getString("username"));
            }
            if (jSONObject.has("password")) {
                cVDBConnProfile.setPassword(jSONObject.getString("password"));
            }
            if (jSONObject.has("trustStoreLocation")) {
                cVDBConnProfile.setTrustStore(jSONObject.getString("trustStoreLocation"));
            }
            if (jSONObject.has("trustStorePassword")) {
                cVDBConnProfile.setTrustStorePassword(jSONObject.getString("trustStorePassword"));
            }
            if (jSONObject.has("hostnameInCertificate")) {
                cVDBConnProfile.setHostNameInCrt(jSONObject.getString("hostnameInCertificate"));
            }
        }
        catch (JSONException jSONException) {
            logger.error((Object)"Overriding runtime connection properties failed");
            logger.error((Object)BackendLogManager.printStackTrace((Exception)((Object)jSONException)));
        }
        try {
            jSONObject2 = jSONObject.getJSONObject("customParameters");
        }
        catch (JSONException jSONException) {
            logger.error((Object)"Overriding runtime connection properties custom parameters failed");
            logger.error((Object)BackendLogManager.printStackTrace((Exception)((Object)jSONException)));
            jSONObject2 = null;
        }
        if (jSONObject2 != null) {
            HashMap hashMap = (HashMap)cVDBConnProfile.getCustomParametersJDBCMap();
            Iterator iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                try {
                    String string = (String)iterator.next();
                    hashMap.put(string, jSONObject2.getString(string));
                }
                catch (JSONException jSONException) {
                    logger.error((Object)"Overriding runtime connection properties custom parameters failed");
                    logger.error((Object)BackendLogManager.printStackTrace((Exception)((Object)jSONException)));
                }
            }
            cVDBConnProfile.setCustomParametersJDBCMap(hashMap);
        }
    }
}

