/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.studio.backendlogic.db;

import com.genesyslab.composer.core.security.crypto.ComposerEncryptionAES128;
import com.genesyslab.composer.querybuilder.util.CVDBConnProfileBuilder;
import com.genesyslab.studio.backendlogic.BackendLogManager;
import com.genesyslab.studio.backendlogic.security.crypto.ComposerBackendKeyProvider;
import com.genesyslab.studio.querybuilder.model.CVDBConnProfile;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class CVDBConnProfileReader {
    private static final Logger logger = BackendLogManager.getLogger("dbRequest");
    private ServletContext servletContext;
    private String connProfileName;
    private CVDBConnProfile connProfile;

    public CVDBConnProfileReader(String string, ServletContext servletContext) {
        logger.info((Object)("CVDBConnProfileReader(connProfileName: " + string + ", servletContext: " + servletContext.toString() + ") constructor"));
        this.servletContext = servletContext;
        this.connProfileName = string;
    }

    public void readFile() throws Exception {
        logger.info((Object)"CVDBConnProfileReader.readFile() in");
        InputStream inputStream = this.servletContext.getResourceAsStream("/db/connection.properties");
        if (inputStream == null) {
            throw new Exception("Connection properties file not found");
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            this.connProfile = CVDBConnProfileBuilder.readProfile(properties, this.connProfileName, new ComposerEncryptionAES128(logger), new ComposerBackendKeyProvider(this.servletContext, logger));
            logger.info((Object)("this.connProfile: " + this.connProfile.toString()));
        }
        catch (Exception exception) {
            logger.error((Object)BackendLogManager.printStackTrace(exception));
            throw exception;
        }
        logger.info((Object)"CVDBConnProfileReader.readFile() out");
    }

    public CVDBConnProfile getConnProfile() {
        logger.info((Object)("CVDBConnProfileReader.getConnProfile(): " + this.connProfile.toString()));
        return this.connProfile;
    }
}

