/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.studio.backendlogic.db;

import com.genesyslab.studio.backendlogic.BackendLogManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class CVDBQueryReader {
    private static final Logger logger = BackendLogManager.getLogger("dbRequest");
    private String dbQueryFile;
    private String dbQueryType;
    private ServletContext servletContext;
    private JSONObject appState;

    public CVDBQueryReader(String string, String string2, ServletContext servletContext, String string3) {
        logger.info((Object)"CVDBQueryReader() constructor");
        logger.info((Object)("dbQueryFile: " + string + ", dbQueryType: " + string2 + ", servletContext: " + servletContext.toString() + ", appStateStr: " + string3));
        this.dbQueryFile = string;
        this.dbQueryType = string2;
        this.servletContext = servletContext;
        try {
            this.appState = string3 != null ? new JSONObject(string3.substring(1, string3.length() - 1)) : new JSONObject();
            logger.info((Object)("appState: " + this.appState.toString()));
        }
        catch (JSONException jSONException) {
            logger.error((Object)BackendLogManager.printStackTrace((Exception)((Object)jSONException)));
        }
    }

    public String getQuery() throws Exception {
        Object object;
        logger.info((Object)"CVDBQueryReader.getQuery() in");
        InputStream inputStream = this.servletContext.getResourceAsStream("/db/" + this.dbQueryFile);
        if (inputStream == null) {
            throw new Exception("Query " + this.dbQueryFile + " not found");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringWriter stringWriter = new StringWriter();
        try {
            int n;
            while ((n = bufferedReader.read((char[])(object = new char[256]), 0, 256)) != -1) {
                stringWriter.write((char[])object, 0, n);
            }
        }
        catch (IOException iOException) {
            logger.error((Object)BackendLogManager.printStackTrace(iOException));
            throw iOException;
        }
        object = new StringBuffer(stringWriter.toString());
        if (this.dbQueryType != null && !this.dbQueryType.equalsIgnoreCase("StoredProcedure")) {
            this.replaceVariables((StringBuffer)object);
        }
        logger.info((Object)("sqlQuery: " + ((StringBuffer)object).toString()));
        logger.info((Object)"CVDBQueryReader.getQuery() out");
        return ((StringBuffer)object).toString();
    }

    private void replaceVariables(StringBuffer stringBuffer) throws Exception {
        logger.info((Object)"CVDBQueryReader.replaceVariables() in");
        logger.info((Object)("sqlQuery: " + stringBuffer.toString()));
        Pattern pattern = Pattern.compile("\\{.*?\\}");
        Matcher matcher = pattern.matcher(stringBuffer);
        StringBuffer stringBuffer2 = new StringBuffer();
        while (matcher.find()) {
            int n;
            int n2 = matcher.start();
            String string = stringBuffer.substring(n2 + 1, (n = matcher.end()) - 1);
            int n3 = string.lastIndexOf("AppState.");
            if (n3 != -1) {
                string = string.substring(n3 += "AppState.".length(), string.length());
            }
            try {
                if (this.appState == null) {
                    throw new Exception("AppState variable is undefined or malformed");
                }
                String string2 = this.appState.getString(string);
                string2 = this.format(string2);
                matcher.appendReplacement(stringBuffer2, string2);
            }
            catch (JSONException jSONException) {
                logger.error((Object)BackendLogManager.printStackTrace((Exception)((Object)jSONException)));
                throw jSONException;
            }
        }
        matcher.appendTail(stringBuffer2);
        stringBuffer.replace(0, stringBuffer.length(), stringBuffer2.toString());
        logger.info((Object)("sqlQuery: " + stringBuffer.toString()));
        logger.info((Object)"CVDBQueryReader.replaceVariables() out");
    }

    private String format(String string) {
        logger.info((Object)("CVDBQueryReader.format(varValue: " + string + ") in"));
        if (string.trim().startsWith("'") && string.trim().endsWith("'")) {
            logger.info((Object)("CVDBQueryReader.format(varValue: " + string + ") out"));
            return string;
        }
        try {
            Double.parseDouble(string);
            logger.info((Object)("CVDBQueryReader.format(varValue: " + string + ") out"));
            return string;
        }
        catch (NumberFormatException numberFormatException) {
            logger.info((Object)("CVDBQueryReader.format(varValue: '" + string.replace("'", "''") + "'" + ") out"));
            return "'" + string.replace("'", "''") + "'";
        }
    }
}

