/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecSAMLToken
extends WSSecBase {
    private static Log log = LogFactory.getLog(WSSecSAMLToken.class);
    private Document document = null;
    private AssertionWrapper saml = null;

    public WSSecSAMLToken() {
    }

    public WSSecSAMLToken(WSSConfig config) {
        super(config);
    }

    public void prepare(Document doc, AssertionWrapper assertion) {
        this.document = doc;
        this.saml = assertion;
    }

    public void prependToHeader(WSSecHeader secHeader) {
        try {
            Element element = this.saml.toDOM(this.document);
            WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), element);
        }
        catch (WSSecurityException ex) {
            throw new RuntimeException(ex.toString(), ex);
        }
    }

    public String getId() {
        if (this.saml == null) {
            return null;
        }
        return this.saml.getId();
    }

    public Document build(Document doc, AssertionWrapper assertion, WSSecHeader secHeader) {
        log.debug((Object)"Begin add SAMLAssertion token...");
        this.prepare(doc, assertion);
        this.prependToHeader(secHeader);
        return doc;
    }
}

