function offerCallback (etaPosThreshold, currentEta, currentPos) {
  

	var thresholdList = etaPosThreshold.split(",");
	var ewtPosList = new Array();
	var ewtPosItems = new Array();
	
	for (var index in thresholdList) {
		ewtPosItems = thresholdList[index].split(":");
		ewtPosList.push({"ewt":ewtPosItems[0], "pos":ewtPosItems[1]});
	}
	
	var offerCallbackResult = true;
	if (currentPos == 'n/a') {
		currentPos = 0;
	}

	// check ewt pos
	for (var index in ewtPosList) {
        var item = ewtPosList[index];
		if(currentEta <= parseInt(item.ewt) && currentPos <= parseInt(item.pos)) {
			offerCallbackResult = false;
			break;
		}
	}
	__Log ("etaPosThreshold=" + etaPosThreshold + ";currentEta=" + currentEta + ";currentPos=" + currentPos + ";offerCallback=" + offerCallbackResult);
	return offerCallbackResult;
}

function parseTimeInputs(input_day, input_time) {

	__Log ("input_day: " + input_day + ", input_time: " + input_time);
	var desired_time = moment();
	desired_time.seconds(0);
	desired_time.millisecond(0);
	
    var hour = parseInt(input_time.substring(0,2), 10);
    var minute = parseInt(input_time.substring(2,4), 10);
	__Log ("desired hour: " + hour + ", desired minute: " + minute);
    desired_time.hours(hour);
    desired_time.minutes(minute);
   
    var desired_day = parseInt(input_day) - 1;
    if (desired_day < 0)
        desired_day = 0;
    else if (desired_day > 6)
        desired_day = 6;
       
    if (desired_day != desired_time.day()) {
        var day_diff = desired_day - desired_time.day();
        if (day_diff < 0)
            day_diff = day_diff + 7;
        desired_time.add(day_diff, 'days');
    }
    
	__Log ("desired_time=" + desired_time.toISOString());
    return desired_time;
}

function processAvailabilityTimeSlots(slots) {
    var ret = {};
	if (slots == undefined || slots.length == 0) {
	    ret.noSlots = True;
	    return ret;
	}
	
	// Loop through the time slots building a TTS prompt
	ret.prompt = "";
	ret.dbInputArray = [];
	ret.timeStrings = [];
	ret.dbInputArray.push(["0"]);
	for (var i = 1; i <= slots.length; ++i) {
	    ret.dbInputArray.push([i.toString()]);
	    
	    var utc = slots[i-1].utcTime;
	    __Log ("Adding time: " + utc);
	    
	    // Extract time components from format YYYY-MM-DDThh:mm:ss.000Z and use to create a moment
	    // instance for the date/time. We use moment to utilize the calendar method which returns human
	    // friendly text for dates/times in the near future.
	    // Note, we can't just use moment(utc) because the MCP version of Javascript does not support this.
	    var regx = /(\d\d\d\d)-(\d\d)-(\d\d)T(\d\d):(\d\d):(\d\d)\.000Z/;
	    var match = regx.exec(utc);
	    var time = moment.utc();
	    time.year(Number(match[1]));
	    time.month(Number(match[2])-1);
	    time.date(Number(match[3]));
	    time.hour(Number(match[4]));
	    time.minute(Number(match[5]));
	    time.second(Number(match[6]));
	    time.local();
	    ret.timeStrings.push(time.calendar());
	    ret.prompt = ret.prompt + " For " + time.calendar() + " press " + i.toString() + ".";
	}
	
	ret.prompt = ret.prompt + " Press 0 to input another desired time.";
	return ret;
}
