/*
 GMSAPIUtil.h
 GMS Sample
 
 Disclaimer: IMPORTANT:  This software is supplied to you by Genesys
 Telecommunications Laboratories Inc ("Genesys") in consideration of your agreement
 to the following terms, and your use, installation, modification or redistribution
 of this Genesys software constitutes acceptance of these terms.  If you do not
 agree with these terms, please do not use, install, modify or redistribute this
 Genesys software.
 
 In consideration of your agreement to abide by the following terms, and subject
 to these terms, Genesys grants you a personal, non-exclusive license, under
 Genesys's copyrights in this original Genesys software (the "Genesys Software"), to
 use, reproduce, modify and redistribute the Genesys Software, with or without
 modifications, in source and/or binary forms; provided that if you redistribute
 the Genesys Software in its entirety and without modifications, you must retain
 this notice and the following text and disclaimers in all such redistributions
 of the Genesys Software.
 
 Neither the name, trademarks, service marks or logos of Genesys Inc. may be used
 to endorse or promote products derived from the Genesys Software without specific
 prior written permission from Genesys.  Except as expressly stated in this notice,
 no other rights or licenses, express or implied, are granted by Genesys herein,
 including but not limited to any patent rights that may be infringed by your
 derivative works or by other works in which the Genesys Software may be
 incorporated.
 
 The Genesys Software is provided by Genesys on an "AS IS" basis.  GENESYS MAKES NO
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, REGARDING THE GENESYS SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
 COMBINATION WITH YOUR PRODUCTS.
 
 IN NO EVENT SHALL GENESYS BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR
 DISTRIBUTION OF THE GENESYS SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF
 CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF
 GENESYS HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 Copyright (C) 2013 Genesys Inc. All Rights Reserved.
 */

#import <Foundation/Foundation.h>

enum {toGMS, fromGMS};
#define kUpdateNotification @"GMSLogUpdateNotification"

@interface GMSUtil : NSObject

// Note, this must be called at startup
+ (void) initialize;

// Note, this must be called before any submitRequest calls
+ (void) setBaseURL:(NSString*)URL;

+ (NSDate*) dateFromApiString:(NSString*)dateString;

+ (NSString*) apiStringFromDate:(NSDate*)dateString;

+ (NSString*) localStringFromDate:(NSDate*)date;

+ (NSString*) urlParamsFromDictionary:(NSDictionary*)dict;

+ (NSString*) bodyParamsFromDictionary:(NSDictionary*)dict;

+ (NSString*) stringFromNumericValue:(NSObject*)value;

// Submit an http request with relative path provided.
// Only return result if there was no error
+ (void) submitRequestWithPath:(NSString *)path         // path relative to http://host:port/genesys
                    method:(NSString *)method           //POST, GET, etc
                    params:(NSDictionary *)params
                   headers:(NSDictionary *)headers      //custom HTTP headers for request
           completionBlock:(void(^)(NSDictionary *responseDict))completionBlock;

// Submit an http request with relative path provided.
+ (void) submitRequestWithPath:(NSString *)path         // path relative to http://host:port/genesys
                        method:(NSString *)method           //POST, GET, etc
                        params:(NSDictionary *)params
                       headers:(NSDictionary *)headers      //custom HTTP headers for request
                 responseBlock:(void(^)(NSDictionary *responseDict, NSError *error))responseBlock;

// Submit an http request with full URL provided.
// Only return result if there was no error
+ (void) submitRequestWithURL:(NSString *)URL
                        method:(NSString *)method           //POST, GET, etc
                        params:(NSDictionary *)params
                       headers:(NSDictionary *)headers      //custom HTTP headers for request
               completionBlock:(void(^)(NSDictionary *responseDict))completionBlock;

// Submit an http request with full URL provided.
+ (void) submitRequestWithURL:(NSString *)URL
                       method:(NSString *)method           //POST, GET, etc
                       params:(NSDictionary *)params
                      headers:(NSDictionary *)headers      //custom HTTP headers for request
                responseBlock:(void(^)(NSDictionary *responseDict, NSError *error))responseBlock;

@end
