var data = { a: 1 }
var chatUi = new Vue({
    el: '#chatapp',
    data: {
        strGmsURL: '',
        strServiceName: '',
        boolGMSConnected: false,
        boolChatServerOnline: false,
        boolSessionActive: false,
        boolWaiting: false,
        strNickname: ""
    },
    mounted: function () {
        Metro.init();
    },
    created: function () {
        console.log('Ready to start');
    },
    methods: {
        disconnect: function () {
            disconnectFromGMS();
        },
        stopChat: function () {
            terminateChatSession();
        },
        startChat: function () {
            if (this.strGmsURL !== '' && this.strServiceName !== '') {
                this.runToast("Start chat...", "info");
                this.startWaiting();
                chatV2Start(this.strGmsURL, '/service/chatV2/' + this.strServiceName);
            } else {
                this.runDialog("Enter a URL and a service name first", "alert");

            }

        },
        startWaiting() {
            this.activity = Metro.activity.open();

        },
        stopWaiting() {
            if (this.activity) {
                Metro.activity.close(this.activity);
            } else {
                this.activity = null;
            }

        },

        sendMessage: function () {
            var chat = Metro.getPlugin("#chat", "chat");
            if (this.boolSessionActive) {
                sendMessage(chatUi.strNickname, chat.lastMessage.text);
            } else {
                this.runDialog("Your message was not delivered. No chat session active. Connect first.", "warning");
            }

        },

        displayMessage: function (from, msg) {
            var chat = Metro.getPlugin("#chat", "chat");
            if (from === "system" || from === this.strNickname ) {
                chat.add({
                    "text": msg,
                    "name": from,
                    "time": new Date(),
                    "avatar": "",
                    "position": "right"
                });

            } else {
                chat.add({
                    "text": msg,
                    "name": from,
                    "time": new Date(),
                    "avatar": "https://all.docs.genesys.com/images-supersite/3/3d/AgentLanding.png",
                    "position": "left"
                });
            }
        },
        runDialog: function (message, mode) {
            Metro.infobox.create("<p>" + message + "</p>", mode);
        },
        runToast: function (message, mode) {
            var toast = Metro.toast.create;
            switch (mode) {
                case 'timeout': toast(message, null, 2000, {
                    showTop: true,
                    distance: 60
                }); break;
                default: toast(message, null, 2000, mode, {
                    showTop: false,
                    distance: 60
                });
            }
        }
    }
});


