/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy;

import android.app.Application;
import android.content.res.Configuration;
import com.genesys.gms.mobile.callback.demo.legacy.data.api.CallbackApiManager;
import com.genesys.gms.mobile.callback.demo.legacy.data.api.ChatApiManager;
import com.genesys.gms.mobile.callback.demo.legacy.data.api.GcmManager;
import com.genesys.gms.mobile.callback.demo.legacy.data.capture.CaptureManager;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.OrientationChangeEvent;
import com.genesys.gms.mobile.callback.demo.legacy.util.LogbackFacadeTree;
import dagger.ObjectGraph;
import de.greenrobot.event.EventBus;
import timber.log.Timber;

import javax.inject.Inject;
import java.util.Arrays;
import java.util.List;

/**
 * Callback Sample main application definition
 */
public class App extends Application {
  private ObjectGraph applicationGraph;
  private EventBus bus;
  @Inject
  GcmManager gcmManager;
  @Inject
  CallbackApiManager callbackApiManager;
  @Inject
  ChatApiManager chatApiManager;
  @Inject
  CaptureManager captureManager;

  /** Initialize Dagger DI, EventBus registrations, and Timber logging */
  @Override
  public void onCreate() {
    super.onCreate();
    applicationGraph = ObjectGraph.create(getModules().toArray());
    applicationGraph.inject(this);
    bus = EventBus.getDefault();
    registerManagers();

    if (BuildConfig.DEBUG) {
      // Timber is a logging library which automatically handles tagging
      // The LogbackFacadeTree will log messages to a file (for in-app viewing)
      Timber.plant(new LogbackFacadeTree(new Timber.DebugTree(), this));
    } else {
      // TODO: Figure out release logging
      Timber.plant(new LogbackFacadeTree(new Timber.HollowTree(), this));
    }
  }

  /** Listen for device orientation changes and notify CaptureManager */
  @Override
  public void onConfigurationChanged(Configuration newConfig) {
    // Detect device orientation changes and notify CaptureManager
    super.onConfigurationChanged(newConfig);
    switch (newConfig.orientation) {
      case Configuration.ORIENTATION_LANDSCAPE:
        bus.post(new OrientationChangeEvent(Configuration.ORIENTATION_LANDSCAPE));
        break;
      case Configuration.ORIENTATION_PORTRAIT:
        bus.post(new OrientationChangeEvent(Configuration.ORIENTATION_PORTRAIT));
      default:
    }
  }

  /** Register all manager classes to handle events from EventBus */
  public void registerManagers() {
    bus.register(gcmManager);
    bus.register(callbackApiManager);
    bus.register(chatApiManager);
    bus.register(captureManager);
  }

  /** For Dagger: Return Modules from which an ObjectGraph is to be created */
  protected List<Object> getModules() {
    return Arrays.<Object>asList(new AppModule(this));
  }

  public ObjectGraph getApplicationGraph() {
    return applicationGraph;
  }
}