/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.common;

import android.os.Bundle;
import android.support.v7.app.ActionBarActivity;
import com.genesys.gms.mobile.callback.demo.legacy.App;
import com.genesys.gms.mobile.callback.demo.legacy.ui.UiModule;
import dagger.ObjectGraph;

import java.util.Arrays;
import java.util.List;

/**
 * Created by stau on 11/27/2014.
 */
public class BaseActivity extends ActionBarActivity {
  private ObjectGraph activityGraph;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    App application = (App) getApplication();
    activityGraph = application.getApplicationGraph().plus(getModules().toArray());
    activityGraph.inject(this);
  }

  @Override
  protected void onDestroy() {
    activityGraph = null;
    super.onDestroy();
  }

  protected List<Object> getModules() {
    return Arrays.<Object>asList(new UiModule(this));
  }

  public void inject(Object object) {
    activityGraph.inject(object);
  }
}